import { Property as k, BaseOperator as w, Input as r, Operator as y, DefaultOutput as h } from "@magustek/computing-engine";
var I = Object.defineProperty, g = (e, o, s, l) => {
  for (var t = void 0, i = e.length - 1, a; i >= 0; i--)
    (a = e[i]) && (t = a(o, s, t) || t);
  return t && I(o, s, t), t;
};
class v extends w {
  usePression;
  precision;
  _toPrecision(o) {
    const s = Math.pow(10, this.precision);
    return Math.round(o * s) / s;
  }
  toPrecision(o) {
    return this.usePression ? this._toPrecision(o) : o;
  }
}
g([
  k({
    order: -20,
    name: "使用小数有效位",
    defaultValue: !0,
    type: "select",
    options: [
      { key: "true", label: "使用", value: !0 },
      { key: "true", label: "不使用", value: !1 }
    ]
  })
], v.prototype, "usePression");
g([
  k({ order: -10, name: "小数有效位", defaultValue: 2, type: "number" })
], v.prototype, "precision");
var M = Object.defineProperty, D = Object.getOwnPropertyDescriptor, n = (e, o, s, l) => {
  for (var t = l > 1 ? void 0 : l ? D(o, s) : o, i = e.length - 1, a; i >= 0; i--)
    (a = e[i]) && (t = (l ? a(o, s, t) : a(t)) || t);
  return l && t && M(o, s, t), t;
};
const T = [
  //
  // { key: 'year', label: '年', value: '年' },
  // { key: 'month', label: '月', value: '月' },
  // { key: 'week', label: '周', value: '周' },
  { key: "day", label: "天", value: "day" },
  { key: "hour", label: "时", value: "hour" },
  { key: "minute", label: "分", value: "minute" },
  { key: "second", label: "秒", value: "second" }
], f = {
  // ms: 1,
  second: 1,
  minute: 60,
  hour: 3600,
  day: 3600 * 24
  // w: 1000 * 60 * 60 * 24 * 7,
  // m: 1000 * 60 * 60 * 24 * 30, // 近似值，一个月按30天算
  // y: 1000 * 60 * 60 * 24 * 365, // 非闰年
};
class p extends v {
  value;
}
n([
  r({ order: 10, dataType: "number", name: "值" })
], p.prototype, "value", 2);
let u = class extends p {
  fromUnit;
  toUnit;
  exec() {
    if (this.fromUnit === this.toUnit) return this.value;
    const e = this.value * f[this.fromUnit];
    return this.toPrecision(e / f[this.toUnit]);
  }
};
n([
  r({ order: 20, dataType: "string", name: "数据单位", type: "select", options: T })
], u.prototype, "fromUnit", 2);
n([
  r({ order: 30, dataType: "string", name: "结果单位", type: "select", options: T })
], u.prototype, "toUnit", 2);
u = n([
  y({ name: "时间", description: "1 day = 24 hours = 1440 minutes = 86400 seconds" }),
  h({ name: "值", dataType: "number" })
], u);
const U = { k: 1, w: 10, m: 1e3 }, _ = [
  { key: "k", label: "千", value: "k" },
  { key: "w", label: "万", value: "w" },
  { key: "m", label: "兆", value: "m" }
];
let m = class extends p {
  fromUnit = "";
  toUnit = "";
  exec() {
    if (this.fromUnit === this.toUnit) return this.value;
    const e = this.value * U[this.fromUnit];
    return this.toPrecision(e / U[this.toUnit]);
  }
};
n([
  r({ order: 20, dataType: "string", name: "数据单位", type: "select", options: _ })
], m.prototype, "fromUnit", 2);
n([
  r({ order: 30, dataType: "string", name: "结果单位", type: "select", options: _ })
], m.prototype, "toUnit", 2);
m = n([
  y({ name: "千/万/兆", description: "1 M = 100 W = 1,000 K" }),
  h({ name: "值", dataType: "number" })
], m);
const b = { deg: 1, rad: 180 / Math.PI }, x = [
  { key: "rad", label: "弧度", value: "rad" },
  { key: "deg", label: "角度", value: "deg" }
];
let d = class extends p {
  fromUnit = "";
  toUnit = "";
  exec() {
    if (this.fromUnit === this.toUnit) return this.value;
    const e = this.value * b[this.fromUnit];
    return this.toPrecision(e / b[this.toUnit]);
  }
};
n([
  r({ order: 20, dataType: "string", name: "数据单位", type: "select", options: x })
], d.prototype, "fromUnit", 2);
n([
  r({ order: 30, dataType: "string", name: "结果单位", type: "select", options: x })
], d.prototype, "toUnit", 2);
d = n([
  y({ name: "弧度/角度", description: "1 deg = π / 180 rad" }),
  h({ name: "值", dataType: "number" })
], d);
const P = { mm: 1, cm: 10, dm: 100, m: 1e3, km: 1e6 }, O = [
  { key: "mm", label: "毫米", value: "mm" },
  { key: "cm", label: "厘米", value: "cm" },
  { key: "dm", label: "分米", value: "dm" },
  { key: "m", label: "米", value: "m" },
  { key: "km", label: "千米", value: "km" }
];
let c = class extends p {
  fromUnit = "";
  toUnit = "";
  exec() {
    if (this.fromUnit === this.toUnit) return this.value;
    const e = this.value * P[this.fromUnit];
    return this.toPrecision(e / P[this.toUnit]);
  }
};
n([
  r({ order: 20, dataType: "string", name: "数据单位", type: "select", options: O })
], c.prototype, "fromUnit", 2);
n([
  r({ order: 30, dataType: "string", name: "结果单位", type: "select", options: O })
], c.prototype, "toUnit", 2);
c = n([
  y({ name: "长度", description: "长度单位转换" }),
  h({ name: "值", dataType: "number" })
], c);
export {
  c as Length,
  m as Magnitude,
  d as RadDeg,
  u as Time
};
