import { randomInt as ie } from "node:crypto";
import { Property as re, BaseOperator as X, Input as i, DefaultOutput as a, Operator as t, Output as se } from "@magustek/computing-engine";
var oe = Object.defineProperty, ne = (n, r, s, m) => {
  for (var o = void 0, c = n.length - 1, l; c >= 0; c--)
    (l = n[c]) && (o = l(r, s, o) || o);
  return o && oe(r, s, o), o;
};
let v = class extends X {
  usePression;
  precision;
  _toPrecision(r) {
    const s = Math.pow(10, this.precision);
    return Math.round(r * s) / s;
  }
  toPrecision(r) {
    return this.usePression ? this._toPrecision(r) : r;
  }
};
ne([
  re({
    order: -20,
    name: "使用小数有效位",
    defaultValue: !0,
    type: "select",
    options: [
      { key: "true", label: "使用", value: !0 },
      { key: "true", label: "不使用", value: !1 }
    ]
  })
], v.prototype, "usePression");
ne([
  re({ order: -10, name: "小数有效位", defaultValue: 2, type: "number" })
], v.prototype, "precision");
var me = Object.defineProperty, ue = Object.getOwnPropertyDescriptor, e = (n, r, s, m) => {
  for (var o = m > 1 ? void 0 : m ? ue(r, s) : r, c = n.length - 1, l; c >= 0; c--)
    (l = n[c]) && (o = (m ? l(r, s, o) : l(o)) || o);
  return m && o && me(r, s, o), o;
};
class f extends v {
  toSafeArray(r) {
    return r.map((s) => parseFloat(String(s))).filter((s) => !Number.isNaN(s));
  }
  sumArray(r) {
    return r.reduce((s, m) => s + m, 0);
  }
}
class d extends f {
  array;
  get safeArray() {
    return this.toSafeArray(this.array);
  }
  get sum() {
    return this.sumArray(this.safeArray);
  }
  get avg() {
    return this.sum / this.safeArray.length;
  }
  /**
   * 标准差
   */
  get variance() {
    const r = this.avg;
    return this.sumArray(this.safeArray.map((m) => Math.pow(m - r, 2))) / this.safeArray.length;
  }
  /**
   * 方差
   */
  get deviation() {
    return Math.sqrt(this.variance);
  }
  get max() {
    return Math.max(...this.safeArray);
  }
  get min() {
    return Math.min(...this.safeArray);
  }
  /**
   * 中值
   */
  get median() {
    const r = this.safeArray.sort((m, o) => m - o), s = r.length;
    return s % 2 === 1 ? r[Math.floor(s / 2)] : (r[s / 2 - 1] + r[s / 2]) / 2;
  }
}
e([
  i({ order: 10, name: "数组", dataType: "array", type: "text" })
], d.prototype, "array", 2);
class u extends f {
  x;
  get safeX() {
    return parseFloat(String(this.x)) || 0;
  }
}
e([
  i({ order: 10, dataType: "number", name: "x", type: "number" })
], u.prototype, "x", 2);
class M extends f {
  x;
  get safeX() {
    return parseFloat(String(this.x)) || 0;
  }
}
e([
  i({ order: 10, dataType: "number", name: "弧度", type: "number" })
], M.prototype, "x", 2);
class p extends u {
  y;
  get safeY() {
    return parseFloat(String(this.y)) || 0;
  }
}
e([
  i({ order: 20, dataType: "number", name: "y", type: "number" })
], p.prototype, "y", 2);
class y extends X {
  x;
  y;
  get safeX() {
    return parseFloat(String(this.x)) || 0;
  }
  get safeY() {
    return parseFloat(String(this.y)) || 0;
  }
}
e([
  i({ order: 10, dataType: "number", name: "x", type: "number" })
], y.prototype, "x", 2);
e([
  i({ order: 20, dataType: "number", name: "y", type: "number" })
], y.prototype, "y", 2);
let S = class extends p {
  exec() {
    return this.toPrecision(this.safeX + this.safeY);
  }
};
S = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "加法", description: "加法计算" })
], S);
let w = class extends p {
  exec() {
    return this.toPrecision(this.safeX * this.safeY);
  }
};
w = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "乘法", description: "乘法计算" })
], w);
let b = class extends p {
  x = 0;
  y = 0;
  exec() {
    return this.toPrecision(this.safeX - this.safeY);
  }
};
e([
  i({ order: 10, dataType: "number", name: "被减数", type: "number" })
], b.prototype, "x", 2);
e([
  i({ order: 20, dataType: "number", name: "减数", type: "number" })
], b.prototype, "y", 2);
b = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "减法", description: "减法计算（x - y）" })
], b);
let h = class extends p {
  x = 0;
  y = 0;
  async exec() {
    return Promise.resolve(this.toPrecision(this.safeX / this.safeY));
  }
};
e([
  i({ order: 10, dataType: "number", name: "被除数", type: "number" })
], h.prototype, "x", 2);
e([
  i({ order: 20, dataType: "number", name: "除数", type: "number" })
], h.prototype, "y", 2);
h = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "除法", description: "除法计算（x / y）" })
], h);
let T = class extends p {
  x = 0;
  y = 0;
  exec() {
    return this.toPrecision(Math.pow(this.safeX, this.safeY));
  }
};
e([
  i({ order: 10, dataType: "number", name: "底数", type: "number" })
], T.prototype, "x", 2);
e([
  i({ order: 20, dataType: "number", name: "指数", type: "number" })
], T.prototype, "y", 2);
T = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "指数运算", description: "幂运算" })
], T);
let Y = class extends p {
  exec() {
    const n = this.getInputs().map((r) => r.getValue());
    return this.toPrecision(this.sumArray(this.toSafeArray(n)));
  }
};
Y = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "求和", description: "求和", allowAddInput: !0 })
], Y);
let O = class extends p {
  exec() {
    const n = this.getInputs().map((m) => m.getValue()), r = this.toSafeArray(n), s = this.sumArray(r);
    return this.toPrecision(s / r.length);
  }
};
O = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "平均", description: "平均", allowAddInput: !0 })
], O);
let I = class extends p {
  exec() {
    return Math.max(...this.toSafeArray(this.getInputs().map((n) => n.getValue())));
  }
};
I = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "最大值", description: "最大值", allowAddInput: !0 })
], I);
let V = class extends p {
  exec() {
    return Math.min(...this.toSafeArray(this.getInputs().map((n) => n.getValue())));
  }
};
V = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "最小值", description: "最小值", allowAddInput: !0 })
], V);
let P = class extends h {
  remainder;
  quotient;
  exec() {
    const n = this.safeX % this.safeY, r = Math.floor(this.safeX / this.safeY);
    this.getOutputByKey("remainder").setValue(n), this.getOutputByKey("quotient").setValue(r);
  }
};
e([
  se({ order: 10, name: "余数", dataType: "number" })
], P.prototype, "remainder", 2);
e([
  se({ order: 20, name: "商", dataType: "number" })
], P.prototype, "quotient", 2);
P = e([
  t({ name: "余商", description: "余商", execResultAsDefaultOutput: !1 })
], P);
let _ = class extends d {
  exec() {
    return this.toPrecision(this.max);
  }
};
_ = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "数组最大值", description: "数组最大值" })
], _);
let B = class extends d {
  exec() {
    return this.toPrecision(this.min);
  }
};
B = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "数组最小值", description: "数组最小值" })
], B);
let R = class extends d {
  exec() {
    return this.toPrecision(this.sum);
  }
};
R = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "数组求和", description: "数组求和" })
], R);
let q = class extends d {
  exec() {
    return this.toPrecision(this.avg);
  }
};
q = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "数组平均", description: "数组平均" })
], q);
let D = class extends d {
  exec() {
    return this.toPrecision(this.variance);
  }
};
D = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "方差", description: "方差" })
], D);
let F = class extends d {
  exec() {
    return this.toPrecision(Math.sqrt(this.variance));
  }
};
F = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "标准差", description: "标准差" })
], F);
let N = class extends d {
  exec() {
    return this.toPrecision(this.median);
  }
};
N = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "中值", description: "中值" })
], N);
let C = class extends f {
  exec() {
    return this.toPrecision(Math.PI);
  }
};
C = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "PI", description: "π 值" })
], C);
let j = class extends u {
  exec() {
    return this.toPrecision(Math.sqrt(this.safeX));
  }
};
j = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "平方根", description: "平方根" })
], j);
let $ = class extends u {
  exec() {
    return this.toPrecision(Math.abs(this.safeX));
  }
};
$ = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "绝对值", description: "绝对值" })
], $);
let K = class extends u {
  exec() {
    return this.toPrecision(Math.floor(this.safeX));
  }
};
K = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "向下取整", description: "向下取整" })
], K);
let L = class extends u {
  exec() {
    return this.toPrecision(Math.ceil(this.safeX));
  }
};
L = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "向上取整", description: "向上取整" })
], L);
let Q = class extends u {
  exec() {
    return this.toPrecision(this.safeX);
  }
};
Q = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "四舍五入", description: "四舍五入" })
], Q);
let U = class extends M {
  exec() {
    return this.toPrecision(Math.sin(this.safeX));
  }
};
U = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "正弦", description: "正弦" })
], U);
let z = class extends u {
  exec() {
    return this.toPrecision(Math.asin(this.safeX));
  }
};
z = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "反正弦", description: "反正弦" })
], z);
let E = class extends M {
  exec() {
    return this.toPrecision(Math.cos(this.safeX));
  }
};
E = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "余弦", description: "余弦" })
], E);
let G = class extends u {
  exec() {
    return this.toPrecision(Math.acos(this.safeX));
  }
};
G = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "反余弦", description: "反余弦" })
], G);
let H = class extends M {
  exec() {
    return this.toPrecision(Math.tan(this.safeX));
  }
};
H = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "正切", description: "正切" })
], H);
let J = class extends u {
  exec() {
    return this.toPrecision(Math.atan(this.safeX));
  }
};
J = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "反正切", description: "正切" })
], J);
let W = class extends y {
  exec() {
    return this.safeX & this.safeY;
  }
};
W = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "按位与", description: "按位与" })
], W);
let Z = class extends y {
  exec() {
    return this.safeX | this.safeY;
  }
};
Z = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "按位或", description: "按位或" })
], Z);
let k = class extends u {
  exec() {
    return ~this.safeX;
  }
};
k = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "按位非", description: "按位非" })
], k);
let ee = class extends y {
  exec() {
    return this.safeX ^ this.safeY;
  }
};
ee = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "按位异或", description: "按位异或" })
], ee);
let te = class extends y {
  exec() {
    return this.safeX << this.safeY;
  }
};
te = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "左移", description: "左移" })
], te);
let x = class extends y {
  x = 0;
  y = 0;
  exec() {
    return this.safeX >> this.safeY;
  }
};
e([
  i({ order: 10, dataType: "number", name: "数值", type: "number" })
], x.prototype, "x", 2);
e([
  i({ order: 20, dataType: "number", name: "右移位数", type: "number" })
], x.prototype, "y", 2);
x = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "右移", description: "右移 x >> y" })
], x);
let ae = class extends x {
  exec() {
    return this.safeX >>> this.safeY;
  }
};
ae = e([
  a({ name: "结果", dataType: "number" }),
  t({ name: "无符号右移", description: "无符号右移 x >>> y" })
], ae);
let g = class extends f {
  min;
  max;
  exec() {
    return this.toPrecision(Math.random() * (this.max - this.min) + this.min);
  }
};
e([
  i({ order: 10, dataType: "number", name: "最小值", type: "number", defaultValue: 0 })
], g.prototype, "min", 2);
e([
  i({ order: 20, dataType: "number", name: "最大值", type: "number", defaultValue: 1 })
], g.prototype, "max", 2);
g = e([
  a({ name: "随机数", dataType: "number" }),
  t({ name: "随机数", description: "随机数" })
], g);
let A = class extends X {
  min;
  max;
  exec() {
    return ie(this.min, this.max);
  }
};
e([
  i({ order: 10, dataType: "number", name: "最小值", type: "number", defaultValue: 0 })
], A.prototype, "min", 2);
e([
  i({ order: 20, dataType: "number", name: "最大值", type: "number", defaultValue: 100 })
], A.prototype, "max", 2);
A = e([
  a({ name: "随机整数", dataType: "number" }),
  t({ name: "随机整数", description: "随机整数" })
], A);
export {
  $ as Abs,
  G as Acos,
  S as Add,
  z as Asin,
  J as Atan,
  q as Avg,
  W as BitwiseAND,
  k as BitwiseNOT,
  Z as BitwiseOR,
  ee as BitwiseXOR,
  L as Ceil,
  E as Cos,
  F as Deviation,
  h as Division,
  O as DynamicAvg,
  K as Floor,
  te as LeftShift,
  I as Max,
  _ as MaxArray,
  N as Median,
  V as Min,
  B as MinArray,
  w as Multiply,
  C as PI,
  T as Power,
  g as Random,
  A as RandomInt,
  P as RemainderAndQuotient,
  x as RightShift,
  Q as Round,
  U as Sin,
  j as Sqrt,
  b as Substract,
  Y as Sum,
  R as SumArray,
  H as Tan,
  ae as UnsignedRightShift,
  D as Variance
};
