import { Output as n, Operator as d, Input as s, DefaultOutput as g, BaseOperator as y } from "@magustek/computing-engine";
import i from "dayjs";
var R = Object.defineProperty, k = Object.getOwnPropertyDescriptor, e = (t, a, r, m) => {
  for (var o = m > 1 ? void 0 : m ? k(a, r) : a, u = t.length - 1, h; u >= 0; u--)
    (h = t[u]) && (o = (m ? h(a, r, o) : h(o)) || o);
  return m && o && R(a, r, o), o;
};
const p = "YYYY-MM-DD HH:mm:ss";
let T = class extends y {
  datetime;
  date;
  time;
  exec() {
    const t = i().format(p), a = t.slice(0, 10), r = t.slice(11, 19);
    return this.getOutputByKey("datetime").setValue(t), this.getOutputByKey("date").setValue(a), this.getOutputByKey("time").setValue(r), i().format(p);
  }
};
e([
  n({ order: 10, dataType: "string", name: "日期时间", description: "格式：1997-01-01 00:00:00" })
], T.prototype, "datetime", 2);
e([
  n({ order: 20, dataType: "string", name: "日期", description: "格式：1997-01-01" })
], T.prototype, "date", 2);
e([
  n({ order: 30, dataType: "string", name: "时间", description: "格式：00:00:00" })
], T.prototype, "time", 2);
T = e([
  d({ name: "当前时间", description: "系统当前时间(算子实际开始运行的时间)", execResultAsDefaultOutput: !1 })
], T);
let f = class extends y {
  datetime;
  date;
  time;
  exec() {
    const t = this.getGlobalData("triggerTime", i().format(p)), a = t.slice(0, 10), r = t.slice(11, 19);
    return this.getOutputByKey("datetime").setValue(t), this.getOutputByKey("date").setValue(a), this.getOutputByKey("time").setValue(r), t;
  }
};
e([
  n({ order: 10, dataType: "string", name: "日期时间", description: "格式：1997-01-01 00:00:00" })
], f.prototype, "datetime", 2);
e([
  n({ order: 20, dataType: "string", name: "日期", description: "格式：1997-01-01" })
], f.prototype, "date", 2);
e([
  n({ order: 30, dataType: "string", name: "时间", description: "00:00:00" })
], f.prototype, "time", 2);
f = e([
  d({ name: "获取任务调度时间", description: "获取任务调度时间", execResultAsDefaultOutput: !1 })
], f);
class b extends y {
  startTime;
  endTime;
}
e([
  s({ order: 10, dataType: "string", name: "开始时间", type: "datetime", description: "1997-01-01 00:00:00" })
], b.prototype, "startTime", 2);
e([
  s({ order: 20, dataType: "string", name: "结束时间", type: "datetime", description: "1997-01-01 00:00:00" })
], b.prototype, "endTime", 2);
let w = class extends b {
  exec() {
    return [i(this.startTime).format(p), i(this.endTime).format(p)];
  }
};
w = e([
  d({ name: "时间范围", description: "从指定开始时间到结束时间的时间范围" }),
  g({
    name: "时间范围",
    dataType: "array",
    description: '输出示例：["1997-01-01 00:00:00", "1997-01-01 01:00:00"]'
  })
], w);
let c = class extends y {
  duration;
  unit;
  start;
  end;
  exec() {
    const t = this.getGlobalData("triggerTime", i().format(p)), [a, r] = this.getTimeRange(t);
    return this.getOutputByKey("start").setValue(a), this.getOutputByKey("end").setValue(r), null;
  }
  getTimeRange(t) {
    const a = parseFloat(String(this.duration)), r = i(t || void 0);
    return [r.subtract(a, this.unit).add(1, "second").format(p), r.format(p)];
  }
};
e([
  s({ order: 10, name: "前多长时间", dataType: "number", type: "number" })
], c.prototype, "duration", 2);
e([
  s({
    order: 20,
    dataType: "string",
    name: "单位",
    type: "select",
    options: [
      { key: "month", label: "月", value: "month" },
      { key: "day", label: "天", value: "day" },
      { key: "hour", label: "小时", value: "hour" },
      { key: "minute", label: "分钟", value: "minute" },
      { key: "second", label: "秒", value: "second" }
    ]
  })
], c.prototype, "unit", 2);
e([
  n({ order: 10, name: "开始时间", dataType: "string" })
], c.prototype, "start", 2);
e([
  n({ order: 20, name: "结束时间", dataType: "string" })
], c.prototype, "end", 2);
c = e([
  d({
    name: "截止到当前时间",
    description: "从任务执行时间往前推算出的一个时间段",
    execResultAsDefaultOutput: !1
  })
], c);
let v = class extends c {
  endTime;
  exec() {
    const t = i(this.endTime || void 0), [a, r] = this.getTimeRange(t);
    return this.getOutputByKey("start").setValue(a), this.getOutputByKey("end").setValue(r), null;
  }
};
e([
  s({ order: 30, name: "截止时间", dataType: "string", type: "datetime", description: "1997-01-01 00:00:00" })
], v.prototype, "endTime", 2);
v = e([
  d({
    name: "截止到某个时间",
    description: "从给定截止时间往前推算出的一个时间段",
    execResultAsDefaultOutput: !1
  })
], v);
let V = class extends y {
  date;
  time;
  exec() {
    const t = i(this.date + " " + this.time);
    if (t.isValid()) return t.format(p);
    throw new Error("日期时间错误");
  }
};
e([
  s({ dataType: "string", name: "日期", description: "示例：1997-01-01", type: "date" })
], V.prototype, "date", 2);
e([
  s({ dataType: "string", name: "时间", description: "示例：00:00:00", type: "time" })
], V.prototype, "time", 2);
V = e([
  d({ name: "日期时间", description: "指定日期和时间" }),
  g({ name: "日期时间", dataType: "string", description: "输出示例：1997-01-01 00:00:00" })
], V);
let B = class extends y {
  date;
  time;
  exec() {
    const t = i(this.date + " " + this.time);
    if (!t.isValid()) throw new Error("日期时间错误");
    const a = this.getGlobalData("triggerTime", i().format(p));
    return [t.format(p), a];
  }
};
e([
  s({ dataType: "string", name: "日期", description: "示例：1997-01-01", type: "date" })
], B.prototype, "date", 2);
e([
  s({ dataType: "string", name: "时间", description: "示例：00:00:00", type: "time" })
], B.prototype, "time", 2);
B = e([
  d({ name: "从过去到现在", description: "从给定开始时间到任务开始执行(现在)时间" }),
  g({
    name: "时间范围",
    dataType: "array",
    description: '输出示例：["1997-01-01 00:00:00", "1997-01-01 01:00:00"]'
  })
], B);
let K = class extends b {
  unit;
  exec() {
    return i(this.endTime).diff(i(this.startTime), this.unit);
  }
};
e([
  s({
    dataType: "string",
    name: "单位",
    type: "select",
    defaultValue: "s",
    options: [
      { key: "s", label: "秒", value: "s" },
      { key: "minute", label: "分钟", value: "minute" },
      { key: "hour", label: "小时", value: "hour" },
      { key: "day", label: "天", value: "day" }
    ]
  })
], K.prototype, "unit", 2);
K = e([
  d({ name: "计算时长", description: "计算两个时间差值" }),
  g({ name: "时长", dataType: "number" })
], K);
let O = class extends y {
  year;
  month;
  day;
  exec() {
    const t = i(this.year + "-" + this.month + "-" + this.day);
    if (t.isValid()) return t.format("YYYY-MM-DD");
    throw new Error("日期时间错误");
  }
};
e([
  s({ order: 10, dataType: "string", name: "年", type: "string" })
], O.prototype, "year", 2);
e([
  s({ order: 20, dataType: "string", name: "月", type: "string" })
], O.prototype, "month", 2);
e([
  s({ order: 30, dataType: "string", name: "日", type: "string" })
], O.prototype, "day", 2);
O = e([
  d({ name: "指定日期", description: "指定日期" }),
  g({ name: "日期", dataType: "string", description: "输出示例：1997-01-01" })
], O);
const Y = (t, a, r) => {
  const m = [];
  for (let o = t; o < a; o += r) {
    const u = String(o).padStart(2, "0");
    m.push({ key: u, label: u, value: u });
  }
  return m;
};
let x = class extends y {
  hour;
  minute;
  second;
  exec() {
    return this.hour + ":" + this.minute + ":" + this.second;
  }
};
e([
  s({ order: 10, dataType: "string", name: "时", type: "select", options: Y(0, 24, 1) })
], x.prototype, "hour", 2);
e([
  s({ order: 20, dataType: "string", name: "分", type: "select", options: Y(0, 60, 1) })
], x.prototype, "minute", 2);
e([
  s({ order: 30, dataType: "string", name: "秒", type: "select", options: Y(0, 60, 1) })
], x.prototype, "second", 2);
x = e([
  d({ name: "指定时间", description: "指定时间" }),
  g({ name: "时间", dataType: "string", description: "输出示例：00:00:00" })
], x);
let l = class extends y {
  datetime;
  year;
  month;
  day;
  hour;
  minute;
  second;
  exec() {
    const t = i(this.datetime);
    if (!t.isValid()) throw new Error("日期时间错误");
    const a = t.format("YYYY"), r = t.format("MM"), m = t.format("DD"), o = t.format("HH"), u = t.format("mm"), h = t.format("ss");
    return this.getOutputByKey("year").setValue(a), this.getOutputByKey("month").setValue(r), this.getOutputByKey("day").setValue(m), this.getOutputByKey("hour").setValue(o), this.getOutputByKey("minute").setValue(u), this.getOutputByKey("second").setValue(h), null;
  }
};
e([
  s({ order: 10, dataType: "string", name: "日期时间", type: "datetime" })
], l.prototype, "datetime", 2);
e([
  n({ order: 10, dataType: "string", name: "年" })
], l.prototype, "year", 2);
e([
  n({ order: 20, dataType: "string", name: "月" })
], l.prototype, "month", 2);
e([
  n({ order: 30, dataType: "string", name: "日" })
], l.prototype, "day", 2);
e([
  n({ order: 40, dataType: "string", name: "时" })
], l.prototype, "hour", 2);
e([
  n({ order: 50, dataType: "string", name: "分" })
], l.prototype, "minute", 2);
e([
  n({ order: 60, dataType: "string", name: "秒" })
], l.prototype, "second", 2);
l = e([
  d({ name: "拆分年月日时分秒", description: "拆分日期时间", execResultAsDefaultOutput: !1 })
], l);
let D = class extends y {
  datetime;
  date;
  time;
  exec() {
    const t = i(this.datetime);
    if (!t.isValid()) throw new Error("日期时间错误");
    const a = t.format("YYYY-MM-DD"), r = t.format("HH:mm:ss");
    return this.getOutputByKey("date").setValue(a), this.getOutputByKey("time").setValue(r), null;
  }
};
e([
  s({ order: 10, dataType: "string", name: "日期时间", type: "datetime" })
], D.prototype, "datetime", 2);
e([
  n({ order: 10, dataType: "string", name: "日期" })
], D.prototype, "date", 2);
e([
  n({ order: 20, dataType: "string", name: "时间" })
], D.prototype, "time", 2);
D = e([
  d({ name: "拆分日期时间", description: "分割日期时间2", execResultAsDefaultOutput: !1 })
], D);
export {
  c as BeforeTime,
  K as Count,
  O as DatePicker,
  V as DateTime,
  v as Deadline,
  B as FromDate,
  T as Now,
  f as PickTaskScheduleTime,
  l as SplitDatetime,
  D as SplitDatetime2,
  x as TimePicker,
  w as TimeRange
};
