import { randomUUID as h } from "node:crypto";
import { Input as d, Output as v, Operator as u, DefaultOutput as C, InternalDatabase as g } from "@magustek/computing-engine";
import T from "dayjs";
var D = Object.defineProperty, f = Object.getOwnPropertyDescriptor, a = (t, o, i, r) => {
  for (var e = r > 1 ? void 0 : r ? f(o, i) : o, s = t.length - 1, p; s >= 0; s--)
    (p = t[s]) && (e = (r ? p(o, i, e) : p(e)) || e);
  return r && e && D(o, i, e), e;
};
class c extends g {
  tableName = "iot_equipment_form";
  productCode;
  deviceCode;
  propertyCode;
  getDeviceCode() {
    return this.deviceCode || this.getBizData("iot.deviceCode", "");
  }
}
a([
  d({ order: 1, dataType: "string", name: "产品编码", type: "iot.productCode" })
], c.prototype, "productCode", 2);
a([
  d({ order: 10, dataType: "string", name: "设备编码", type: "iot.deviceCode" })
], c.prototype, "deviceCode", 2);
a([
  d({ order: 20, dataType: "string", name: "属性编码", type: "iot.propertyCode" })
], c.prototype, "propertyCode", 2);
let l = class extends c {
  value;
  unit;
  async exec() {
    const o = `${this.getDeviceCode()}_${this.propertyCode}`, {
      data_type_: i,
      unit_: r,
      value_: e
    } = await this.createQueryBuilder("form").select(["form.data_type_", "form.unit_", "form.value_"]).where("form.global_code_ = :globalCode", { globalCode: o }).getOne() || {};
    return this.getOutputByKey("unit").setValue(r), this.getOutputByKey("value").setValue(i === "Number" ? Number(e) : String(e || "")), null;
  }
};
a([
  v({ order: 10, dataType: "string", name: "属性值" })
], l.prototype, "value", 2);
a([
  v({ order: 20, dataType: "string", name: "单位" })
], l.prototype, "unit", 2);
l = a([
  u({
    name: "静态属性",
    description: "输出属性的实际值和单位",
    execResultAsDefaultOutput: !1,
    type: "iot.StaticProperty"
  })
], l);
let _ = class extends c {
  exec() {
    const t = this.getGlobalData("compCode", ""), o = this.getDeviceCode();
    if (o) return `${t}.node1.${o}_${this.propertyCode}`.toUpperCase();
    throw new Error("未找到设备编码");
  }
  static registerNode(t, o, i) {
    const r = i.getGlobalData("compCode", ""), e = t.getInput("deviceCode")?.getFormatedValue() || "", s = t.getInput("propertyCode")?.getFormatedValue() || "", p = `${r}.node1.${e}_${s}`.toUpperCase();
    i.registerRtGn([p]);
  }
};
_ = a([
  u({ name: "动态属性", description: "输出属性对应的实时库点名", type: "iot.DynamicProperty" }),
  C({ dataType: "string", name: "点名", description: "实时库点名" })
], _);
class n extends g {
  tableName = "indicator_data_dw";
  productCode;
  indicatorDef;
  valueType;
  timeType;
  deviceCode;
  datetime;
  format = {
    HOUR: "YYYY-MM-DD HH",
    DAY: "YYYY-MM-DD",
    MONTH: "YYYY-MM",
    QUARTER: "YYYY-Q",
    YEAR: "YYYY"
  };
  getInstCode() {
    return `${this.indicatorDef}_${this.timeType}_${this.valueType}_${this.deviceCode}`;
  }
  getDate() {
    return T(this.datetime || void 0).format(this.format[this.timeType]);
  }
}
a([
  d({ order: 1, dataType: "string", name: "产品编码", type: "iot.productCode" })
], n.prototype, "productCode", 2);
a([
  d({ order: 10, dataType: "string", name: "指标定义" })
], n.prototype, "indicatorDef", 2);
a([
  d({
    order: 20,
    dataType: "string",
    name: "数值类型",
    type: "select",
    options: [
      { key: "NUMBER", label: "数值", value: "NUMBER" },
      { key: "TEXT", label: "文本", value: "TEXT" }
    ]
  })
], n.prototype, "valueType", 2);
a([
  d({
    order: 30,
    dataType: "string",
    name: "时间类型",
    type: "select",
    options: [
      { key: "HOUR", label: "小时", value: "HOUR" },
      { key: "DAY", label: "日", value: "DAY" },
      { key: "MONTH", label: "月", value: "MONTH" },
      { key: "QUARTER", label: "季度", value: "QUARTER" },
      { key: "YEAR", label: "年", value: "YEAR" }
    ]
  })
], n.prototype, "timeType", 2);
a([
  d({ order: 40, dataType: "string", name: "设备编码", type: "iot.deviceCode" })
], n.prototype, "deviceCode", 2);
a([
  d({ order: 50, dataType: "string", name: "时间", type: "datetime" })
], n.prototype, "datetime", 2);
let m = class extends n {
  async exec() {
    const t = this.getInstCode(), o = this.getDate(), { value_: i, value_type_: r } = await this.createQueryBuilder("indicator").select(["indicator.value_", "indicator.value_type_"]).where("indicator.indicator_instance_code_ = :code", { code: t }).andWhere("indicator.data_time_ = :date", { date: o }).getOne() || {};
    return r === "NUMBER" ? Number(i) : String(i || "");
  }
};
m = a([
  u({
    name: "查指标",
    description: "查指标",
    execResultAsDefaultOutput: { name: "指标值" },
    type: "iot.ReadArchiveIndicator"
  })
], m);
let y = class extends n {
  value;
  async exec() {
    const t = this.getInstCode(), o = this.getDate(), r = await this.createQueryBuilder("inst", "indicator_indicator_instance").select("inst.id").where("inst.code_ = :code", { code: t }).getOne();
    let e = await this.getRepository().findOneBy({
      indicator_instance_code_: t,
      data_time_: o
    });
    return e || (e = { id: h() }), e.indicator_definition_code_ = this.indicatorDef, e.indicator_instance_code_ = t, e.indicator_instance_id_ = r?.id || null, e.value_type_ = this.valueType, e.data_time_ = o, e.value_ = this.valueType === "NUMBER" && Number(this.value) || null, e.str_value_ = this.valueType === "TEXT" ? String(this.value) : null, e.time_value_ = this.valueType === "DATETIME" ? this.value : null, e.create_by_ = this.getGlobalData("loginId", ""), e.deleted = !1, await this.getRepository().save(e), 0;
  }
};
a([
  d({ order: 60, dataType: ["number", "string"], name: "指标值" })
], y.prototype, "value", 2);
y = a([
  u({
    name: "写指标",
    description: "写指标",
    execResultAsDefaultOutput: !1,
    type: "iot.WriteArchiveIndicator"
  })
], y);
export {
  _ as DynamicProperty,
  m as ReadArchiveIndicator,
  l as StaticProperty,
  y as WriteArchiveIndicator
};
