import __path from "node:path";
import { fileURLToPath as __fileURLToPath } from "node:url";
import { createRequire as __createRequire } from "node:module";
const __getFilename = () => __fileURLToPath(import.meta.url);
const __getDirname = () => __path.dirname(__getFilename());
const __dirname = __getDirname();
const __filename = __getFilename();
const self = globalThis;
const require2 = __createRequire(import.meta.url);
import { i as isNil, m as merge } from "./node_modules/lodash-es-C29k4ypb.js";
import { d as getDefaultExportFromCjs, e as builtExports } from "./node_modules/ioredis-CHqp1UXI.js";
import { cq as requireMysql, cr as requireMysql2, aQ as PrimaryGeneratedColumn, aO as CreateDateColumn, aN as Column, aS as UpdateDateColumn, aP as DeleteDateColumn, bf as Entity, bZ as BaseEntity$1, bn as Index, bl as TreeChildren, bk as TreeParent, bm as Tree, ba as ManyToOne, b7 as JoinColumn, be as RelationId, b1 as BeforeInsert, b5 as BeforeUpdate, b2 as BeforeRemove, bc as OneToOne, bb as OneToMany, D as DataSource } from "./node_modules/typeorm-C8yhfXOi.js";
import { existsSync, readFileSync } from "node:fs";
import { mkdir, writeFile, rm } from "node:fs/promises";
import require$$2 from "node:path";
import require$$1 from "dayjs";
import { randomUUID } from "node:crypto";
var mysqlExports = requireMysql();
const mysql = /* @__PURE__ */ getDefaultExportFromCjs(mysqlExports);
var mysql2Exports = requireMysql2();
const mysql2 = /* @__PURE__ */ getDefaultExportFromCjs(mysql2Exports);
const dateTimeFormat = (date, ms = true) => {
  return require$$1(date || void 0).format(`YYYY-MM-DD HH:mm:ss${ms ? ".SSS" : ""}`);
};
const createDateTransformer = () => {
  return {
    to: (val) => !val ? dateTimeFormat(/* @__PURE__ */ new Date()) : val,
    from: (val) => val ? dateTimeFormat(val, false) : void 0
  };
};
const updateDateTransformer = () => {
  return {
    to: () => dateTimeFormat(/* @__PURE__ */ new Date()),
    from: (val) => val ? dateTimeFormat(val, false) : void 0
  };
};
const dateTransformer = (toMs = false, fromMs = false) => {
  return {
    to: (val) => val ? dateTimeFormat(val, toMs) : void 0,
    from: (val) => val ? dateTimeFormat(val, fromMs) : void 0
  };
};
const jsonTransformer = () => {
  return {
    to: (val) => isNil(val) ? null : JSON.stringify(val, null, 0),
    from: (val) => isNil(val) ? null : JSON.parse(val)
  };
};
const dataTypeTransformer = () => {
  return {
    to: (val) => {
      return val ? JSON.stringify(val) : null;
    },
    from: (val) => {
      try {
        const parseValue = JSON.parse(val);
        if (Array.isArray(parseValue)) return parseValue.filter(Boolean);
        else return [parseValue].filter(Boolean);
      } catch {
        return [val].filter(Boolean);
      }
    }
  };
};
const durationTransformer = () => {
  return {
    from: (val) => val,
    to: (ms) => {
      if (ms === 0) return "0ms";
      if (!ms) return null;
      const hours = Math.floor(ms / (1e3 * 60 * 60));
      const minutes = Math.floor(ms % (1e3 * 60 * 60) / (1e3 * 60));
      const seconds = Math.floor(ms % (1e3 * 60) / 1e3);
      const milliseconds = ms % 1e3;
      const parts = [];
      if (hours > 0) parts.push(`${hours}h`);
      if (minutes > 0) parts.push(`${minutes}min`);
      if (seconds > 0) parts.push(`${seconds}s`);
      if (milliseconds > 0) parts.push(`${milliseconds}ms`);
      return parts.join("");
    }
  };
};
const fileTransformer = () => {
  return {
    to: (val) => val,
    from: (val) => {
      if (existsSync(val)) {
        return readFileSync(val, { encoding: "utf-8" });
      }
      return val;
    }
  };
};
const saveFile = async (filePath, content) => {
  if (!content) return;
  const dir = require$$2.parse(filePath).dir;
  if (!existsSync(dir)) await mkdir(dir, { recursive: true });
  await writeFile(filePath, content, { encoding: "utf-8" });
};
const isMysql = () => {
  return `${process.env.VITE_APP_DATASOURCE_TYPE || ""}`.toLowerCase() === "mysql";
};
var __defProp$g = Object.defineProperty;
var __getOwnPropDesc$g = Object.getOwnPropertyDescriptor;
var __decorateClass$g = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$g(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$g(target, key, result);
  return result;
};
let BaseEntity = class extends BaseEntity$1 {
  id;
  createDate;
  createBy;
  compCode;
  compId;
  lastModifiedDate;
  lastModifiedBy;
  deletedDate;
  deletedBy;
  remark;
  // @BeforeInsert()
  // beforeInsert() {
  //   this.createDate = void 0
  //   this.lastModifiedDate = void 0
  //   this.deletedDate = void 0
  // }
  // @BeforeUpdate()
  // beforeUpdate() {
  //   this.createDate = void 0
  //   this.lastModifiedDate = void 0
  //   this.deletedDate = void 0
  // }
};
__decorateClass$g([
  PrimaryGeneratedColumn("uuid")
], BaseEntity.prototype, "id", 2);
__decorateClass$g([
  CreateDateColumn({ name: "create_date_", transformer: createDateTransformer() })
], BaseEntity.prototype, "createDate", 2);
__decorateClass$g([
  Column({ name: "create_by_", type: "varchar", nullable: true, update: false })
], BaseEntity.prototype, "createBy", 2);
__decorateClass$g([
  Column({ name: "comp_code_", type: "varchar", nullable: true, update: false })
], BaseEntity.prototype, "compCode", 2);
__decorateClass$g([
  Column({ name: "comp_id_", type: "varchar", nullable: true, update: false })
], BaseEntity.prototype, "compId", 2);
__decorateClass$g([
  UpdateDateColumn({ name: "last_modified_date_", transformer: updateDateTransformer() })
], BaseEntity.prototype, "lastModifiedDate", 2);
__decorateClass$g([
  Column({ name: "last_modified_by_", type: "varchar", nullable: true })
], BaseEntity.prototype, "lastModifiedBy", 2);
__decorateClass$g([
  DeleteDateColumn({ name: "deleted_date_", transformer: dateTransformer() })
], BaseEntity.prototype, "deletedDate", 2);
__decorateClass$g([
  Column({ name: "deleted_by_", type: "varchar", nullable: true })
], BaseEntity.prototype, "deletedBy", 2);
__decorateClass$g([
  Column({ type: "varchar", nullable: true })
], BaseEntity.prototype, "remark", 2);
BaseEntity = __decorateClass$g([
  Entity({ orderBy: { updatedAt: "DESC" }, name: "base_entity" })
], BaseEntity);
var __defProp$f = Object.defineProperty;
var __getOwnPropDesc$f = Object.getOwnPropertyDescriptor;
var __decorateClass$f = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$f(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$f(target, key, result);
  return result;
};
let Log = class extends BaseEntity {
  taskId;
  sort;
  taskInstId;
  modelDefId;
  modelInstanceId;
  timestamp;
  level;
  label;
  message;
  data;
};
__decorateClass$f([
  Column({ name: "task_id", type: "varchar", nullable: true })
], Log.prototype, "taskId", 2);
__decorateClass$f([
  Column({ name: "sort", type: "int", nullable: true })
], Log.prototype, "sort", 2);
__decorateClass$f([
  Column({ name: "task_inst_id", type: "varchar", nullable: true })
], Log.prototype, "taskInstId", 2);
__decorateClass$f([
  Column({ name: "model_def_id", type: "varchar", nullable: true })
], Log.prototype, "modelDefId", 2);
__decorateClass$f([
  Column({ name: "model_instance_id", type: "varchar", nullable: true })
], Log.prototype, "modelInstanceId", 2);
__decorateClass$f([
  Column({ type: "varchar", nullable: true })
], Log.prototype, "timestamp", 2);
__decorateClass$f([
  Column({ type: "varchar", nullable: true })
], Log.prototype, "level", 2);
__decorateClass$f([
  Column({ type: "varchar", nullable: true })
], Log.prototype, "label", 2);
__decorateClass$f([
  Column({ name: "message", type: isMysql() ? "mediumtext" : "text", nullable: true })
], Log.prototype, "message", 2);
__decorateClass$f([
  Column({ name: "data", type: isMysql() ? "longtext" : "text", nullable: true, transformer: jsonTransformer() })
], Log.prototype, "data", 2);
Log = __decorateClass$f([
  Entity({ name: "cc_log" }),
  Index("idx_log_task_inst_id", ["taskInstId", "taskId"], { unique: false })
], Log);
var __defProp$e = Object.defineProperty;
var __getOwnPropDesc$e = Object.getOwnPropertyDescriptor;
var __decorateClass$e = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$e(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$e(target, key, result);
  return result;
};
let Project = class extends BaseEntity {
  name;
  code;
  children;
  parent;
  parentId;
};
__decorateClass$e([
  Column({ type: "varchar" })
], Project.prototype, "name", 2);
__decorateClass$e([
  Column({ type: "varchar", unique: true, nullable: true })
], Project.prototype, "code", 2);
__decorateClass$e([
  TreeChildren()
], Project.prototype, "children", 2);
__decorateClass$e([
  TreeParent()
], Project.prototype, "parent", 2);
__decorateClass$e([
  Column({ type: "uuid", nullable: true })
], Project.prototype, "parentId", 2);
Project = __decorateClass$e([
  Entity({ name: "cc_project" }),
  Tree("materialized-path"),
  Index("idx_project_code", ["code"])
], Project);
var __defProp$d = Object.defineProperty;
var __getOwnPropDesc$d = Object.getOwnPropertyDescriptor;
var __decorateClass$d = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$d(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$d(target, key, result);
  return result;
};
let Favourite = class extends BaseEntity {
  fullPath;
  path;
  exportName;
};
__decorateClass$d([
  Column({ type: "varchar", unique: false })
], Favourite.prototype, "fullPath", 2);
__decorateClass$d([
  Column({ type: "varchar", unique: false })
], Favourite.prototype, "path", 2);
__decorateClass$d([
  Column({ type: "varchar", unique: false })
], Favourite.prototype, "exportName", 2);
Favourite = __decorateClass$d([
  Entity({ name: "cc_favourite" })
], Favourite);
var __defProp$c = Object.defineProperty;
var __getOwnPropDesc$c = Object.getOwnPropertyDescriptor;
var __decorateClass$c = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$c(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$c(target, key, result);
  return result;
};
let ModelTemplateGroup = class extends BaseEntity {
  name;
  code;
  children;
  parent;
  parentId;
};
__decorateClass$c([
  Column({ type: "varchar" })
], ModelTemplateGroup.prototype, "name", 2);
__decorateClass$c([
  Column({ type: "varchar", unique: true, nullable: true })
], ModelTemplateGroup.prototype, "code", 2);
__decorateClass$c([
  TreeChildren()
], ModelTemplateGroup.prototype, "children", 2);
__decorateClass$c([
  TreeParent()
], ModelTemplateGroup.prototype, "parent", 2);
__decorateClass$c([
  Column({ type: "uuid", nullable: true })
], ModelTemplateGroup.prototype, "parentId", 2);
ModelTemplateGroup = __decorateClass$c([
  Entity({ name: "cc_model_template_group" }),
  Tree("materialized-path"),
  Index("idx_model_template_group_code", ["code"])
], ModelTemplateGroup);
var __defProp$b = Object.defineProperty;
var __getOwnPropDesc$b = Object.getOwnPropertyDescriptor;
var __decorateClass$b = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$b(target, key, result);
  return result;
};
let ModelTemplate = class extends BaseEntity {
  name;
  code;
  state;
  modelJson;
  group;
  groupId;
  groupCode;
  async saveJSON() {
    const content = this.modelJson;
    const id = this.id || randomUUID();
    this.id = id;
    const dir = process.env.VITE_APP_MODEL_TEMPLATE_DIR || "./models/templates/";
    const filePath = require$$2.join(dir, `${id}.json`);
    this.modelJson = filePath;
    await saveFile(filePath, content || '{"cells":[]}');
  }
  async BeforeRemove() {
    const dir = process.env.VITE_APP_MODEL_TEMPLATE_DIR || "./models/templates/";
    const filePath = require$$2.resolve(dir, `${this.id}.json`);
    await rm(filePath, { force: true });
  }
};
__decorateClass$b([
  Column({ type: "varchar" })
], ModelTemplate.prototype, "name", 2);
__decorateClass$b([
  Column({ type: "varchar", unique: true })
], ModelTemplate.prototype, "code", 2);
__decorateClass$b([
  Column({ type: "varchar", nullable: true })
], ModelTemplate.prototype, "state", 2);
__decorateClass$b([
  Column({ name: "model_json", type: isMysql() ? "longtext" : "text", nullable: true, transformer: fileTransformer() })
], ModelTemplate.prototype, "modelJson", 2);
__decorateClass$b([
  ManyToOne(() => ModelTemplateGroup),
  JoinColumn({ name: "group_id" })
], ModelTemplate.prototype, "group", 2);
__decorateClass$b([
  Column({ name: "group_id", type: "varchar", nullable: true }),
  RelationId((mt) => mt.group)
], ModelTemplate.prototype, "groupId", 2);
__decorateClass$b([
  Column({ name: "group_code", type: "varchar", nullable: true })
], ModelTemplate.prototype, "groupCode", 2);
__decorateClass$b([
  BeforeInsert(),
  BeforeUpdate()
], ModelTemplate.prototype, "saveJSON", 1);
__decorateClass$b([
  BeforeRemove()
], ModelTemplate.prototype, "BeforeRemove", 1);
ModelTemplate = __decorateClass$b([
  Entity({ name: "cc_model_template" }),
  Index("idx_model_template_code", ["code"])
], ModelTemplate);
var OperatorTypeEnum = /* @__PURE__ */ ((OperatorTypeEnum2) => {
  OperatorTypeEnum2["BASE"] = "BASE";
  OperatorTypeEnum2["CUSTOM"] = "CUSTOM";
  return OperatorTypeEnum2;
})(OperatorTypeEnum || {});
var PlatformEnum = /* @__PURE__ */ ((PlatformEnum2) => {
  PlatformEnum2["CLOUD"] = "CLOUD";
  PlatformEnum2["TERMINAL"] = "TERMINAL";
  return PlatformEnum2;
})(PlatformEnum || {});
var ModelStateEnum = /* @__PURE__ */ ((ModelStateEnum2) => {
  ModelStateEnum2["DISABLED"] = "DISABLED";
  ModelStateEnum2["ENABLED"] = "ENABLED";
  return ModelStateEnum2;
})(ModelStateEnum || {});
var TaskStateEnum = /* @__PURE__ */ ((TaskStateEnum2) => {
  TaskStateEnum2["OFFLINE"] = "OFFLINE";
  TaskStateEnum2["ONLINE"] = "ONLINE";
  return TaskStateEnum2;
})(TaskStateEnum || {});
var TaskInstanceStateEnum = /* @__PURE__ */ ((TaskInstanceStateEnum2) => {
  TaskInstanceStateEnum2["WATTING"] = "WATTING";
  TaskInstanceStateEnum2["RUNNING"] = "RUNNING";
  TaskInstanceStateEnum2["DONE"] = "DONE";
  TaskInstanceStateEnum2["ERROR"] = "ERROR";
  TaskInstanceStateEnum2["INTERRUPTED"] = "INTERRUPTED";
  return TaskInstanceStateEnum2;
})(TaskInstanceStateEnum || {});
var TaskInstanceSourceEnum = /* @__PURE__ */ ((TaskInstanceSourceEnum2) => {
  TaskInstanceSourceEnum2["MANUAL"] = "MANUAL";
  TaskInstanceSourceEnum2["TIMESCHEDULE"] = "TIMESCHEDULE";
  return TaskInstanceSourceEnum2;
})(TaskInstanceSourceEnum || {});
var DataTypeEnum = /* @__PURE__ */ ((DataTypeEnum2) => {
  DataTypeEnum2["string"] = "string";
  DataTypeEnum2["number"] = "number";
  DataTypeEnum2["boolean"] = "boolean";
  DataTypeEnum2["array"] = "array";
  DataTypeEnum2["object"] = "object";
  DataTypeEnum2["any"] = "any";
  DataTypeEnum2["function"] = "function";
  return DataTypeEnum2;
})(DataTypeEnum || {});
var ModelDefinePublishStateEnum = /* @__PURE__ */ ((ModelDefinePublishStateEnum2) => {
  ModelDefinePublishStateEnum2["UNPUBLISHED"] = "UNPUBLISHED";
  ModelDefinePublishStateEnum2["ONLINE"] = "ONLINE";
  ModelDefinePublishStateEnum2["OFFLINE"] = "OFFLINE";
  return ModelDefinePublishStateEnum2;
})(ModelDefinePublishStateEnum || {});
const enums = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DataTypeEnum,
  ModelDefinePublishStateEnum,
  ModelStateEnum,
  OperatorTypeEnum,
  PlatformEnum,
  TaskInstanceSourceEnum,
  TaskInstanceStateEnum,
  TaskStateEnum
}, Symbol.toStringTag, { value: "Module" }));
var __defProp$a = Object.defineProperty;
var __getOwnPropDesc$a = Object.getOwnPropertyDescriptor;
var __decorateClass$a = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$a(target, key, result);
  return result;
};
let ModelDefinePublish = class extends BaseEntity {
  modelDefine;
  modelDefId;
  state;
  modelJson;
  async saveJSON() {
    const content = this.modelJson;
    const id = this.id || randomUUID();
    this.id = id;
    const dir = process.env.VITE_APP_MODEL_PUBLISH_DIR || "./models/publishes";
    const filePath = require$$2.join(dir, `${id}.json`);
    this.modelJson = filePath;
    await saveFile(filePath, content || '{"cells":[]}');
  }
  roleMappings;
  sysAppId;
  sysGroupId;
  sysGroupCode;
  sysGroupName;
};
__decorateClass$a([
  OneToOne(() => ModelDefine, { onDelete: "CASCADE" }),
  JoinColumn({ name: "model_def_id" })
], ModelDefinePublish.prototype, "modelDefine", 2);
__decorateClass$a([
  Column({ name: "model_def_id", type: "varchar" }),
  RelationId((op) => op.modelDefine)
], ModelDefinePublish.prototype, "modelDefId", 2);
__decorateClass$a([
  Column({ type: "varchar", default: ModelDefinePublishStateEnum.UNPUBLISHED })
], ModelDefinePublish.prototype, "state", 2);
__decorateClass$a([
  Column({ name: "model_json", type: isMysql() ? "longtext" : "text", nullable: true, transformer: fileTransformer() })
], ModelDefinePublish.prototype, "modelJson", 2);
__decorateClass$a([
  BeforeInsert(),
  BeforeUpdate()
], ModelDefinePublish.prototype, "saveJSON", 1);
__decorateClass$a([
  Column({
    name: "role_mappings",
    type: "varchar",
    nullable: true,
    transformer: { to: (val) => JSON.stringify(val), from: (val) => JSON.parse(val) }
  })
], ModelDefinePublish.prototype, "roleMappings", 2);
__decorateClass$a([
  Column({ name: "sys_app_id", type: "varchar" })
], ModelDefinePublish.prototype, "sysAppId", 2);
__decorateClass$a([
  Column({ name: "sys_group_id", type: "varchar" })
], ModelDefinePublish.prototype, "sysGroupId", 2);
__decorateClass$a([
  Column({ name: "sys_group_code", type: "varchar" })
], ModelDefinePublish.prototype, "sysGroupCode", 2);
__decorateClass$a([
  Column({ name: "sys_group_name", type: "varchar" })
], ModelDefinePublish.prototype, "sysGroupName", 2);
ModelDefinePublish = __decorateClass$a([
  Entity({ name: "cc_model_define_publish" })
], ModelDefinePublish);
var __defProp$9 = Object.defineProperty;
var __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor;
var __decorateClass$9 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$9(target, key, result);
  return result;
};
let ModelInstance = class extends BaseEntity {
  name;
  modelDefine;
  modelDefId;
  version;
  state;
  modelJson;
  extra;
  async saveJSON() {
    const content = this.modelJson;
    const id = this.id || randomUUID();
    this.id = id;
    const dir = process.env.VITE_APP_MODEL_INSTANCE_DIR || "./models/instances/";
    const filePath = require$$2.join(dir, `${id}.json`);
    this.modelJson = filePath;
    await saveFile(filePath, content || '{"cells":[]}');
  }
};
__decorateClass$9([
  Column({ type: "varchar" })
], ModelInstance.prototype, "name", 2);
__decorateClass$9([
  ManyToOne(() => ModelDefine, { onDelete: "CASCADE" }),
  JoinColumn({ name: "model_def_id" })
], ModelInstance.prototype, "modelDefine", 2);
__decorateClass$9([
  Column({ name: "model_def_id", type: "varchar" }),
  RelationId((op) => op.modelDefine)
], ModelInstance.prototype, "modelDefId", 2);
__decorateClass$9([
  Column({ type: "integer" })
], ModelInstance.prototype, "version", 2);
__decorateClass$9([
  Column({ type: "varchar", default: ModelStateEnum.DISABLED })
], ModelInstance.prototype, "state", 2);
__decorateClass$9([
  Column({ name: "model_json", type: isMysql() ? "longtext" : "text", nullable: true, transformer: fileTransformer() })
], ModelInstance.prototype, "modelJson", 2);
__decorateClass$9([
  Column({ name: "extra", type: isMysql() ? "longtext" : "text", nullable: true, transformer: jsonTransformer() })
], ModelInstance.prototype, "extra", 2);
__decorateClass$9([
  BeforeInsert(),
  BeforeUpdate()
], ModelInstance.prototype, "saveJSON", 1);
ModelInstance = __decorateClass$9([
  Entity({ name: "cc_model_instance" })
], ModelInstance);
var __defProp$8 = Object.defineProperty;
var __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor;
var __decorateClass$8 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$8(target, key, result);
  return result;
};
let Task = class extends BaseEntity {
  name;
  code;
  cron;
  state;
  modelDefines;
};
__decorateClass$8([
  Column({ type: "varchar", nullable: true })
], Task.prototype, "name", 2);
__decorateClass$8([
  Column({ type: "varchar", nullable: true, unique: true })
], Task.prototype, "code", 2);
__decorateClass$8([
  Column({ type: "varchar" })
], Task.prototype, "cron", 2);
__decorateClass$8([
  Column({ name: "state", type: "varchar", default: TaskStateEnum.OFFLINE })
], Task.prototype, "state", 2);
__decorateClass$8([
  OneToMany(() => ModelDefine, (def) => def.task, {})
], Task.prototype, "modelDefines", 2);
Task = __decorateClass$8([
  Entity({ name: "cc_task" }),
  Index("idx_task_code", ["code"])
], Task);
var __defProp$7 = Object.defineProperty;
var __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor;
var __decorateClass$7 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$7(target, key, result);
  return result;
};
let ModelDefine = class extends BaseEntity {
  name;
  code;
  project;
  projectId;
  projectCode;
  modelInstances;
  modelPublish;
  taskId;
  task;
};
__decorateClass$7([
  Column({ type: "varchar" })
], ModelDefine.prototype, "name", 2);
__decorateClass$7([
  Column({ type: "varchar", nullable: true, unique: true })
], ModelDefine.prototype, "code", 2);
__decorateClass$7([
  ManyToOne(() => Project, {}),
  JoinColumn({ name: "project_id" })
], ModelDefine.prototype, "project", 2);
__decorateClass$7([
  Column({ name: "project_id", type: "varchar", nullable: true }),
  RelationId((md) => md.project)
], ModelDefine.prototype, "projectId", 2);
__decorateClass$7([
  Column({ name: "project_code", type: "varchar", nullable: true })
], ModelDefine.prototype, "projectCode", 2);
__decorateClass$7([
  OneToMany(() => ModelInstance, (m) => m.modelDefine)
], ModelDefine.prototype, "modelInstances", 2);
__decorateClass$7([
  OneToOne(() => ModelDefinePublish, (m) => m.modelDefine)
], ModelDefine.prototype, "modelPublish", 2);
__decorateClass$7([
  Column({ name: "task_id", type: "varchar", nullable: true }),
  RelationId((md) => md.task)
], ModelDefine.prototype, "taskId", 2);
__decorateClass$7([
  ManyToOne(() => Task, (m) => m.modelDefines, { onDelete: "SET NULL" }),
  JoinColumn({ name: "task_id" })
], ModelDefine.prototype, "task", 2);
ModelDefine = __decorateClass$7([
  Entity({ name: "cc_model_define" }),
  Index("idx_model_define_code", ["code"])
], ModelDefine);
var __defProp$6 = Object.defineProperty;
var __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor;
var __decorateClass$6 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$6(target, key, result);
  return result;
};
let OperatorRt = class extends BaseEntity {
  operator;
  operatorId;
};
__decorateClass$6([
  ManyToOne(() => Operator, (op) => op.inputs, { onDelete: "CASCADE" }),
  JoinColumn({ name: "operator_id" })
], OperatorRt.prototype, "operator", 2);
__decorateClass$6([
  Column({ name: "operator_id", type: "varchar" }),
  RelationId((oi) => oi.operator)
], OperatorRt.prototype, "operatorId", 2);
OperatorRt = __decorateClass$6([
  Entity({ name: "cc_operator_rt" })
], OperatorRt);
var __defProp$5 = Object.defineProperty;
var __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor;
var __decorateClass$5 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$5(target, key, result);
  return result;
};
let OperatorInput = class extends OperatorRt {
  key;
  name;
  dataType;
  defaultValue;
  metadata;
  index;
};
__decorateClass$5([
  Column({ type: "varchar" })
], OperatorInput.prototype, "key", 2);
__decorateClass$5([
  Column({ type: "varchar", nullable: true })
], OperatorInput.prototype, "name", 2);
__decorateClass$5([
  Column({ name: "data_type", type: "varchar", transformer: dataTypeTransformer() })
], OperatorInput.prototype, "dataType", 2);
__decorateClass$5([
  Column({ name: "default_value", type: "varchar", transformer: jsonTransformer(), nullable: true })
], OperatorInput.prototype, "defaultValue", 2);
__decorateClass$5([
  Column({ type: "text", transformer: jsonTransformer(), nullable: true })
], OperatorInput.prototype, "metadata", 2);
__decorateClass$5([
  Column({ type: "int", nullable: true })
], OperatorInput.prototype, "index", 2);
OperatorInput = __decorateClass$5([
  Entity({ name: "cc_operator_input" })
], OperatorInput);
var __defProp$4 = Object.defineProperty;
var __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor;
var __decorateClass$4 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$4(target, key, result);
  return result;
};
let OperatorOutput = class extends OperatorRt {
  key;
  name;
  dataType;
  metadata;
  // Record<string, unknown>
};
__decorateClass$4([
  Column({ type: "varchar" })
], OperatorOutput.prototype, "key", 2);
__decorateClass$4([
  Column({ type: "varchar", nullable: true })
], OperatorOutput.prototype, "name", 2);
__decorateClass$4([
  Column({ name: "data_type", type: "varchar", nullable: true })
], OperatorOutput.prototype, "dataType", 2);
__decorateClass$4([
  Column({ type: "text", transformer: jsonTransformer(), nullable: true })
], OperatorOutput.prototype, "metadata", 2);
OperatorOutput = __decorateClass$4([
  Entity({ name: "cc_operator_output" })
], OperatorOutput);
var __defProp$3 = Object.defineProperty;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor;
var __decorateClass$3 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$3(target, key, result);
  return result;
};
let OperatorProperty = class extends OperatorRt {
  key;
  name;
  dataType;
  defaultValue;
  metadata;
  // Record<string, unknown>
};
__decorateClass$3([
  Column({ type: "varchar" })
], OperatorProperty.prototype, "key", 2);
__decorateClass$3([
  Column({ type: "varchar", nullable: true })
], OperatorProperty.prototype, "name", 2);
__decorateClass$3([
  Column({ name: "data_type", type: "varchar", transformer: dataTypeTransformer(), nullable: true })
], OperatorProperty.prototype, "dataType", 2);
__decorateClass$3([
  Column({ name: "default_value", type: "varchar", transformer: jsonTransformer(), nullable: true })
], OperatorProperty.prototype, "defaultValue", 2);
__decorateClass$3([
  Column({ type: "text", transformer: jsonTransformer(), nullable: true })
], OperatorProperty.prototype, "metadata", 2);
OperatorProperty = __decorateClass$3([
  Entity({ name: "cc_operator_property" })
], OperatorProperty);
var __defProp$2 = Object.defineProperty;
var __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor;
var __decorateClass$2 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$2(target, key, result);
  return result;
};
let Operator = class extends BaseEntity {
  key;
  name;
  allowAddInput;
  allowAddOutput;
  metadata;
  operatorFile;
  operatorFileId;
  inputs;
  outputs;
  properties;
};
__decorateClass$2([
  Column({ type: "varchar" })
], Operator.prototype, "key", 2);
__decorateClass$2([
  Column({ type: "varchar" })
], Operator.prototype, "name", 2);
__decorateClass$2([
  Column({ name: "allow_add_input", type: "boolean", default: false })
], Operator.prototype, "allowAddInput", 2);
__decorateClass$2([
  Column({ name: "allow_add_output", type: "boolean", default: false })
], Operator.prototype, "allowAddOutput", 2);
__decorateClass$2([
  Column({ type: "varchar", transformer: jsonTransformer(), nullable: true })
], Operator.prototype, "metadata", 2);
__decorateClass$2([
  ManyToOne(() => OperatorFile, (of) => of.operators, { onDelete: "CASCADE" }),
  JoinColumn({ name: "operator_file_id" })
], Operator.prototype, "operatorFile", 2);
__decorateClass$2([
  Column({ name: "operator_file_id", type: "varchar" }),
  RelationId((op) => op.operatorFile)
], Operator.prototype, "operatorFileId", 2);
__decorateClass$2([
  OneToMany(() => OperatorInput, (input) => input.operator, { cascade: true, onDelete: "CASCADE" })
], Operator.prototype, "inputs", 2);
__decorateClass$2([
  OneToMany(() => OperatorOutput, (output) => output.operator, { cascade: true, onDelete: "CASCADE" })
], Operator.prototype, "outputs", 2);
__decorateClass$2([
  OneToMany(() => OperatorProperty, (output) => output.operator, { cascade: true, onDelete: "CASCADE" })
], Operator.prototype, "properties", 2);
Operator = __decorateClass$2([
  Entity({ name: "cc_operator" })
], Operator);
var __defProp$1 = Object.defineProperty;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor;
var __decorateClass$1 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp$1(target, key, result);
  return result;
};
let OperatorFile = class extends BaseEntity {
  fullPath;
  path;
  name;
  originName;
  type;
  source;
  size;
  md5;
  operators;
};
__decorateClass$1([
  Column({ type: "varchar", unique: true })
], OperatorFile.prototype, "fullPath", 2);
__decorateClass$1([
  Column({ type: "varchar", unique: false })
], OperatorFile.prototype, "path", 2);
__decorateClass$1([
  Column({ type: "varchar", nullable: true })
], OperatorFile.prototype, "name", 2);
__decorateClass$1([
  Column({ type: "varchar" })
], OperatorFile.prototype, "originName", 2);
__decorateClass$1([
  Column({ type: "varchar", nullable: true })
], OperatorFile.prototype, "type", 2);
__decorateClass$1([
  Column({ type: "varchar", nullable: true })
], OperatorFile.prototype, "source", 2);
__decorateClass$1([
  Column({ type: "int", nullable: true })
], OperatorFile.prototype, "size", 2);
__decorateClass$1([
  Column({ type: "varchar", nullable: true })
], OperatorFile.prototype, "md5", 2);
__decorateClass$1([
  OneToMany(() => Operator, (op) => op.operatorFile, { cascade: true, onDelete: "CASCADE" })
], OperatorFile.prototype, "operators", 2);
OperatorFile = __decorateClass$1([
  Entity({ name: "cc_operator_file" })
], OperatorFile);
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
let BaseTaskInstance = class extends BaseEntity {
};
BaseTaskInstance = __decorateClass([
  Entity({ name: "cc_base_task_instance" })
], BaseTaskInstance);
let TaskInstance = class extends BaseEntity {
  source;
  modelDefine;
  modelDefId;
  modelInstance;
  modelInstanceId;
  task;
  taskId;
  triggerTime;
  startTime;
  endTime;
  duration;
  state;
  extra;
};
__decorateClass([
  Column({ type: "varchar" })
], TaskInstance.prototype, "source", 2);
__decorateClass([
  ManyToOne(() => ModelDefine, { onDelete: "NO ACTION" }),
  JoinColumn({ name: "model_def_id" })
], TaskInstance.prototype, "modelDefine", 2);
__decorateClass([
  Column({ name: "model_def_id", type: "varchar" })
], TaskInstance.prototype, "modelDefId", 2);
__decorateClass([
  ManyToOne(() => ModelInstance, { onDelete: "NO ACTION" }),
  JoinColumn({ name: "model_instance_id" })
], TaskInstance.prototype, "modelInstance", 2);
__decorateClass([
  Column({ name: "model_instance_id", type: "varchar" })
], TaskInstance.prototype, "modelInstanceId", 2);
__decorateClass([
  ManyToOne(() => Task, { onDelete: "NO ACTION" }),
  JoinColumn({ name: "task_id" })
], TaskInstance.prototype, "task", 2);
__decorateClass([
  Column({ name: "task_id", type: "varchar", nullable: true })
], TaskInstance.prototype, "taskId", 2);
__decorateClass([
  Column({ name: "trigger_time", type: "varchar", nullable: true, transformer: dateTransformer() })
], TaskInstance.prototype, "triggerTime", 2);
__decorateClass([
  Column({ name: "start_time", type: "varchar", nullable: true, transformer: dateTransformer(true, true) })
], TaskInstance.prototype, "startTime", 2);
__decorateClass([
  Column({ name: "end_time", type: "varchar", nullable: true, transformer: dateTransformer(true, true) })
], TaskInstance.prototype, "endTime", 2);
__decorateClass([
  Column({ type: "varchar", nullable: true, transformer: durationTransformer() })
], TaskInstance.prototype, "duration", 2);
__decorateClass([
  Column({ name: "state", type: "varchar", default: TaskInstanceStateEnum.WATTING })
], TaskInstance.prototype, "state", 2);
__decorateClass([
  Column({ name: "extra", type: isMysql() ? "longtext" : "text", nullable: true, transformer: jsonTransformer() })
], TaskInstance.prototype, "extra", 2);
TaskInstance = __decorateClass([
  Entity({ name: "cc_task_instance" }),
  Index("idx_task_inst_state", ["state"])
], TaskInstance);
const entities = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  get Favourite() {
    return Favourite;
  },
  get Log() {
    return Log;
  },
  get ModelDefine() {
    return ModelDefine;
  },
  get ModelDefinePublish() {
    return ModelDefinePublish;
  },
  get ModelInstance() {
    return ModelInstance;
  },
  get ModelTemplate() {
    return ModelTemplate;
  },
  get ModelTemplateGroup() {
    return ModelTemplateGroup;
  },
  get Operator() {
    return Operator;
  },
  get OperatorFile() {
    return OperatorFile;
  },
  get OperatorInput() {
    return OperatorInput;
  },
  get OperatorOutput() {
    return OperatorOutput;
  },
  get OperatorProperty() {
    return OperatorProperty;
  },
  get Project() {
    return Project;
  },
  get Task() {
    return Task;
  },
  get TaskInstance() {
    return TaskInstance;
  }
}, Symbol.toStringTag, { value: "Module" }));
let redis = null;
const useRedis = (path, options) => {
  if (redis) return redis;
  redis = new builtExports.Redis(process.env.VITE_APP_REDIS_URL || path, {
    username: process.env.VITE_APP_REDIS_USERNAME,
    password: process.env.VITE_APP_REDIS_PASSWORD,
    lazyConnect: true,
    db: Number(process.env.VITE_APP_REDIS_DB),
    ...options
  });
  return redis;
};
const driverMap = { doris: mysql, mysql: mysql2 };
const init = {
  ...entities,
  ...enums,
  BaseEntity,
  dataSource: null,
  initDataSource: (options = {}) => {
    if (init.dataSource?.isInitialized) return init.dataSource;
    const type = process.env.VITE_APP_DATASOURCE_TYPE;
    const database = process.env.VITE_APP_DATASOURCE_DATABASE;
    const isSqlite = type === "better-sqlite3" || type === "sqlite";
    const opt = merge(
      {
        type: process.env.VITE_APP_DATASOURCE_TYPE,
        driver: driverMap[type],
        database: isSqlite ? `${database}.db` : database,
        host: process.env.VITE_APP_DATASOURCE_HOST,
        port: +process.env.VITE_APP_DATASOURCE_PORT,
        username: process.env.VITE_APP_DATASOURCE_USERNAME,
        password: process.env.VITE_APP_DATASOURCE_PASSWORD,
        timezone: "+08:00"
      },
      options
    );
    init.dataSource = new DataSource({
      synchronize: false,
      logging: false,
      ...opt,
      entities: Object.values(entities)
    });
    return init.dataSource;
  }
};
const useDataSource = () => init;
const _default = { useDataSource, useRedis, BaseEntity, ...entities, ...enums };
export {
  BaseEntity,
  DataTypeEnum,
  Favourite,
  Log,
  ModelDefine,
  ModelDefinePublish,
  ModelDefinePublishStateEnum,
  ModelInstance,
  ModelStateEnum,
  ModelTemplate,
  ModelTemplateGroup,
  Operator,
  OperatorFile,
  OperatorInput,
  OperatorOutput,
  OperatorProperty,
  OperatorTypeEnum,
  PlatformEnum,
  Project,
  Task,
  TaskInstance,
  TaskInstanceSourceEnum,
  TaskInstanceStateEnum,
  TaskStateEnum,
  _default as default,
  driverMap,
  useDataSource,
  useRedis
};
