import __path from "node:path";
import { fileURLToPath as __fileURLToPath } from "node:url";
import { createRequire as __createRequire } from "node:module";
const __getFilename = () => __fileURLToPath(import.meta.url);
const __getDirname = () => __path.dirname(__getFilename());
const __dirname = __getDirname();
const __filename = __getFilename();
const self = globalThis;
const require2 = __createRequire(import.meta.url);
import require$$0$6 from "node:events";
import require$$0$5 from "node:net";
import require$$1$3 from "node:tls";
import require$$0$1 from "node:url";
import require$$0$7 from "node:buffer";
import require$$1 from "node:util";
import require$$0$2 from "node:stream";
import require$$1$4 from "node:string_decoder";
import require$$2 from "node:os";
import require$$0$4 from "node:dns";
import require$$1$1 from "node:assert";
import require$$1$2 from "node:tty";
import require$$0$3 from "node:crypto";
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function getAugmentedNamespace(n) {
  if (Object.prototype.hasOwnProperty.call(n, "__esModule")) return n;
  var f = n.default;
  if (typeof f == "function") {
    var a = function a2() {
      var isInstance = false;
      try {
        isInstance = this instanceof a2;
      } catch {
      }
      if (isInstance) {
        return Reflect.construct(f, arguments, this.constructor);
      }
      return f.apply(this, arguments);
    };
    a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, "__esModule", { value: true });
  Object.keys(n).forEach(function(k) {
    var d = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(a, k, d.get ? d : {
      enumerable: true,
      get: function() {
        return n[k];
      }
    });
  });
  return a;
}
var denque;
var hasRequiredDenque;
function requireDenque() {
  if (hasRequiredDenque) return denque;
  hasRequiredDenque = 1;
  function Denque(array, options) {
    var options = options || {};
    this._capacity = options.capacity;
    this._head = 0;
    this._tail = 0;
    if (Array.isArray(array)) {
      this._fromArray(array);
    } else {
      this._capacityMask = 3;
      this._list = new Array(4);
    }
  }
  Denque.prototype.peekAt = function peekAt(index) {
    var i = index;
    if (i !== (i | 0)) {
      return void 0;
    }
    var len = this.size();
    if (i >= len || i < -len) return void 0;
    if (i < 0) i += len;
    i = this._head + i & this._capacityMask;
    return this._list[i];
  };
  Denque.prototype.get = function get2(i) {
    return this.peekAt(i);
  };
  Denque.prototype.peek = function peek() {
    if (this._head === this._tail) return void 0;
    return this._list[this._head];
  };
  Denque.prototype.peekFront = function peekFront() {
    return this.peek();
  };
  Denque.prototype.peekBack = function peekBack() {
    return this.peekAt(-1);
  };
  Object.defineProperty(Denque.prototype, "length", {
    get: function length() {
      return this.size();
    }
  });
  Denque.prototype.size = function size() {
    if (this._head === this._tail) return 0;
    if (this._head < this._tail) return this._tail - this._head;
    else return this._capacityMask + 1 - (this._head - this._tail);
  };
  Denque.prototype.unshift = function unshift(item) {
    if (arguments.length === 0) return this.size();
    var len = this._list.length;
    this._head = this._head - 1 + len & this._capacityMask;
    this._list[this._head] = item;
    if (this._tail === this._head) this._growArray();
    if (this._capacity && this.size() > this._capacity) this.pop();
    if (this._head < this._tail) return this._tail - this._head;
    else return this._capacityMask + 1 - (this._head - this._tail);
  };
  Denque.prototype.shift = function shift() {
    var head = this._head;
    if (head === this._tail) return void 0;
    var item = this._list[head];
    this._list[head] = void 0;
    this._head = head + 1 & this._capacityMask;
    if (head < 2 && this._tail > 1e4 && this._tail <= this._list.length >>> 2) this._shrinkArray();
    return item;
  };
  Denque.prototype.push = function push(item) {
    if (arguments.length === 0) return this.size();
    var tail = this._tail;
    this._list[tail] = item;
    this._tail = tail + 1 & this._capacityMask;
    if (this._tail === this._head) {
      this._growArray();
    }
    if (this._capacity && this.size() > this._capacity) {
      this.shift();
    }
    if (this._head < this._tail) return this._tail - this._head;
    else return this._capacityMask + 1 - (this._head - this._tail);
  };
  Denque.prototype.pop = function pop() {
    var tail = this._tail;
    if (tail === this._head) return void 0;
    var len = this._list.length;
    this._tail = tail - 1 + len & this._capacityMask;
    var item = this._list[this._tail];
    this._list[this._tail] = void 0;
    if (this._head < 2 && tail > 1e4 && tail <= len >>> 2) this._shrinkArray();
    return item;
  };
  Denque.prototype.removeOne = function removeOne(index) {
    var i = index;
    if (i !== (i | 0)) {
      return void 0;
    }
    if (this._head === this._tail) return void 0;
    var size = this.size();
    var len = this._list.length;
    if (i >= size || i < -size) return void 0;
    if (i < 0) i += size;
    i = this._head + i & this._capacityMask;
    var item = this._list[i];
    var k;
    if (index < size / 2) {
      for (k = index; k > 0; k--) {
        this._list[i] = this._list[i = i - 1 + len & this._capacityMask];
      }
      this._list[i] = void 0;
      this._head = this._head + 1 + len & this._capacityMask;
    } else {
      for (k = size - 1 - index; k > 0; k--) {
        this._list[i] = this._list[i = i + 1 + len & this._capacityMask];
      }
      this._list[i] = void 0;
      this._tail = this._tail - 1 + len & this._capacityMask;
    }
    return item;
  };
  Denque.prototype.remove = function remove(index, count) {
    var i = index;
    var removed;
    var del_count = count;
    if (i !== (i | 0)) {
      return void 0;
    }
    if (this._head === this._tail) return void 0;
    var size = this.size();
    var len = this._list.length;
    if (i >= size || i < -size || count < 1) return void 0;
    if (i < 0) i += size;
    if (count === 1 || !count) {
      removed = new Array(1);
      removed[0] = this.removeOne(i);
      return removed;
    }
    if (i === 0 && i + count >= size) {
      removed = this.toArray();
      this.clear();
      return removed;
    }
    if (i + count > size) count = size - i;
    var k;
    removed = new Array(count);
    for (k = 0; k < count; k++) {
      removed[k] = this._list[this._head + i + k & this._capacityMask];
    }
    i = this._head + i & this._capacityMask;
    if (index + count === size) {
      this._tail = this._tail - count + len & this._capacityMask;
      for (k = count; k > 0; k--) {
        this._list[i = i + 1 + len & this._capacityMask] = void 0;
      }
      return removed;
    }
    if (index === 0) {
      this._head = this._head + count + len & this._capacityMask;
      for (k = count - 1; k > 0; k--) {
        this._list[i = i + 1 + len & this._capacityMask] = void 0;
      }
      return removed;
    }
    if (i < size / 2) {
      this._head = this._head + index + count + len & this._capacityMask;
      for (k = index; k > 0; k--) {
        this.unshift(this._list[i = i - 1 + len & this._capacityMask]);
      }
      i = this._head - 1 + len & this._capacityMask;
      while (del_count > 0) {
        this._list[i = i - 1 + len & this._capacityMask] = void 0;
        del_count--;
      }
      if (index < 0) this._tail = i;
    } else {
      this._tail = i;
      i = i + count + len & this._capacityMask;
      for (k = size - (count + index); k > 0; k--) {
        this.push(this._list[i++]);
      }
      i = this._tail;
      while (del_count > 0) {
        this._list[i = i + 1 + len & this._capacityMask] = void 0;
        del_count--;
      }
    }
    if (this._head < 2 && this._tail > 1e4 && this._tail <= len >>> 2) this._shrinkArray();
    return removed;
  };
  Denque.prototype.splice = function splice(index, count) {
    var i = index;
    if (i !== (i | 0)) {
      return void 0;
    }
    var size = this.size();
    if (i < 0) i += size;
    if (i > size) return void 0;
    if (arguments.length > 2) {
      var k;
      var temp;
      var removed;
      var arg_len = arguments.length;
      var len = this._list.length;
      var arguments_index = 2;
      if (!size || i < size / 2) {
        temp = new Array(i);
        for (k = 0; k < i; k++) {
          temp[k] = this._list[this._head + k & this._capacityMask];
        }
        if (count === 0) {
          removed = [];
          if (i > 0) {
            this._head = this._head + i + len & this._capacityMask;
          }
        } else {
          removed = this.remove(i, count);
          this._head = this._head + i + len & this._capacityMask;
        }
        while (arg_len > arguments_index) {
          this.unshift(arguments[--arg_len]);
        }
        for (k = i; k > 0; k--) {
          this.unshift(temp[k - 1]);
        }
      } else {
        temp = new Array(size - (i + count));
        var leng = temp.length;
        for (k = 0; k < leng; k++) {
          temp[k] = this._list[this._head + i + count + k & this._capacityMask];
        }
        if (count === 0) {
          removed = [];
          if (i != size) {
            this._tail = this._head + i + len & this._capacityMask;
          }
        } else {
          removed = this.remove(i, count);
          this._tail = this._tail - leng + len & this._capacityMask;
        }
        while (arguments_index < arg_len) {
          this.push(arguments[arguments_index++]);
        }
        for (k = 0; k < leng; k++) {
          this.push(temp[k]);
        }
      }
      return removed;
    } else {
      return this.remove(i, count);
    }
  };
  Denque.prototype.clear = function clear() {
    this._list = new Array(this._list.length);
    this._head = 0;
    this._tail = 0;
  };
  Denque.prototype.isEmpty = function isEmpty() {
    return this._head === this._tail;
  };
  Denque.prototype.toArray = function toArray() {
    return this._copyArray(false);
  };
  Denque.prototype._fromArray = function _fromArray(array) {
    var length = array.length;
    var capacity = this._nextPowerOf2(length);
    this._list = new Array(capacity);
    this._capacityMask = capacity - 1;
    this._tail = length;
    for (var i = 0; i < length; i++) this._list[i] = array[i];
  };
  Denque.prototype._copyArray = function _copyArray(fullCopy, size) {
    var src2 = this._list;
    var capacity = src2.length;
    var length = this.length;
    size = size | length;
    if (size == length && this._head < this._tail) {
      return this._list.slice(this._head, this._tail);
    }
    var dest = new Array(size);
    var k = 0;
    var i;
    if (fullCopy || this._head > this._tail) {
      for (i = this._head; i < capacity; i++) dest[k++] = src2[i];
      for (i = 0; i < this._tail; i++) dest[k++] = src2[i];
    } else {
      for (i = this._head; i < this._tail; i++) dest[k++] = src2[i];
    }
    return dest;
  };
  Denque.prototype._growArray = function _growArray() {
    if (this._head != 0) {
      var newList = this._copyArray(true, this._list.length << 1);
      this._tail = this._list.length;
      this._head = 0;
      this._list = newList;
    } else {
      this._tail = this._list.length;
      this._list.length <<= 1;
    }
    this._capacityMask = this._capacityMask << 1 | 1;
  };
  Denque.prototype._shrinkArray = function _shrinkArray() {
    this._list.length >>>= 1;
    this._capacityMask >>>= 1;
  };
  Denque.prototype._nextPowerOf2 = function _nextPowerOf2(num) {
    var log2 = Math.log(num) / Math.log(2);
    var nextPow2 = 1 << log2 + 1;
    return Math.max(nextPow2, 4);
  };
  denque = Denque;
  return denque;
}
var built$2 = { exports: {} };
var Redis = {};
var built$1 = {};
const acl = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const append = { "arity": 3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const asking = { "arity": 1, "flags": ["fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const auth = { "arity": -2, "flags": ["noscript", "loading", "stale", "fast", "no_auth", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const bgrewriteaof = { "arity": 1, "flags": ["admin", "noscript", "no_async_loading"], "keyStart": 0, "keyStop": 0, "step": 0 };
const bgsave = { "arity": -1, "flags": ["admin", "noscript", "no_async_loading"], "keyStart": 0, "keyStop": 0, "step": 0 };
const bitcount = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const bitfield = { "arity": -2, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const bitfield_ro = { "arity": -2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const bitop = { "arity": -4, "flags": ["write", "denyoom"], "keyStart": 2, "keyStop": -1, "step": 1 };
const bitpos = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const blmove = { "arity": 6, "flags": ["write", "denyoom", "noscript", "blocking"], "keyStart": 1, "keyStop": 2, "step": 1 };
const blmpop = { "arity": -5, "flags": ["write", "blocking", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const blpop = { "arity": -3, "flags": ["write", "noscript", "blocking"], "keyStart": 1, "keyStop": -2, "step": 1 };
const brpop = { "arity": -3, "flags": ["write", "noscript", "blocking"], "keyStart": 1, "keyStop": -2, "step": 1 };
const brpoplpush = { "arity": 4, "flags": ["write", "denyoom", "noscript", "blocking"], "keyStart": 1, "keyStop": 2, "step": 1 };
const bzmpop = { "arity": -5, "flags": ["write", "blocking", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const bzpopmax = { "arity": -3, "flags": ["write", "noscript", "blocking", "fast"], "keyStart": 1, "keyStop": -2, "step": 1 };
const bzpopmin = { "arity": -3, "flags": ["write", "noscript", "blocking", "fast"], "keyStart": 1, "keyStop": -2, "step": 1 };
const client = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const cluster$1 = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const command = { "arity": -1, "flags": ["loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const config = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const copy = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 2, "step": 1 };
const dbsize = { "arity": 1, "flags": ["readonly", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const debug$1 = { "arity": -2, "flags": ["admin", "noscript", "loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const decr = { "arity": 2, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const decrby = { "arity": 3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const del = { "arity": -2, "flags": ["write"], "keyStart": 1, "keyStop": -1, "step": 1 };
const discard = { "arity": 1, "flags": ["noscript", "loading", "stale", "fast", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const dump = { "arity": 2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const echo = { "arity": 2, "flags": ["fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const eval_ro = { "arity": -3, "flags": ["readonly", "noscript", "stale", "skip_monitor", "no_mandatory_keys", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const evalsha = { "arity": -3, "flags": ["noscript", "stale", "skip_monitor", "no_mandatory_keys", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const evalsha_ro = { "arity": -3, "flags": ["readonly", "noscript", "stale", "skip_monitor", "no_mandatory_keys", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const exec = { "arity": 1, "flags": ["noscript", "loading", "stale", "skip_slowlog"], "keyStart": 0, "keyStop": 0, "step": 0 };
const exists = { "arity": -2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": -1, "step": 1 };
const expire = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const expireat = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const expiretime = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const failover = { "arity": -1, "flags": ["admin", "noscript", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const fcall = { "arity": -3, "flags": ["noscript", "stale", "skip_monitor", "no_mandatory_keys", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const fcall_ro = { "arity": -3, "flags": ["readonly", "noscript", "stale", "skip_monitor", "no_mandatory_keys", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const flushall = { "arity": -1, "flags": ["write"], "keyStart": 0, "keyStop": 0, "step": 0 };
const flushdb = { "arity": -1, "flags": ["write"], "keyStart": 0, "keyStop": 0, "step": 0 };
const geoadd = { "arity": -5, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const geodist = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const geohash = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const geopos = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const georadius = { "arity": -6, "flags": ["write", "denyoom", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const georadius_ro = { "arity": -6, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const georadiusbymember = { "arity": -5, "flags": ["write", "denyoom", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const georadiusbymember_ro = { "arity": -5, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const geosearch = { "arity": -7, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const geosearchstore = { "arity": -8, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 2, "step": 1 };
const get = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const getbit = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const getdel = { "arity": 2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const getex = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const getrange = { "arity": 4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const getset = { "arity": 3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hdel = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hello = { "arity": -1, "flags": ["noscript", "loading", "stale", "fast", "no_auth", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const hexists = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hexpire = { "arity": -6, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hpexpire = { "arity": -6, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hget = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hgetall = { "arity": 2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hincrby = { "arity": 4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hincrbyfloat = { "arity": 4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hkeys = { "arity": 2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hlen = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hmget = { "arity": -3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hmset = { "arity": -4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hrandfield = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hscan = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hset = { "arity": -4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hsetnx = { "arity": 4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hstrlen = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const hvals = { "arity": 2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const incr = { "arity": 2, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const incrby = { "arity": 3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const incrbyfloat = { "arity": 3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const info = { "arity": -1, "flags": ["loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const keys = { "arity": 2, "flags": ["readonly"], "keyStart": 0, "keyStop": 0, "step": 0 };
const lastsave = { "arity": 1, "flags": ["loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const latency = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const lcs = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 2, "step": 1 };
const lindex = { "arity": 3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const linsert = { "arity": 5, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const llen = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lmove = { "arity": 5, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 2, "step": 1 };
const lmpop = { "arity": -4, "flags": ["write", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const lolwut = { "arity": -1, "flags": ["readonly", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const lpop = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lpos = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lpush = { "arity": -3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lpushx = { "arity": -3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lrange = { "arity": 4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lrem = { "arity": 4, "flags": ["write"], "keyStart": 1, "keyStop": 1, "step": 1 };
const lset = { "arity": 4, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const ltrim = { "arity": 4, "flags": ["write"], "keyStart": 1, "keyStop": 1, "step": 1 };
const memory = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const mget = { "arity": -2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": -1, "step": 1 };
const migrate = { "arity": -6, "flags": ["write", "movablekeys"], "keyStart": 3, "keyStop": 3, "step": 1 };
const module = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const monitor = { "arity": 1, "flags": ["admin", "noscript", "loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const move = { "arity": 3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const mset = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": -1, "step": 2 };
const msetnx = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": -1, "step": 2 };
const multi = { "arity": 1, "flags": ["noscript", "loading", "stale", "fast", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const object = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const persist = { "arity": 2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const pexpire = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const pexpireat = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const pexpiretime = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const pfadd = { "arity": -2, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const pfcount = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": -1, "step": 1 };
const pfdebug = { "arity": 3, "flags": ["write", "denyoom", "admin"], "keyStart": 2, "keyStop": 2, "step": 1 };
const pfmerge = { "arity": -2, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": -1, "step": 1 };
const pfselftest = { "arity": 1, "flags": ["admin"], "keyStart": 0, "keyStop": 0, "step": 0 };
const ping = { "arity": -1, "flags": ["fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const psetex = { "arity": 4, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const psubscribe = { "arity": -2, "flags": ["pubsub", "noscript", "loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const psync = { "arity": -3, "flags": ["admin", "noscript", "no_async_loading", "no_multi"], "keyStart": 0, "keyStop": 0, "step": 0 };
const pttl = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const publish = { "arity": 3, "flags": ["pubsub", "loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const pubsub = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const punsubscribe = { "arity": -1, "flags": ["pubsub", "noscript", "loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const quit = { "arity": -1, "flags": ["noscript", "loading", "stale", "fast", "no_auth", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const randomkey = { "arity": 1, "flags": ["readonly"], "keyStart": 0, "keyStop": 0, "step": 0 };
const readonly = { "arity": 1, "flags": ["loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const readwrite = { "arity": 1, "flags": ["loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const rename = { "arity": 3, "flags": ["write"], "keyStart": 1, "keyStop": 2, "step": 1 };
const renamenx = { "arity": 3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 2, "step": 1 };
const replconf = { "arity": -1, "flags": ["admin", "noscript", "loading", "stale", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const replicaof = { "arity": 3, "flags": ["admin", "noscript", "stale", "no_async_loading"], "keyStart": 0, "keyStop": 0, "step": 0 };
const reset = { "arity": 1, "flags": ["noscript", "loading", "stale", "fast", "no_auth", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const restore = { "arity": -4, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const role = { "arity": 1, "flags": ["noscript", "loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const rpop = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const rpoplpush = { "arity": 3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 2, "step": 1 };
const rpush = { "arity": -3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const rpushx = { "arity": -3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const sadd = { "arity": -3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const save = { "arity": 1, "flags": ["admin", "noscript", "no_async_loading", "no_multi"], "keyStart": 0, "keyStop": 0, "step": 0 };
const scan = { "arity": -2, "flags": ["readonly"], "keyStart": 0, "keyStop": 0, "step": 0 };
const scard = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const script = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const sdiff = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": -1, "step": 1 };
const sdiffstore = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": -1, "step": 1 };
const select = { "arity": 2, "flags": ["loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const set = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const setbit = { "arity": 4, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const setex = { "arity": 4, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const setnx = { "arity": 3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const setrange = { "arity": 4, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 1, "step": 1 };
const shutdown = { "arity": -1, "flags": ["admin", "noscript", "loading", "stale", "no_multi", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const sinter = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": -1, "step": 1 };
const sintercard = { "arity": -3, "flags": ["readonly", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const sinterstore = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": -1, "step": 1 };
const sismember = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const slaveof = { "arity": 3, "flags": ["admin", "noscript", "stale", "no_async_loading"], "keyStart": 0, "keyStop": 0, "step": 0 };
const slowlog = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const smembers = { "arity": 2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const smismember = { "arity": -3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const smove = { "arity": 4, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 2, "step": 1 };
const sort = { "arity": -2, "flags": ["write", "denyoom", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const sort_ro = { "arity": -2, "flags": ["readonly", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const spop = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const spublish = { "arity": 3, "flags": ["pubsub", "loading", "stale", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const srandmember = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const srem = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const sscan = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const ssubscribe = { "arity": -2, "flags": ["pubsub", "noscript", "loading", "stale"], "keyStart": 1, "keyStop": -1, "step": 1 };
const strlen = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const subscribe = { "arity": -2, "flags": ["pubsub", "noscript", "loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const substr = { "arity": 4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const sunion = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": -1, "step": 1 };
const sunionstore = { "arity": -3, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": -1, "step": 1 };
const sunsubscribe = { "arity": -1, "flags": ["pubsub", "noscript", "loading", "stale"], "keyStart": 1, "keyStop": -1, "step": 1 };
const swapdb = { "arity": 3, "flags": ["write", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const sync = { "arity": 1, "flags": ["admin", "noscript", "no_async_loading", "no_multi"], "keyStart": 0, "keyStop": 0, "step": 0 };
const time = { "arity": 1, "flags": ["loading", "stale", "fast"], "keyStart": 0, "keyStop": 0, "step": 0 };
const touch = { "arity": -2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": -1, "step": 1 };
const ttl = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const type = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const unlink = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": -1, "step": 1 };
const unsubscribe = { "arity": -1, "flags": ["pubsub", "noscript", "loading", "stale"], "keyStart": 0, "keyStop": 0, "step": 0 };
const unwatch = { "arity": 1, "flags": ["noscript", "loading", "stale", "fast", "allow_busy"], "keyStart": 0, "keyStop": 0, "step": 0 };
const wait = { "arity": 3, "flags": ["noscript"], "keyStart": 0, "keyStop": 0, "step": 0 };
const watch = { "arity": -2, "flags": ["noscript", "loading", "stale", "fast", "allow_busy"], "keyStart": 1, "keyStop": -1, "step": 1 };
const xack = { "arity": -4, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xadd = { "arity": -5, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xautoclaim = { "arity": -6, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xclaim = { "arity": -6, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xdel = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xgroup = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const xinfo = { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 };
const xlen = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xpending = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xrange = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xread = { "arity": -4, "flags": ["readonly", "blocking", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const xreadgroup = { "arity": -7, "flags": ["write", "blocking", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const xrevrange = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xsetid = { "arity": -3, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const xtrim = { "arity": -4, "flags": ["write"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zadd = { "arity": -4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zcard = { "arity": 2, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zcount = { "arity": 4, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zdiff = { "arity": -3, "flags": ["readonly", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const zdiffstore = { "arity": -4, "flags": ["write", "denyoom", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zincrby = { "arity": 4, "flags": ["write", "denyoom", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zinter = { "arity": -3, "flags": ["readonly", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const zintercard = { "arity": -3, "flags": ["readonly", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const zinterstore = { "arity": -4, "flags": ["write", "denyoom", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zlexcount = { "arity": 4, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zmpop = { "arity": -4, "flags": ["write", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const zmscore = { "arity": -3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zpopmax = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zpopmin = { "arity": -2, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrandmember = { "arity": -2, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrange = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrangebylex = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrangebyscore = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrangestore = { "arity": -5, "flags": ["write", "denyoom"], "keyStart": 1, "keyStop": 2, "step": 1 };
const zrank = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrem = { "arity": -3, "flags": ["write", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zremrangebylex = { "arity": 4, "flags": ["write"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zremrangebyrank = { "arity": 4, "flags": ["write"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zremrangebyscore = { "arity": 4, "flags": ["write"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrevrange = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrevrangebylex = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrevrangebyscore = { "arity": -4, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zrevrank = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zscan = { "arity": -3, "flags": ["readonly"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zscore = { "arity": 3, "flags": ["readonly", "fast"], "keyStart": 1, "keyStop": 1, "step": 1 };
const zunion = { "arity": -3, "flags": ["readonly", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 };
const zunionstore = { "arity": -4, "flags": ["write", "denyoom", "movablekeys"], "keyStart": 1, "keyStop": 1, "step": 1 };
const require$$0 = {
  acl,
  append,
  asking,
  auth,
  bgrewriteaof,
  bgsave,
  bitcount,
  bitfield,
  bitfield_ro,
  bitop,
  bitpos,
  blmove,
  blmpop,
  blpop,
  brpop,
  brpoplpush,
  bzmpop,
  bzpopmax,
  bzpopmin,
  client,
  cluster: cluster$1,
  command,
  config,
  copy,
  dbsize,
  debug: debug$1,
  decr,
  decrby,
  del,
  discard,
  dump,
  echo,
  "eval": { "arity": -3, "flags": ["noscript", "stale", "skip_monitor", "no_mandatory_keys", "movablekeys"], "keyStart": 0, "keyStop": 0, "step": 0 },
  eval_ro,
  evalsha,
  evalsha_ro,
  exec,
  exists,
  expire,
  expireat,
  expiretime,
  failover,
  fcall,
  fcall_ro,
  flushall,
  flushdb,
  "function": { "arity": -2, "flags": [], "keyStart": 0, "keyStop": 0, "step": 0 },
  geoadd,
  geodist,
  geohash,
  geopos,
  georadius,
  georadius_ro,
  georadiusbymember,
  georadiusbymember_ro,
  geosearch,
  geosearchstore,
  get,
  getbit,
  getdel,
  getex,
  getrange,
  getset,
  hdel,
  hello,
  hexists,
  hexpire,
  hpexpire,
  hget,
  hgetall,
  hincrby,
  hincrbyfloat,
  hkeys,
  hlen,
  hmget,
  hmset,
  hrandfield,
  hscan,
  hset,
  hsetnx,
  hstrlen,
  hvals,
  incr,
  incrby,
  incrbyfloat,
  info,
  keys,
  lastsave,
  latency,
  lcs,
  lindex,
  linsert,
  llen,
  lmove,
  lmpop,
  lolwut,
  lpop,
  lpos,
  lpush,
  lpushx,
  lrange,
  lrem,
  lset,
  ltrim,
  memory,
  mget,
  migrate,
  module,
  monitor,
  move,
  mset,
  msetnx,
  multi,
  object,
  persist,
  pexpire,
  pexpireat,
  pexpiretime,
  pfadd,
  pfcount,
  pfdebug,
  pfmerge,
  pfselftest,
  ping,
  psetex,
  psubscribe,
  psync,
  pttl,
  publish,
  pubsub,
  punsubscribe,
  quit,
  randomkey,
  readonly,
  readwrite,
  rename,
  renamenx,
  replconf,
  replicaof,
  reset,
  restore,
  "restore-asking": { "arity": -4, "flags": ["write", "denyoom", "asking"], "keyStart": 1, "keyStop": 1, "step": 1 },
  role,
  rpop,
  rpoplpush,
  rpush,
  rpushx,
  sadd,
  save,
  scan,
  scard,
  script,
  sdiff,
  sdiffstore,
  select,
  set,
  setbit,
  setex,
  setnx,
  setrange,
  shutdown,
  sinter,
  sintercard,
  sinterstore,
  sismember,
  slaveof,
  slowlog,
  smembers,
  smismember,
  smove,
  sort,
  sort_ro,
  spop,
  spublish,
  srandmember,
  srem,
  sscan,
  ssubscribe,
  strlen,
  subscribe,
  substr,
  sunion,
  sunionstore,
  sunsubscribe,
  swapdb,
  sync,
  time,
  touch,
  ttl,
  type,
  unlink,
  unsubscribe,
  unwatch,
  wait,
  watch,
  xack,
  xadd,
  xautoclaim,
  xclaim,
  xdel,
  xgroup,
  xinfo,
  xlen,
  xpending,
  xrange,
  xread,
  xreadgroup,
  xrevrange,
  xsetid,
  xtrim,
  zadd,
  zcard,
  zcount,
  zdiff,
  zdiffstore,
  zincrby,
  zinter,
  zintercard,
  zinterstore,
  zlexcount,
  zmpop,
  zmscore,
  zpopmax,
  zpopmin,
  zrandmember,
  zrange,
  zrangebylex,
  zrangebyscore,
  zrangestore,
  zrank,
  zrem,
  zremrangebylex,
  zremrangebyrank,
  zremrangebyscore,
  zrevrange,
  zrevrangebylex,
  zrevrangebyscore,
  zrevrank,
  zscan,
  zscore,
  zunion,
  zunionstore
};
var hasRequiredBuilt$2;
function requireBuilt$2() {
  if (hasRequiredBuilt$2) return built$1;
  hasRequiredBuilt$2 = 1;
  (function(exports) {
    var __importDefault = built$1 && built$1.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getKeyIndexes = exports.hasFlag = exports.exists = exports.list = void 0;
    const commands_json_1 = __importDefault(require$$0);
    exports.list = Object.keys(commands_json_1.default);
    const flags = {};
    exports.list.forEach((commandName) => {
      flags[commandName] = commands_json_1.default[commandName].flags.reduce(function(flags2, flag) {
        flags2[flag] = true;
        return flags2;
      }, {});
    });
    function exists2(commandName) {
      return Boolean(commands_json_1.default[commandName]);
    }
    exports.exists = exists2;
    function hasFlag2(commandName, flag) {
      if (!flags[commandName]) {
        throw new Error("Unknown command " + commandName);
      }
      return Boolean(flags[commandName][flag]);
    }
    exports.hasFlag = hasFlag2;
    function getKeyIndexes(commandName, args, options) {
      const command2 = commands_json_1.default[commandName];
      if (!command2) {
        throw new Error("Unknown command " + commandName);
      }
      if (!Array.isArray(args)) {
        throw new Error("Expect args to be an array");
      }
      const keys2 = [];
      const parseExternalKey = Boolean(options && options.parseExternalKey);
      const takeDynamicKeys = (args2, startIndex) => {
        const keys3 = [];
        const keyStop = Number(args2[startIndex]);
        for (let i = 0; i < keyStop; i++) {
          keys3.push(i + startIndex + 1);
        }
        return keys3;
      };
      const takeKeyAfterToken = (args2, startIndex, token) => {
        for (let i = startIndex; i < args2.length - 1; i += 1) {
          if (String(args2[i]).toLowerCase() === token.toLowerCase()) {
            return i + 1;
          }
        }
        return null;
      };
      switch (commandName) {
        case "zunionstore":
        case "zinterstore":
        case "zdiffstore":
          keys2.push(0, ...takeDynamicKeys(args, 1));
          break;
        case "eval":
        case "evalsha":
        case "eval_ro":
        case "evalsha_ro":
        case "fcall":
        case "fcall_ro":
        case "blmpop":
        case "bzmpop":
          keys2.push(...takeDynamicKeys(args, 1));
          break;
        case "sintercard":
        case "lmpop":
        case "zunion":
        case "zinter":
        case "zmpop":
        case "zintercard":
        case "zdiff": {
          keys2.push(...takeDynamicKeys(args, 0));
          break;
        }
        case "georadius": {
          keys2.push(0);
          const storeKey = takeKeyAfterToken(args, 5, "STORE");
          if (storeKey)
            keys2.push(storeKey);
          const distKey = takeKeyAfterToken(args, 5, "STOREDIST");
          if (distKey)
            keys2.push(distKey);
          break;
        }
        case "georadiusbymember": {
          keys2.push(0);
          const storeKey = takeKeyAfterToken(args, 4, "STORE");
          if (storeKey)
            keys2.push(storeKey);
          const distKey = takeKeyAfterToken(args, 4, "STOREDIST");
          if (distKey)
            keys2.push(distKey);
          break;
        }
        case "sort":
        case "sort_ro":
          keys2.push(0);
          for (let i = 1; i < args.length - 1; i++) {
            let arg = args[i];
            if (typeof arg !== "string") {
              continue;
            }
            const directive = arg.toUpperCase();
            if (directive === "GET") {
              i += 1;
              arg = args[i];
              if (arg !== "#") {
                if (parseExternalKey) {
                  keys2.push([i, getExternalKeyNameLength(arg)]);
                } else {
                  keys2.push(i);
                }
              }
            } else if (directive === "BY") {
              i += 1;
              if (parseExternalKey) {
                keys2.push([i, getExternalKeyNameLength(args[i])]);
              } else {
                keys2.push(i);
              }
            } else if (directive === "STORE") {
              i += 1;
              keys2.push(i);
            }
          }
          break;
        case "migrate":
          if (args[2] === "") {
            for (let i = 5; i < args.length - 1; i++) {
              const arg = args[i];
              if (typeof arg === "string" && arg.toUpperCase() === "KEYS") {
                for (let j = i + 1; j < args.length; j++) {
                  keys2.push(j);
                }
                break;
              }
            }
          } else {
            keys2.push(2);
          }
          break;
        case "xreadgroup":
        case "xread":
          for (let i = commandName === "xread" ? 0 : 3; i < args.length - 1; i++) {
            if (String(args[i]).toUpperCase() === "STREAMS") {
              for (let j = i + 1; j <= i + (args.length - 1 - i) / 2; j++) {
                keys2.push(j);
              }
              break;
            }
          }
          break;
        default:
          if (command2.step > 0) {
            const keyStart = command2.keyStart - 1;
            const keyStop = command2.keyStop > 0 ? command2.keyStop : args.length + command2.keyStop + 1;
            for (let i = keyStart; i < keyStop; i += command2.step) {
              keys2.push(i);
            }
          }
          break;
      }
      return keys2;
    }
    exports.getKeyIndexes = getKeyIndexes;
    function getExternalKeyNameLength(key) {
      if (typeof key !== "string") {
        key = String(key);
      }
      const hashPos = key.indexOf("->");
      return hashPos === -1 ? key.length : hashPos;
    }
  })(built$1);
  return built$1;
}
var built = {};
var utils$1 = {};
var hasRequiredUtils$1;
function requireUtils$1() {
  if (hasRequiredUtils$1) return utils$1;
  hasRequiredUtils$1 = 1;
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.tryCatch = exports.errorObj = void 0;
    exports.errorObj = { e: {} };
    let tryCatchTarget;
    function tryCatcher(err, val) {
      try {
        const target = tryCatchTarget;
        tryCatchTarget = null;
        return target.apply(this, arguments);
      } catch (e) {
        exports.errorObj.e = e;
        return exports.errorObj;
      }
    }
    function tryCatch(fn) {
      tryCatchTarget = fn;
      return tryCatcher;
    }
    exports.tryCatch = tryCatch;
  })(utils$1);
  return utils$1;
}
var hasRequiredBuilt$1;
function requireBuilt$1() {
  if (hasRequiredBuilt$1) return built;
  hasRequiredBuilt$1 = 1;
  Object.defineProperty(built, "__esModule", { value: true });
  const utils_1 = requireUtils$1();
  function throwLater(e) {
    setTimeout(function() {
      throw e;
    }, 0);
  }
  function asCallback(promise, nodeback, options) {
    if (typeof nodeback === "function") {
      promise.then((val) => {
        let ret;
        if (options !== void 0 && Object(options).spread && Array.isArray(val)) {
          ret = utils_1.tryCatch(nodeback).apply(void 0, [null].concat(val));
        } else {
          ret = val === void 0 ? utils_1.tryCatch(nodeback)(null) : utils_1.tryCatch(nodeback)(null, val);
        }
        if (ret === utils_1.errorObj) {
          throwLater(ret.e);
        }
      }, (cause) => {
        if (!cause) {
          const newReason = new Error(cause + "");
          Object.assign(newReason, { cause });
          cause = newReason;
        }
        const ret = utils_1.tryCatch(nodeback)(cause);
        if (ret === utils_1.errorObj) {
          throwLater(ret.e);
        }
      });
    }
    return promise;
  }
  built.default = asCallback;
  return built;
}
var cluster = {};
var old;
var hasRequiredOld;
function requireOld() {
  if (hasRequiredOld) return old;
  hasRequiredOld = 1;
  const assert = require$$1$1;
  const util2 = require$$1;
  function RedisError(message) {
    Object.defineProperty(this, "message", {
      value: message || "",
      configurable: true,
      writable: true
    });
    Error.captureStackTrace(this, this.constructor);
  }
  util2.inherits(RedisError, Error);
  Object.defineProperty(RedisError.prototype, "name", {
    value: "RedisError",
    configurable: true,
    writable: true
  });
  function ParserError(message, buffer, offset) {
    assert(buffer);
    assert.strictEqual(typeof offset, "number");
    Object.defineProperty(this, "message", {
      value: message || "",
      configurable: true,
      writable: true
    });
    const tmp = Error.stackTraceLimit;
    Error.stackTraceLimit = 2;
    Error.captureStackTrace(this, this.constructor);
    Error.stackTraceLimit = tmp;
    this.offset = offset;
    this.buffer = buffer;
  }
  util2.inherits(ParserError, RedisError);
  Object.defineProperty(ParserError.prototype, "name", {
    value: "ParserError",
    configurable: true,
    writable: true
  });
  function ReplyError(message) {
    Object.defineProperty(this, "message", {
      value: message || "",
      configurable: true,
      writable: true
    });
    const tmp = Error.stackTraceLimit;
    Error.stackTraceLimit = 2;
    Error.captureStackTrace(this, this.constructor);
    Error.stackTraceLimit = tmp;
  }
  util2.inherits(ReplyError, RedisError);
  Object.defineProperty(ReplyError.prototype, "name", {
    value: "ReplyError",
    configurable: true,
    writable: true
  });
  function AbortError(message) {
    Object.defineProperty(this, "message", {
      value: message || "",
      configurable: true,
      writable: true
    });
    Error.captureStackTrace(this, this.constructor);
  }
  util2.inherits(AbortError, RedisError);
  Object.defineProperty(AbortError.prototype, "name", {
    value: "AbortError",
    configurable: true,
    writable: true
  });
  function InterruptError(message) {
    Object.defineProperty(this, "message", {
      value: message || "",
      configurable: true,
      writable: true
    });
    Error.captureStackTrace(this, this.constructor);
  }
  util2.inherits(InterruptError, AbortError);
  Object.defineProperty(InterruptError.prototype, "name", {
    value: "InterruptError",
    configurable: true,
    writable: true
  });
  old = {
    RedisError,
    ParserError,
    ReplyError,
    AbortError,
    InterruptError
  };
  return old;
}
var modern;
var hasRequiredModern;
function requireModern() {
  if (hasRequiredModern) return modern;
  hasRequiredModern = 1;
  const assert = require$$1$1;
  class RedisError extends Error {
    get name() {
      return this.constructor.name;
    }
  }
  class ParserError extends RedisError {
    constructor(message, buffer, offset) {
      assert(buffer);
      assert.strictEqual(typeof offset, "number");
      const tmp = Error.stackTraceLimit;
      Error.stackTraceLimit = 2;
      super(message);
      Error.stackTraceLimit = tmp;
      this.offset = offset;
      this.buffer = buffer;
    }
    get name() {
      return this.constructor.name;
    }
  }
  class ReplyError extends RedisError {
    constructor(message) {
      const tmp = Error.stackTraceLimit;
      Error.stackTraceLimit = 2;
      super(message);
      Error.stackTraceLimit = tmp;
    }
    get name() {
      return this.constructor.name;
    }
  }
  class AbortError extends RedisError {
    get name() {
      return this.constructor.name;
    }
  }
  class InterruptError extends AbortError {
    get name() {
      return this.constructor.name;
    }
  }
  modern = {
    RedisError,
    ParserError,
    ReplyError,
    AbortError,
    InterruptError
  };
  return modern;
}
var redisErrors;
var hasRequiredRedisErrors;
function requireRedisErrors() {
  if (hasRequiredRedisErrors) return redisErrors;
  hasRequiredRedisErrors = 1;
  const Errors = process.version.charCodeAt(1) < 55 && process.version.charCodeAt(2) === 46 ? requireOld() : requireModern();
  redisErrors = Errors;
  return redisErrors;
}
var Command = {};
var lib = { exports: {} };
var hasRequiredLib;
function requireLib() {
  if (hasRequiredLib) return lib.exports;
  hasRequiredLib = 1;
  var lookup = [
    0,
    4129,
    8258,
    12387,
    16516,
    20645,
    24774,
    28903,
    33032,
    37161,
    41290,
    45419,
    49548,
    53677,
    57806,
    61935,
    4657,
    528,
    12915,
    8786,
    21173,
    17044,
    29431,
    25302,
    37689,
    33560,
    45947,
    41818,
    54205,
    50076,
    62463,
    58334,
    9314,
    13379,
    1056,
    5121,
    25830,
    29895,
    17572,
    21637,
    42346,
    46411,
    34088,
    38153,
    58862,
    62927,
    50604,
    54669,
    13907,
    9842,
    5649,
    1584,
    30423,
    26358,
    22165,
    18100,
    46939,
    42874,
    38681,
    34616,
    63455,
    59390,
    55197,
    51132,
    18628,
    22757,
    26758,
    30887,
    2112,
    6241,
    10242,
    14371,
    51660,
    55789,
    59790,
    63919,
    35144,
    39273,
    43274,
    47403,
    23285,
    19156,
    31415,
    27286,
    6769,
    2640,
    14899,
    10770,
    56317,
    52188,
    64447,
    60318,
    39801,
    35672,
    47931,
    43802,
    27814,
    31879,
    19684,
    23749,
    11298,
    15363,
    3168,
    7233,
    60846,
    64911,
    52716,
    56781,
    44330,
    48395,
    36200,
    40265,
    32407,
    28342,
    24277,
    20212,
    15891,
    11826,
    7761,
    3696,
    65439,
    61374,
    57309,
    53244,
    48923,
    44858,
    40793,
    36728,
    37256,
    33193,
    45514,
    41451,
    53516,
    49453,
    61774,
    57711,
    4224,
    161,
    12482,
    8419,
    20484,
    16421,
    28742,
    24679,
    33721,
    37784,
    41979,
    46042,
    49981,
    54044,
    58239,
    62302,
    689,
    4752,
    8947,
    13010,
    16949,
    21012,
    25207,
    29270,
    46570,
    42443,
    38312,
    34185,
    62830,
    58703,
    54572,
    50445,
    13538,
    9411,
    5280,
    1153,
    29798,
    25671,
    21540,
    17413,
    42971,
    47098,
    34713,
    38840,
    59231,
    63358,
    50973,
    55100,
    9939,
    14066,
    1681,
    5808,
    26199,
    30326,
    17941,
    22068,
    55628,
    51565,
    63758,
    59695,
    39368,
    35305,
    47498,
    43435,
    22596,
    18533,
    30726,
    26663,
    6336,
    2273,
    14466,
    10403,
    52093,
    56156,
    60223,
    64286,
    35833,
    39896,
    43963,
    48026,
    19061,
    23124,
    27191,
    31254,
    2801,
    6864,
    10931,
    14994,
    64814,
    60687,
    56684,
    52557,
    48554,
    44427,
    40424,
    36297,
    31782,
    27655,
    23652,
    19525,
    15522,
    11395,
    7392,
    3265,
    61215,
    65342,
    53085,
    57212,
    44955,
    49082,
    36825,
    40952,
    28183,
    32310,
    20053,
    24180,
    11923,
    16050,
    3793,
    7920
  ];
  var toUTF8Array = function toUTF8Array2(str) {
    var char;
    var i = 0;
    var p = 0;
    var utf8 = [];
    var len = str.length;
    for (; i < len; i++) {
      char = str.charCodeAt(i);
      if (char < 128) {
        utf8[p++] = char;
      } else if (char < 2048) {
        utf8[p++] = char >> 6 | 192;
        utf8[p++] = char & 63 | 128;
      } else if ((char & 64512) === 55296 && i + 1 < str.length && (str.charCodeAt(i + 1) & 64512) === 56320) {
        char = 65536 + ((char & 1023) << 10) + (str.charCodeAt(++i) & 1023);
        utf8[p++] = char >> 18 | 240;
        utf8[p++] = char >> 12 & 63 | 128;
        utf8[p++] = char >> 6 & 63 | 128;
        utf8[p++] = char & 63 | 128;
      } else {
        utf8[p++] = char >> 12 | 224;
        utf8[p++] = char >> 6 & 63 | 128;
        utf8[p++] = char & 63 | 128;
      }
    }
    return utf8;
  };
  var generate = lib.exports = function generate2(str) {
    var char;
    var i = 0;
    var start = -1;
    var result = 0;
    var resultHash = 0;
    var utf8 = typeof str === "string" ? toUTF8Array(str) : str;
    var len = utf8.length;
    while (i < len) {
      char = utf8[i++];
      if (start === -1) {
        if (char === 123) {
          start = i;
        }
      } else if (char !== 125) {
        resultHash = lookup[(char ^ resultHash >> 8) & 255] ^ resultHash << 8;
      } else if (i - 1 !== start) {
        return resultHash & 16383;
      }
      result = lookup[(char ^ result >> 8) & 255] ^ result << 8;
    }
    return result & 16383;
  };
  lib.exports.generateMulti = function generateMulti(keys2) {
    var i = 1;
    var len = keys2.length;
    var base = generate(keys2[0]);
    while (i < len) {
      if (generate(keys2[i++]) !== base) return -1;
    }
    return base;
  };
  return lib.exports;
}
var utils = {};
var lodash = {};
var lodash_defaults;
var hasRequiredLodash_defaults;
function requireLodash_defaults() {
  if (hasRequiredLodash_defaults) return lodash_defaults;
  hasRequiredLodash_defaults = 1;
  var MAX_SAFE_INTEGER = 9007199254740991;
  var argsTag = "[object Arguments]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]";
  var reIsUint = /^(?:0|[1-9]\d*)$/;
  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }
  function baseTimes(n, iteratee) {
    var index = -1, result = Array(n);
    while (++index < n) {
      result[index] = iteratee(index);
    }
    return result;
  }
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  var objectToString = objectProto.toString;
  var propertyIsEnumerable = objectProto.propertyIsEnumerable;
  var nativeMax = Math.max;
  function arrayLikeKeys(value, inherited) {
    var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
    var length = result.length, skipIndexes = !!length;
    for (var key in value) {
      if (!(skipIndexes && (key == "length" || isIndex(key, length)))) {
        result.push(key);
      }
    }
    return result;
  }
  function assignInDefaults(objValue, srcValue, key, object2) {
    if (objValue === void 0 || eq(objValue, objectProto[key]) && !hasOwnProperty.call(object2, key)) {
      return srcValue;
    }
    return objValue;
  }
  function assignValue(object2, key, value) {
    var objValue = object2[key];
    if (!(hasOwnProperty.call(object2, key) && eq(objValue, value)) || value === void 0 && !(key in object2)) {
      object2[key] = value;
    }
  }
  function baseKeysIn(object2) {
    if (!isObject(object2)) {
      return nativeKeysIn(object2);
    }
    var isProto = isPrototype(object2), result = [];
    for (var key in object2) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty.call(object2, key)))) {
        result.push(key);
      }
    }
    return result;
  }
  function baseRest(func, start) {
    start = nativeMax(start === void 0 ? func.length - 1 : start, 0);
    return function() {
      var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array(length);
      while (++index < length) {
        array[index] = args[start + index];
      }
      index = -1;
      var otherArgs = Array(start + 1);
      while (++index < start) {
        otherArgs[index] = args[index];
      }
      otherArgs[start] = array;
      return apply(func, this, otherArgs);
    };
  }
  function copyObject(source, props, object2, customizer) {
    object2 || (object2 = {});
    var index = -1, length = props.length;
    while (++index < length) {
      var key = props[index];
      var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : void 0;
      assignValue(object2, key, newValue === void 0 ? source[key] : newValue);
    }
    return object2;
  }
  function createAssigner(assigner) {
    return baseRest(function(object2, sources) {
      var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : void 0, guard = length > 2 ? sources[2] : void 0;
      customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        customizer = length < 3 ? void 0 : customizer;
        length = 1;
      }
      object2 = Object(object2);
      while (++index < length) {
        var source = sources[index];
        if (source) {
          assigner(object2, source, index, customizer);
        }
      }
      return object2;
    });
  }
  function isIndex(value, length) {
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length && (typeof value == "number" || reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
  }
  function isIterateeCall(value, index, object2) {
    if (!isObject(object2)) {
      return false;
    }
    var type2 = typeof index;
    if (type2 == "number" ? isArrayLike(object2) && isIndex(index, object2.length) : type2 == "string" && index in object2) {
      return eq(object2[index], value);
    }
    return false;
  }
  function isPrototype(value) {
    var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
    return value === proto;
  }
  function nativeKeysIn(object2) {
    var result = [];
    if (object2 != null) {
      for (var key in Object(object2)) {
        result.push(key);
      }
    }
    return result;
  }
  function eq(value, other) {
    return value === other || value !== value && other !== other;
  }
  function isArguments(value) {
    return isArrayLikeObject(value) && hasOwnProperty.call(value, "callee") && (!propertyIsEnumerable.call(value, "callee") || objectToString.call(value) == argsTag);
  }
  var isArray = Array.isArray;
  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  function isArrayLikeObject(value) {
    return isObjectLike(value) && isArrayLike(value);
  }
  function isFunction(value) {
    var tag = isObject(value) ? objectToString.call(value) : "";
    return tag == funcTag || tag == genTag;
  }
  function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }
  function isObject(value) {
    var type2 = typeof value;
    return !!value && (type2 == "object" || type2 == "function");
  }
  function isObjectLike(value) {
    return !!value && typeof value == "object";
  }
  var assignInWith = createAssigner(function(object2, source, srcIndex, customizer) {
    copyObject(source, keysIn(source), object2, customizer);
  });
  var defaults = baseRest(function(args) {
    args.push(void 0, assignInDefaults);
    return apply(assignInWith, void 0, args);
  });
  function keysIn(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2) : baseKeysIn(object2);
  }
  lodash_defaults = defaults;
  return lodash_defaults;
}
var lodash_isarguments;
var hasRequiredLodash_isarguments;
function requireLodash_isarguments() {
  if (hasRequiredLodash_isarguments) return lodash_isarguments;
  hasRequiredLodash_isarguments = 1;
  var MAX_SAFE_INTEGER = 9007199254740991;
  var argsTag = "[object Arguments]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]";
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  var objectToString = objectProto.toString;
  var propertyIsEnumerable = objectProto.propertyIsEnumerable;
  function isArguments(value) {
    return isArrayLikeObject(value) && hasOwnProperty.call(value, "callee") && (!propertyIsEnumerable.call(value, "callee") || objectToString.call(value) == argsTag);
  }
  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  function isArrayLikeObject(value) {
    return isObjectLike(value) && isArrayLike(value);
  }
  function isFunction(value) {
    var tag = isObject(value) ? objectToString.call(value) : "";
    return tag == funcTag || tag == genTag;
  }
  function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }
  function isObject(value) {
    var type2 = typeof value;
    return !!value && (type2 == "object" || type2 == "function");
  }
  function isObjectLike(value) {
    return !!value && typeof value == "object";
  }
  lodash_isarguments = isArguments;
  return lodash_isarguments;
}
var hasRequiredLodash;
function requireLodash() {
  if (hasRequiredLodash) return lodash;
  hasRequiredLodash = 1;
  Object.defineProperty(lodash, "__esModule", { value: true });
  lodash.isArguments = lodash.defaults = lodash.noop = void 0;
  const defaults = requireLodash_defaults();
  lodash.defaults = defaults;
  const isArguments = requireLodash_isarguments();
  lodash.isArguments = isArguments;
  function noop() {
  }
  lodash.noop = noop;
  return lodash;
}
var debug = {};
var src = { exports: {} };
var browser = { exports: {} };
var ms;
var hasRequiredMs;
function requireMs() {
  if (hasRequiredMs) return ms;
  hasRequiredMs = 1;
  var s = 1e3;
  var m = s * 60;
  var h = m * 60;
  var d = h * 24;
  var w = d * 7;
  var y = d * 365.25;
  ms = function(val, options) {
    options = options || {};
    var type2 = typeof val;
    if (type2 === "string" && val.length > 0) {
      return parse(val);
    } else if (type2 === "number" && isFinite(val)) {
      return options.long ? fmtLong(val) : fmtShort(val);
    }
    throw new Error(
      "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
    );
  };
  function parse(str) {
    str = String(str);
    if (str.length > 100) {
      return;
    }
    var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
      str
    );
    if (!match) {
      return;
    }
    var n = parseFloat(match[1]);
    var type2 = (match[2] || "ms").toLowerCase();
    switch (type2) {
      case "years":
      case "year":
      case "yrs":
      case "yr":
      case "y":
        return n * y;
      case "weeks":
      case "week":
      case "w":
        return n * w;
      case "days":
      case "day":
      case "d":
        return n * d;
      case "hours":
      case "hour":
      case "hrs":
      case "hr":
      case "h":
        return n * h;
      case "minutes":
      case "minute":
      case "mins":
      case "min":
      case "m":
        return n * m;
      case "seconds":
      case "second":
      case "secs":
      case "sec":
      case "s":
        return n * s;
      case "milliseconds":
      case "millisecond":
      case "msecs":
      case "msec":
      case "ms":
        return n;
      default:
        return void 0;
    }
  }
  function fmtShort(ms2) {
    var msAbs = Math.abs(ms2);
    if (msAbs >= d) {
      return Math.round(ms2 / d) + "d";
    }
    if (msAbs >= h) {
      return Math.round(ms2 / h) + "h";
    }
    if (msAbs >= m) {
      return Math.round(ms2 / m) + "m";
    }
    if (msAbs >= s) {
      return Math.round(ms2 / s) + "s";
    }
    return ms2 + "ms";
  }
  function fmtLong(ms2) {
    var msAbs = Math.abs(ms2);
    if (msAbs >= d) {
      return plural(ms2, msAbs, d, "day");
    }
    if (msAbs >= h) {
      return plural(ms2, msAbs, h, "hour");
    }
    if (msAbs >= m) {
      return plural(ms2, msAbs, m, "minute");
    }
    if (msAbs >= s) {
      return plural(ms2, msAbs, s, "second");
    }
    return ms2 + " ms";
  }
  function plural(ms2, msAbs, n, name) {
    var isPlural = msAbs >= n * 1.5;
    return Math.round(ms2 / n) + " " + name + (isPlural ? "s" : "");
  }
  return ms;
}
var common;
var hasRequiredCommon;
function requireCommon() {
  if (hasRequiredCommon) return common;
  hasRequiredCommon = 1;
  function setup(env) {
    createDebug.debug = createDebug;
    createDebug.default = createDebug;
    createDebug.coerce = coerce;
    createDebug.disable = disable;
    createDebug.enable = enable;
    createDebug.enabled = enabled;
    createDebug.humanize = requireMs();
    createDebug.destroy = destroy;
    Object.keys(env).forEach((key) => {
      createDebug[key] = env[key];
    });
    createDebug.names = [];
    createDebug.skips = [];
    createDebug.formatters = {};
    function selectColor(namespace) {
      let hash = 0;
      for (let i = 0; i < namespace.length; i++) {
        hash = (hash << 5) - hash + namespace.charCodeAt(i);
        hash |= 0;
      }
      return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    }
    createDebug.selectColor = selectColor;
    function createDebug(namespace) {
      let prevTime;
      let enableOverride = null;
      let namespacesCache;
      let enabledCache;
      function debug2(...args) {
        if (!debug2.enabled) {
          return;
        }
        const self2 = debug2;
        const curr = Number(/* @__PURE__ */ new Date());
        const ms2 = curr - (prevTime || curr);
        self2.diff = ms2;
        self2.prev = prevTime;
        self2.curr = curr;
        prevTime = curr;
        args[0] = createDebug.coerce(args[0]);
        if (typeof args[0] !== "string") {
          args.unshift("%O");
        }
        let index = 0;
        args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
          if (match === "%%") {
            return "%";
          }
          index++;
          const formatter = createDebug.formatters[format];
          if (typeof formatter === "function") {
            const val = args[index];
            match = formatter.call(self2, val);
            args.splice(index, 1);
            index--;
          }
          return match;
        });
        createDebug.formatArgs.call(self2, args);
        const logFn = self2.log || createDebug.log;
        logFn.apply(self2, args);
      }
      debug2.namespace = namespace;
      debug2.useColors = createDebug.useColors();
      debug2.color = createDebug.selectColor(namespace);
      debug2.extend = extend;
      debug2.destroy = createDebug.destroy;
      Object.defineProperty(debug2, "enabled", {
        enumerable: true,
        configurable: false,
        get: () => {
          if (enableOverride !== null) {
            return enableOverride;
          }
          if (namespacesCache !== createDebug.namespaces) {
            namespacesCache = createDebug.namespaces;
            enabledCache = createDebug.enabled(namespace);
          }
          return enabledCache;
        },
        set: (v) => {
          enableOverride = v;
        }
      });
      if (typeof createDebug.init === "function") {
        createDebug.init(debug2);
      }
      return debug2;
    }
    function extend(namespace, delimiter) {
      const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
      newDebug.log = this.log;
      return newDebug;
    }
    function enable(namespaces) {
      createDebug.save(namespaces);
      createDebug.namespaces = namespaces;
      createDebug.names = [];
      createDebug.skips = [];
      const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(/\s+/g, ",").split(",").filter(Boolean);
      for (const ns of split) {
        if (ns[0] === "-") {
          createDebug.skips.push(ns.slice(1));
        } else {
          createDebug.names.push(ns);
        }
      }
    }
    function matchesTemplate(search, template) {
      let searchIndex = 0;
      let templateIndex = 0;
      let starIndex = -1;
      let matchIndex = 0;
      while (searchIndex < search.length) {
        if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
          if (template[templateIndex] === "*") {
            starIndex = templateIndex;
            matchIndex = searchIndex;
            templateIndex++;
          } else {
            searchIndex++;
            templateIndex++;
          }
        } else if (starIndex !== -1) {
          templateIndex = starIndex + 1;
          matchIndex++;
          searchIndex = matchIndex;
        } else {
          return false;
        }
      }
      while (templateIndex < template.length && template[templateIndex] === "*") {
        templateIndex++;
      }
      return templateIndex === template.length;
    }
    function disable() {
      const namespaces = [
        ...createDebug.names,
        ...createDebug.skips.map((namespace) => "-" + namespace)
      ].join(",");
      createDebug.enable("");
      return namespaces;
    }
    function enabled(name) {
      for (const skip of createDebug.skips) {
        if (matchesTemplate(name, skip)) {
          return false;
        }
      }
      for (const ns of createDebug.names) {
        if (matchesTemplate(name, ns)) {
          return true;
        }
      }
      return false;
    }
    function coerce(val) {
      if (val instanceof Error) {
        return val.stack || val.message;
      }
      return val;
    }
    function destroy() {
      console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
    }
    createDebug.enable(createDebug.load());
    return createDebug;
  }
  common = setup;
  return common;
}
var hasRequiredBrowser;
function requireBrowser() {
  if (hasRequiredBrowser) return browser.exports;
  hasRequiredBrowser = 1;
  (function(module2, exports) {
    exports.formatArgs = formatArgs;
    exports.save = save2;
    exports.load = load;
    exports.useColors = useColors;
    exports.storage = localstorage();
    exports.destroy = /* @__PURE__ */ (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      let m;
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
      typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
      // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
      typeof navigator !== "undefined" && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
      typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c = "color: " + this.color;
      args.splice(1, 0, c, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }
    exports.log = console.debug || console.log || (() => {
    });
    function save2(namespaces) {
      try {
        if (namespaces) {
          exports.storage.setItem("debug", namespaces);
        } else {
          exports.storage.removeItem("debug");
        }
      } catch (error) {
      }
    }
    function load() {
      let r;
      try {
        r = exports.storage.getItem("debug") || exports.storage.getItem("DEBUG");
      } catch (error) {
      }
      if (!r && typeof process !== "undefined" && "env" in process) {
        r = process.env.DEBUG;
      }
      return r;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {
      }
    }
    module2.exports = requireCommon()(exports);
    const { formatters } = module2.exports;
    formatters.j = function(v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  })(browser, browser.exports);
  return browser.exports;
}
var node = { exports: {} };
var hasFlag;
var hasRequiredHasFlag;
function requireHasFlag() {
  if (hasRequiredHasFlag) return hasFlag;
  hasRequiredHasFlag = 1;
  hasFlag = (flag, argv = process.argv) => {
    const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
    const position = argv.indexOf(prefix + flag);
    const terminatorPosition = argv.indexOf("--");
    return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
  };
  return hasFlag;
}
var supportsColor_1;
var hasRequiredSupportsColor;
function requireSupportsColor() {
  if (hasRequiredSupportsColor) return supportsColor_1;
  hasRequiredSupportsColor = 1;
  const os = require$$2;
  const tty = require$$1$2;
  const hasFlag2 = requireHasFlag();
  const { env } = process;
  let forceColor;
  if (hasFlag2("no-color") || hasFlag2("no-colors") || hasFlag2("color=false") || hasFlag2("color=never")) {
    forceColor = 0;
  } else if (hasFlag2("color") || hasFlag2("colors") || hasFlag2("color=true") || hasFlag2("color=always")) {
    forceColor = 1;
  }
  if ("FORCE_COLOR" in env) {
    if (env.FORCE_COLOR === "true") {
      forceColor = 1;
    } else if (env.FORCE_COLOR === "false") {
      forceColor = 0;
    } else {
      forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
    }
  }
  function translateLevel(level) {
    if (level === 0) {
      return false;
    }
    return {
      level,
      hasBasic: true,
      has256: level >= 2,
      has16m: level >= 3
    };
  }
  function supportsColor(haveStream, streamIsTTY) {
    if (forceColor === 0) {
      return 0;
    }
    if (hasFlag2("color=16m") || hasFlag2("color=full") || hasFlag2("color=truecolor")) {
      return 3;
    }
    if (hasFlag2("color=256")) {
      return 2;
    }
    if (haveStream && !streamIsTTY && forceColor === void 0) {
      return 0;
    }
    const min = forceColor || 0;
    if (env.TERM === "dumb") {
      return min;
    }
    if (process.platform === "win32") {
      const osRelease = os.release().split(".");
      if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
        return Number(osRelease[2]) >= 14931 ? 3 : 2;
      }
      return 1;
    }
    if ("CI" in env) {
      if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign) => sign in env) || env.CI_NAME === "codeship") {
        return 1;
      }
      return min;
    }
    if ("TEAMCITY_VERSION" in env) {
      return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
    }
    if (env.COLORTERM === "truecolor") {
      return 3;
    }
    if ("TERM_PROGRAM" in env) {
      const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
      switch (env.TERM_PROGRAM) {
        case "iTerm.app":
          return version >= 3 ? 3 : 2;
        case "Apple_Terminal":
          return 2;
      }
    }
    if (/-256(color)?$/i.test(env.TERM)) {
      return 2;
    }
    if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
      return 1;
    }
    if ("COLORTERM" in env) {
      return 1;
    }
    return min;
  }
  function getSupportLevel(stream) {
    const level = supportsColor(stream, stream && stream.isTTY);
    return translateLevel(level);
  }
  supportsColor_1 = {
    supportsColor: getSupportLevel,
    stdout: translateLevel(supportsColor(true, tty.isatty(1))),
    stderr: translateLevel(supportsColor(true, tty.isatty(2)))
  };
  return supportsColor_1;
}
var hasRequiredNode;
function requireNode() {
  if (hasRequiredNode) return node.exports;
  hasRequiredNode = 1;
  (function(module2, exports) {
    const tty = require$$1$2;
    const util2 = require$$1;
    exports.init = init;
    exports.log = log;
    exports.formatArgs = formatArgs;
    exports.save = save2;
    exports.load = load;
    exports.useColors = useColors;
    exports.destroy = util2.deprecate(
      () => {
      },
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
    );
    exports.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = requireSupportsColor();
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports.colors = [
          20,
          21,
          26,
          27,
          32,
          33,
          38,
          39,
          40,
          41,
          42,
          43,
          44,
          45,
          56,
          57,
          62,
          63,
          68,
          69,
          74,
          75,
          76,
          77,
          78,
          79,
          80,
          81,
          92,
          93,
          98,
          99,
          112,
          113,
          128,
          129,
          134,
          135,
          148,
          149,
          160,
          161,
          162,
          163,
          164,
          165,
          166,
          167,
          168,
          169,
          170,
          171,
          172,
          173,
          178,
          179,
          184,
          185,
          196,
          197,
          198,
          199,
          200,
          201,
          202,
          203,
          204,
          205,
          206,
          207,
          208,
          209,
          214,
          215,
          220,
          221
        ];
      }
    } catch (error) {
    }
    exports.inspectOpts = Object.keys(process.env).filter((key) => {
      return /^debug_/i.test(key);
    }).reduce((obj, key) => {
      const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
        return k.toUpperCase();
      });
      let val = process.env[key];
      if (/^(yes|on|true|enabled)$/i.test(val)) {
        val = true;
      } else if (/^(no|off|false|disabled)$/i.test(val)) {
        val = false;
      } else if (val === "null") {
        val = null;
      } else {
        val = Number(val);
      }
      obj[prop] = val;
      return obj;
    }, {});
    function useColors() {
      return "colors" in exports.inspectOpts ? Boolean(exports.inspectOpts.colors) : tty.isatty(process.stderr.fd);
    }
    function formatArgs(args) {
      const { namespace: name, useColors: useColors2 } = this;
      if (useColors2) {
        const c = this.color;
        const colorCode = "\x1B[3" + (c < 8 ? c : "8;5;" + c);
        const prefix = `  ${colorCode};1m${name} \x1B[0m`;
        args[0] = prefix + args[0].split("\n").join("\n" + prefix);
        args.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
      } else {
        args[0] = getDate() + name + " " + args[0];
      }
    }
    function getDate() {
      if (exports.inspectOpts.hideDate) {
        return "";
      }
      return (/* @__PURE__ */ new Date()).toISOString() + " ";
    }
    function log(...args) {
      return process.stderr.write(util2.formatWithOptions(exports.inspectOpts, ...args) + "\n");
    }
    function save2(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    function load() {
      return process.env.DEBUG;
    }
    function init(debug2) {
      debug2.inspectOpts = {};
      const keys2 = Object.keys(exports.inspectOpts);
      for (let i = 0; i < keys2.length; i++) {
        debug2.inspectOpts[keys2[i]] = exports.inspectOpts[keys2[i]];
      }
    }
    module2.exports = requireCommon()(exports);
    const { formatters } = module2.exports;
    formatters.o = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util2.inspect(v, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
    };
    formatters.O = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util2.inspect(v, this.inspectOpts);
    };
  })(node, node.exports);
  return node.exports;
}
var hasRequiredSrc;
function requireSrc() {
  if (hasRequiredSrc) return src.exports;
  hasRequiredSrc = 1;
  if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
    src.exports = requireBrowser();
  } else {
    src.exports = requireNode();
  }
  return src.exports;
}
var hasRequiredDebug;
function requireDebug() {
  if (hasRequiredDebug) return debug;
  hasRequiredDebug = 1;
  Object.defineProperty(debug, "__esModule", { value: true });
  debug.genRedactedString = debug.getStringValue = debug.MAX_ARGUMENT_LENGTH = void 0;
  const debug_1 = requireSrc();
  const MAX_ARGUMENT_LENGTH = 200;
  debug.MAX_ARGUMENT_LENGTH = MAX_ARGUMENT_LENGTH;
  const NAMESPACE_PREFIX = "ioredis";
  function getStringValue(v) {
    if (v === null) {
      return;
    }
    switch (typeof v) {
      case "boolean":
        return;
      case "number":
        return;
      case "object":
        if (Buffer.isBuffer(v)) {
          return v.toString("hex");
        }
        if (Array.isArray(v)) {
          return v.join(",");
        }
        try {
          return JSON.stringify(v);
        } catch (e) {
          return;
        }
      case "string":
        return v;
    }
  }
  debug.getStringValue = getStringValue;
  function genRedactedString(str, maxLen) {
    const { length } = str;
    return length <= maxLen ? str : str.slice(0, maxLen) + ' ... <REDACTED full-length="' + length + '">';
  }
  debug.genRedactedString = genRedactedString;
  function genDebugFunction(namespace) {
    const fn = (0, debug_1.default)(`${NAMESPACE_PREFIX}:${namespace}`);
    function wrappedDebug(...args) {
      if (!fn.enabled) {
        return;
      }
      for (let i = 1; i < args.length; i++) {
        const str = getStringValue(args[i]);
        if (typeof str === "string" && str.length > MAX_ARGUMENT_LENGTH) {
          args[i] = genRedactedString(str, MAX_ARGUMENT_LENGTH);
        }
      }
      return fn.apply(null, args);
    }
    Object.defineProperties(wrappedDebug, {
      namespace: {
        get() {
          return fn.namespace;
        }
      },
      enabled: {
        get() {
          return fn.enabled;
        }
      },
      destroy: {
        get() {
          return fn.destroy;
        }
      },
      log: {
        get() {
          return fn.log;
        },
        set(l) {
          fn.log = l;
        }
      }
    });
    return wrappedDebug;
  }
  debug.default = genDebugFunction;
  return debug;
}
var TLSProfiles = {};
var hasRequiredTLSProfiles;
function requireTLSProfiles() {
  if (hasRequiredTLSProfiles) return TLSProfiles;
  hasRequiredTLSProfiles = 1;
  Object.defineProperty(TLSProfiles, "__esModule", { value: true });
  const RedisCloudCA = `-----BEGIN CERTIFICATE-----
MIIDTzCCAjegAwIBAgIJAKSVpiDswLcwMA0GCSqGSIb3DQEBBQUAMD4xFjAUBgNV
BAoMDUdhcmFudGlhIERhdGExJDAiBgNVBAMMG1NTTCBDZXJ0aWZpY2F0aW9uIEF1
dGhvcml0eTAeFw0xMzEwMDExMjE0NTVaFw0yMzA5MjkxMjE0NTVaMD4xFjAUBgNV
BAoMDUdhcmFudGlhIERhdGExJDAiBgNVBAMMG1NTTCBDZXJ0aWZpY2F0aW9uIEF1
dGhvcml0eTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALZqkh/DczWP
JnxnHLQ7QL0T4B4CDKWBKCcisriGbA6ZePWVNo4hfKQC6JrzfR+081NeD6VcWUiz
rmd+jtPhIY4c+WVQYm5PKaN6DT1imYdxQw7aqO5j2KUCEh/cznpLxeSHoTxlR34E
QwF28Wl3eg2vc5ct8LjU3eozWVk3gb7alx9mSA2SgmuX5lEQawl++rSjsBStemY2
BDwOpAMXIrdEyP/cVn8mkvi/BDs5M5G+09j0gfhyCzRWMQ7Hn71u1eolRxwVxgi3
TMn+/vTaFSqxKjgck6zuAYjBRPaHe7qLxHNr1So/Mc9nPy+3wHebFwbIcnUojwbp
4nctkWbjb2cCAwEAAaNQME4wHQYDVR0OBBYEFP1whtcrydmW3ZJeuSoKZIKjze3w
MB8GA1UdIwQYMBaAFP1whtcrydmW3ZJeuSoKZIKjze3wMAwGA1UdEwQFMAMBAf8w
DQYJKoZIhvcNAQEFBQADggEBAG2erXhwRAa7+ZOBs0B6X57Hwyd1R4kfmXcs0rta
lbPpvgULSiB+TCbf3EbhJnHGyvdCY1tvlffLjdA7HJ0PCOn+YYLBA0pTU/dyvrN6
Su8NuS5yubnt9mb13nDGYo1rnt0YRfxN+8DM3fXIVr038A30UlPX2Ou1ExFJT0MZ
uFKY6ZvLdI6/1cbgmguMlAhM+DhKyV6Sr5699LM3zqeI816pZmlREETYkGr91q7k
BpXJu/dtHaGxg1ZGu6w/PCsYGUcECWENYD4VQPd8N32JjOfu6vEgoEAwfPP+3oGp
Z4m3ewACcWOAenqflb+cQYC4PsF7qbXDmRaWrbKntOlZ3n0=
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIIFujCCA6KgAwIBAgIJAJ1aTT1lu2ScMA0GCSqGSIb3DQEBCwUAMGoxCzAJBgNV
BAYTAlVTMQswCQYDVQQIDAJDQTELMAkGA1UEBwwCQ0ExEjAQBgNVBAoMCVJlZGlz
TGFiczEtMCsGA1UEAwwkUmVkaXNMYWJzIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MB4XDTE4MDIyNTE1MjA0MloXDTM4MDIyMDE1MjA0MlowajELMAkGA1UEBhMC
VVMxCzAJBgNVBAgMAkNBMQswCQYDVQQHDAJDQTESMBAGA1UECgwJUmVkaXNMYWJz
MS0wKwYDVQQDDCRSZWRpc0xhYnMgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkw
ggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDLEjXy7YrbN5Waau5cd6g1
G5C2tMmeTpZ0duFAPxNU4oE3RHS5gGiok346fUXuUxbZ6QkuzeN2/2Z+RmRcJhQY
Dm0ZgdG4x59An1TJfnzKKoWj8ISmoHS/TGNBdFzXV7FYNLBuqZouqePI6ReC6Qhl
pp45huV32Q3a6IDrrvx7Wo5ZczEQeFNbCeCOQYNDdTmCyEkHqc2AGo8eoIlSTutT
ULOC7R5gzJVTS0e1hesQ7jmqHjbO+VQS1NAL4/5K6cuTEqUl+XhVhPdLWBXJQ5ag
54qhX4v+ojLzeU1R/Vc6NjMvVtptWY6JihpgplprN0Yh2556ewcXMeturcKgXfGJ
xeYzsjzXerEjrVocX5V8BNrg64NlifzTMKNOOv4fVZszq1SIHR8F9ROrqiOdh8iC
JpUbLpXH9hWCSEO6VRMB2xJoKu3cgl63kF30s77x7wLFMEHiwsQRKxooE1UhgS9K
2sO4TlQ1eWUvFvHSTVDQDlGQ6zu4qjbOpb3Q8bQwoK+ai2alkXVR4Ltxe9QlgYK3
StsnPhruzZGA0wbXdpw0bnM+YdlEm5ffSTpNIfgHeaa7Dtb801FtA71ZlH7A6TaI
SIQuUST9EKmv7xrJyx0W1pGoPOLw5T029aTjnICSLdtV9bLwysrLhIYG5bnPq78B
cS+jZHFGzD7PUVGQD01nOQIDAQABo2MwYTAdBgNVHQ4EFgQUIuNsB+oTOC9rLoxL
yzNP7vJUV08wHwYDVR0jBBgwFoAUIuNsB+oTOC9rLoxLyzNP7vJUV08wDwYDVR0T
AQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADggIBAHfg
z5pMNUAKdMzK1aS1EDdK9yKz4qicILz5czSLj1mC7HKDRy8cVADUxEICis++CsCu
rYOvyCVergHQLREcxPq4rc5Nq1uj6J6649NEeh4WazOOjL4ZfQ1jVznMbGy+fJm3
3Hoelv6jWRG9iqeJZja7/1s6YC6bWymI/OY1e4wUKeNHAo+Vger7MlHV+RuabaX+
hSJ8bJAM59NCM7AgMTQpJCncrcdLeceYniGy5Q/qt2b5mJkQVkIdy4TPGGB+AXDJ
D0q3I/JDRkDUFNFdeW0js7fHdsvCR7O3tJy5zIgEV/o/BCkmJVtuwPYOrw/yOlKj
TY/U7ATAx9VFF6/vYEOMYSmrZlFX+98L6nJtwDqfLB5VTltqZ4H/KBxGE3IRSt9l
FXy40U+LnXzhhW+7VBAvyYX8GEXhHkKU8Gqk1xitrqfBXY74xKgyUSTolFSfFVgj
mcM/X4K45bka+qpkj7Kfv/8D4j6aZekwhN2ly6hhC1SmQ8qjMjpG/mrWOSSHZFmf
ybu9iD2AYHeIOkshIl6xYIa++Q/00/vs46IzAbQyriOi0XxlSMMVtPx0Q3isp+ji
n8Mq9eOuxYOEQ4of8twUkUDd528iwGtEdwf0Q01UyT84S62N8AySl1ZBKXJz6W4F
UhWfa/HQYOAPDdEjNgnVwLI23b8t0TozyCWw7q8h
-----END CERTIFICATE-----

-----BEGIN CERTIFICATE-----
MIIEjzCCA3egAwIBAgIQe55B/ALCKJDZtdNT8kD6hTANBgkqhkiG9w0BAQsFADBM
MSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMKR2xv
YmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAeFw0yMjAxMjYxMjAwMDBaFw0y
NTAxMjYwMDAwMDBaMFgxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
IG52LXNhMS4wLAYDVQQDEyVHbG9iYWxTaWduIEF0bGFzIFIzIE9WIFRMUyBDQSAy
MDIyIFEyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmGmg1LW9b7Lf
8zDD83yBDTEkt+FOxKJZqF4veWc5KZsQj9HfnUS2e5nj/E+JImlGPsQuoiosLuXD
BVBNAMcUFa11buFMGMeEMwiTmCXoXRrXQmH0qjpOfKgYc5gHG3BsRGaRrf7VR4eg
ofNMG9wUBw4/g/TT7+bQJdA4NfE7Y4d5gEryZiBGB/swaX6Jp/8MF4TgUmOWmalK
dZCKyb4sPGQFRTtElk67F7vU+wdGcrcOx1tDcIB0ncjLPMnaFicagl+daWGsKqTh
counQb6QJtYHa91KvCfKWocMxQ7OIbB5UARLPmC4CJ1/f8YFm35ebfzAeULYdGXu
jE9CLor0OwIDAQABo4IBXzCCAVswDgYDVR0PAQH/BAQDAgGGMB0GA1UdJQQWMBQG
CCsGAQUFBwMBBggrBgEFBQcDAjASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQW
BBSH5Zq7a7B/t95GfJWkDBpA8HHqdjAfBgNVHSMEGDAWgBSP8Et/qC5FJK5NUPpj
move4t0bvDB7BggrBgEFBQcBAQRvMG0wLgYIKwYBBQUHMAGGImh0dHA6Ly9vY3Nw
Mi5nbG9iYWxzaWduLmNvbS9yb290cjMwOwYIKwYBBQUHMAKGL2h0dHA6Ly9zZWN1
cmUuZ2xvYmFsc2lnbi5jb20vY2FjZXJ0L3Jvb3QtcjMuY3J0MDYGA1UdHwQvMC0w
K6ApoCeGJWh0dHA6Ly9jcmwuZ2xvYmFsc2lnbi5jb20vcm9vdC1yMy5jcmwwIQYD
VR0gBBowGDAIBgZngQwBAgIwDAYKKwYBBAGgMgoBAjANBgkqhkiG9w0BAQsFAAOC
AQEAKRic9/f+nmhQU/wz04APZLjgG5OgsuUOyUEZjKVhNGDwxGTvKhyXGGAMW2B/
3bRi+aElpXwoxu3pL6fkElbX3B0BeS5LoDtxkyiVEBMZ8m+sXbocwlPyxrPbX6mY
0rVIvnuUeBH8X0L5IwfpNVvKnBIilTbcebfHyXkPezGwz7E1yhUULjJFm2bt0SdX
y+4X/WeiiYIv+fTVgZZgl+/2MKIsu/qdBJc3f3TvJ8nz+Eax1zgZmww+RSQWeOj3
15Iw6Z5FX+NwzY/Ab+9PosR5UosSeq+9HhtaxZttXG1nVh+avYPGYddWmiMT90J5
ZgKnO/Fx2hBgTxhOTMYaD312kg==
-----END CERTIFICATE-----

-----BEGIN CERTIFICATE-----
MIIDXzCCAkegAwIBAgILBAAAAAABIVhTCKIwDQYJKoZIhvcNAQELBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwMzE4MTAwMDAwWhcNMjkwMzE4
MTAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEG
A1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAMwldpB5BngiFvXAg7aEyiie/QV2EcWtiHL8
RgJDx7KKnQRfJMsuS+FggkbhUqsMgUdwbN1k0ev1LKMPgj0MK66X17YUhhB5uzsT
gHeMCOFJ0mpiLx9e+pZo34knlTifBtc+ycsmWQ1z3rDI6SYOgxXG71uL0gRgykmm
KPZpO/bLyCiR5Z2KYVc3rHQU3HTgOu5yLy6c+9C7v/U9AOEGM+iCK65TpjoWc4zd
QQ4gOsC0p6Hpsk+QLjJg6VfLuQSSaGjlOCZgdbKfd/+RFO+uIEn8rUAVSNECMWEZ
XriX7613t2Saer9fwRPvm2L7DWzgVGkWqQPabumDk3F2xmmFghcCAwEAAaNCMEAw
DgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI/wS3+o
LkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IBAQBLQNvAUKr+yAzv95ZU
RUm7lgAJQayzE4aGKAczymvmdLm6AC2upArT9fHxD4q/c2dKg8dEe3jgr25sbwMp
jjM5RcOO5LlXbKr8EpbsU8Yt5CRsuZRj+9xTaGdWPoO4zzUhw8lo/s7awlOqzJCK
6fBdRoyV3XpYKBovHd7NADdBj+1EbddTKJd+82cEHhXXipa0095MJ6RMG3NzdvQX
mcIfeg7jLQitChws/zyrVQ4PkX4268NXSb7hLi18YIvDQVETI53O9zJrlAGomecs
Mx86OyXShkDOOyyGeMlhLxS67ttVb9+E7gUJTb0o2HLO02JQZR7rkpeDMdmztcpH
WD9f
-----END CERTIFICATE-----`;
  const TLSProfiles$1 = {
    RedisCloudFixed: { ca: RedisCloudCA },
    RedisCloudFlexible: { ca: RedisCloudCA }
  };
  TLSProfiles.default = TLSProfiles$1;
  return TLSProfiles;
}
var hasRequiredUtils;
function requireUtils() {
  if (hasRequiredUtils) return utils;
  hasRequiredUtils = 1;
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.noop = exports.defaults = exports.Debug = exports.zipMap = exports.CONNECTION_CLOSED_ERROR_MSG = exports.shuffle = exports.sample = exports.resolveTLSProfile = exports.parseURL = exports.optimizeErrorStack = exports.toArg = exports.convertMapToArray = exports.convertObjectToArray = exports.timeout = exports.packObject = exports.isInt = exports.wrapMultiResult = exports.convertBufferToString = void 0;
    const url_1 = require$$0$1;
    const lodash_1 = requireLodash();
    Object.defineProperty(exports, "defaults", { enumerable: true, get: function() {
      return lodash_1.defaults;
    } });
    Object.defineProperty(exports, "noop", { enumerable: true, get: function() {
      return lodash_1.noop;
    } });
    const debug_1 = requireDebug();
    exports.Debug = debug_1.default;
    const TLSProfiles_1 = requireTLSProfiles();
    function convertBufferToString(value, encoding) {
      if (value instanceof Buffer) {
        return value.toString(encoding);
      }
      if (Array.isArray(value)) {
        const length = value.length;
        const res = Array(length);
        for (let i = 0; i < length; ++i) {
          res[i] = value[i] instanceof Buffer && encoding === "utf8" ? value[i].toString() : convertBufferToString(value[i], encoding);
        }
        return res;
      }
      return value;
    }
    exports.convertBufferToString = convertBufferToString;
    function wrapMultiResult(arr) {
      if (!arr) {
        return null;
      }
      const result = [];
      const length = arr.length;
      for (let i = 0; i < length; ++i) {
        const item = arr[i];
        if (item instanceof Error) {
          result.push([item]);
        } else {
          result.push([null, item]);
        }
      }
      return result;
    }
    exports.wrapMultiResult = wrapMultiResult;
    function isInt(value) {
      const x = parseFloat(value);
      return !isNaN(value) && (x | 0) === x;
    }
    exports.isInt = isInt;
    function packObject(array) {
      const result = {};
      const length = array.length;
      for (let i = 1; i < length; i += 2) {
        result[array[i - 1]] = array[i];
      }
      return result;
    }
    exports.packObject = packObject;
    function timeout(callback, timeout2) {
      let timer = null;
      const run = function() {
        if (timer) {
          clearTimeout(timer);
          timer = null;
          callback.apply(this, arguments);
        }
      };
      timer = setTimeout(run, timeout2, new Error("timeout"));
      return run;
    }
    exports.timeout = timeout;
    function convertObjectToArray(obj) {
      const result = [];
      const keys2 = Object.keys(obj);
      for (let i = 0, l = keys2.length; i < l; i++) {
        result.push(keys2[i], obj[keys2[i]]);
      }
      return result;
    }
    exports.convertObjectToArray = convertObjectToArray;
    function convertMapToArray(map) {
      const result = [];
      let pos = 0;
      map.forEach(function(value, key) {
        result[pos] = key;
        result[pos + 1] = value;
        pos += 2;
      });
      return result;
    }
    exports.convertMapToArray = convertMapToArray;
    function toArg(arg) {
      if (arg === null || typeof arg === "undefined") {
        return "";
      }
      return String(arg);
    }
    exports.toArg = toArg;
    function optimizeErrorStack(error, friendlyStack, filterPath) {
      const stacks = friendlyStack.split("\n");
      let lines = "";
      let i;
      for (i = 1; i < stacks.length; ++i) {
        if (stacks[i].indexOf(filterPath) === -1) {
          break;
        }
      }
      for (let j = i; j < stacks.length; ++j) {
        lines += "\n" + stacks[j];
      }
      if (error.stack) {
        const pos = error.stack.indexOf("\n");
        error.stack = error.stack.slice(0, pos) + lines;
      }
      return error;
    }
    exports.optimizeErrorStack = optimizeErrorStack;
    function parseURL(url) {
      if (isInt(url)) {
        return { port: url };
      }
      let parsed = (0, url_1.parse)(url, true, true);
      if (!parsed.slashes && url[0] !== "/") {
        url = "//" + url;
        parsed = (0, url_1.parse)(url, true, true);
      }
      const options = parsed.query || {};
      const result = {};
      if (parsed.auth) {
        const index = parsed.auth.indexOf(":");
        result.username = index === -1 ? parsed.auth : parsed.auth.slice(0, index);
        result.password = index === -1 ? "" : parsed.auth.slice(index + 1);
      }
      if (parsed.pathname) {
        if (parsed.protocol === "redis:" || parsed.protocol === "rediss:") {
          if (parsed.pathname.length > 1) {
            result.db = parsed.pathname.slice(1);
          }
        } else {
          result.path = parsed.pathname;
        }
      }
      if (parsed.host) {
        result.host = parsed.hostname;
      }
      if (parsed.port) {
        result.port = parsed.port;
      }
      if (typeof options.family === "string") {
        const intFamily = Number.parseInt(options.family, 10);
        if (!Number.isNaN(intFamily)) {
          result.family = intFamily;
        }
      }
      (0, lodash_1.defaults)(result, options);
      return result;
    }
    exports.parseURL = parseURL;
    function resolveTLSProfile(options) {
      let tls = options === null || options === void 0 ? void 0 : options.tls;
      if (typeof tls === "string")
        tls = { profile: tls };
      const profile = TLSProfiles_1.default[tls === null || tls === void 0 ? void 0 : tls.profile];
      if (profile) {
        tls = Object.assign({}, profile, tls);
        delete tls.profile;
        options = Object.assign({}, options, { tls });
      }
      return options;
    }
    exports.resolveTLSProfile = resolveTLSProfile;
    function sample(array, from = 0) {
      const length = array.length;
      if (from >= length) {
        return null;
      }
      return array[from + Math.floor(Math.random() * (length - from))];
    }
    exports.sample = sample;
    function shuffle(array) {
      let counter = array.length;
      while (counter > 0) {
        const index = Math.floor(Math.random() * counter);
        counter--;
        [array[counter], array[index]] = [array[index], array[counter]];
      }
      return array;
    }
    exports.shuffle = shuffle;
    exports.CONNECTION_CLOSED_ERROR_MSG = "Connection is closed.";
    function zipMap(keys2, values) {
      const map = /* @__PURE__ */ new Map();
      keys2.forEach((key, index) => {
        map.set(key, values[index]);
      });
      return map;
    }
    exports.zipMap = zipMap;
  })(utils);
  return utils;
}
var hasRequiredCommand;
function requireCommand() {
  if (hasRequiredCommand) return Command;
  hasRequiredCommand = 1;
  Object.defineProperty(Command, "__esModule", { value: true });
  const commands_1 = requireBuilt$2();
  const calculateSlot = requireLib();
  const standard_as_callback_1 = requireBuilt$1();
  const utils_1 = requireUtils();
  let Command$1 = class Command2 {
    /**
     * Creates an instance of Command.
     * @param name Command name
     * @param args An array of command arguments
     * @param options
     * @param callback The callback that handles the response.
     * If omit, the response will be handled via Promise
     */
    constructor(name, args = [], options = {}, callback) {
      this.name = name;
      this.inTransaction = false;
      this.isResolved = false;
      this.transformed = false;
      this.replyEncoding = options.replyEncoding;
      this.errorStack = options.errorStack;
      this.args = args.flat();
      this.callback = callback;
      this.initPromise();
      if (options.keyPrefix) {
        const isBufferKeyPrefix = options.keyPrefix instanceof Buffer;
        let keyPrefixBuffer = isBufferKeyPrefix ? options.keyPrefix : null;
        this._iterateKeys((key) => {
          if (key instanceof Buffer) {
            if (keyPrefixBuffer === null) {
              keyPrefixBuffer = Buffer.from(options.keyPrefix);
            }
            return Buffer.concat([keyPrefixBuffer, key]);
          } else if (isBufferKeyPrefix) {
            return Buffer.concat([options.keyPrefix, Buffer.from(String(key))]);
          }
          return options.keyPrefix + key;
        });
      }
      if (options.readOnly) {
        this.isReadOnly = true;
      }
    }
    /**
     * Check whether the command has the flag
     */
    static checkFlag(flagName, commandName) {
      return !!this.getFlagMap()[flagName][commandName];
    }
    static setArgumentTransformer(name, func) {
      this._transformer.argument[name] = func;
    }
    static setReplyTransformer(name, func) {
      this._transformer.reply[name] = func;
    }
    static getFlagMap() {
      if (!this.flagMap) {
        this.flagMap = Object.keys(Command2.FLAGS).reduce((map, flagName) => {
          map[flagName] = {};
          Command2.FLAGS[flagName].forEach((commandName) => {
            map[flagName][commandName] = true;
          });
          return map;
        }, {});
      }
      return this.flagMap;
    }
    getSlot() {
      if (typeof this.slot === "undefined") {
        const key = this.getKeys()[0];
        this.slot = key == null ? null : calculateSlot(key);
      }
      return this.slot;
    }
    getKeys() {
      return this._iterateKeys();
    }
    /**
     * Convert command to writable buffer or string
     */
    toWritable(_socket) {
      let result;
      const commandStr = "*" + (this.args.length + 1) + "\r\n$" + Buffer.byteLength(this.name) + "\r\n" + this.name + "\r\n";
      if (this.bufferMode) {
        const buffers = new MixedBuffers();
        buffers.push(commandStr);
        for (let i = 0; i < this.args.length; ++i) {
          const arg = this.args[i];
          if (arg instanceof Buffer) {
            if (arg.length === 0) {
              buffers.push("$0\r\n\r\n");
            } else {
              buffers.push("$" + arg.length + "\r\n");
              buffers.push(arg);
              buffers.push("\r\n");
            }
          } else {
            buffers.push("$" + Buffer.byteLength(arg) + "\r\n" + arg + "\r\n");
          }
        }
        result = buffers.toBuffer();
      } else {
        result = commandStr;
        for (let i = 0; i < this.args.length; ++i) {
          const arg = this.args[i];
          result += "$" + Buffer.byteLength(arg) + "\r\n" + arg + "\r\n";
        }
      }
      return result;
    }
    stringifyArguments() {
      for (let i = 0; i < this.args.length; ++i) {
        const arg = this.args[i];
        if (typeof arg === "string") ;
        else if (arg instanceof Buffer) {
          this.bufferMode = true;
        } else {
          this.args[i] = (0, utils_1.toArg)(arg);
        }
      }
    }
    /**
     * Convert buffer/buffer[] to string/string[],
     * and apply reply transformer.
     */
    transformReply(result) {
      if (this.replyEncoding) {
        result = (0, utils_1.convertBufferToString)(result, this.replyEncoding);
      }
      const transformer = Command2._transformer.reply[this.name];
      if (transformer) {
        result = transformer(result);
      }
      return result;
    }
    /**
     * Set the wait time before terminating the attempt to execute a command
     * and generating an error.
     */
    setTimeout(ms2) {
      if (!this._commandTimeoutTimer) {
        this._commandTimeoutTimer = setTimeout(() => {
          if (!this.isResolved) {
            this.reject(new Error("Command timed out"));
          }
        }, ms2);
      }
    }
    initPromise() {
      const promise = new Promise((resolve, reject) => {
        if (!this.transformed) {
          this.transformed = true;
          const transformer = Command2._transformer.argument[this.name];
          if (transformer) {
            this.args = transformer(this.args);
          }
          this.stringifyArguments();
        }
        this.resolve = this._convertValue(resolve);
        if (this.errorStack) {
          this.reject = (err) => {
            reject((0, utils_1.optimizeErrorStack)(err, this.errorStack.stack, __dirname));
          };
        } else {
          this.reject = reject;
        }
      });
      this.promise = (0, standard_as_callback_1.default)(promise, this.callback);
    }
    /**
     * Iterate through the command arguments that are considered keys.
     */
    _iterateKeys(transform = (key) => key) {
      if (typeof this.keys === "undefined") {
        this.keys = [];
        if ((0, commands_1.exists)(this.name)) {
          const keyIndexes = (0, commands_1.getKeyIndexes)(this.name, this.args);
          for (const index of keyIndexes) {
            this.args[index] = transform(this.args[index]);
            this.keys.push(this.args[index]);
          }
        }
      }
      return this.keys;
    }
    /**
     * Convert the value from buffer to the target encoding.
     */
    _convertValue(resolve) {
      return (value) => {
        try {
          const existingTimer = this._commandTimeoutTimer;
          if (existingTimer) {
            clearTimeout(existingTimer);
            delete this._commandTimeoutTimer;
          }
          resolve(this.transformReply(value));
          this.isResolved = true;
        } catch (err) {
          this.reject(err);
        }
        return this.promise;
      };
    }
  };
  Command.default = Command$1;
  Command$1.FLAGS = {
    VALID_IN_SUBSCRIBER_MODE: [
      "subscribe",
      "psubscribe",
      "unsubscribe",
      "punsubscribe",
      "ssubscribe",
      "sunsubscribe",
      "ping",
      "quit"
    ],
    VALID_IN_MONITOR_MODE: ["monitor", "auth"],
    ENTER_SUBSCRIBER_MODE: ["subscribe", "psubscribe", "ssubscribe"],
    EXIT_SUBSCRIBER_MODE: ["unsubscribe", "punsubscribe", "sunsubscribe"],
    WILL_DISCONNECT: ["quit"]
  };
  Command$1._transformer = {
    argument: {},
    reply: {}
  };
  const msetArgumentTransformer = function(args) {
    if (args.length === 1) {
      if (args[0] instanceof Map) {
        return (0, utils_1.convertMapToArray)(args[0]);
      }
      if (typeof args[0] === "object" && args[0] !== null) {
        return (0, utils_1.convertObjectToArray)(args[0]);
      }
    }
    return args;
  };
  const hsetArgumentTransformer = function(args) {
    if (args.length === 2) {
      if (args[1] instanceof Map) {
        return [args[0]].concat((0, utils_1.convertMapToArray)(args[1]));
      }
      if (typeof args[1] === "object" && args[1] !== null) {
        return [args[0]].concat((0, utils_1.convertObjectToArray)(args[1]));
      }
    }
    return args;
  };
  Command$1.setArgumentTransformer("mset", msetArgumentTransformer);
  Command$1.setArgumentTransformer("msetnx", msetArgumentTransformer);
  Command$1.setArgumentTransformer("hset", hsetArgumentTransformer);
  Command$1.setArgumentTransformer("hmset", hsetArgumentTransformer);
  Command$1.setReplyTransformer("hgetall", function(result) {
    if (Array.isArray(result)) {
      const obj = {};
      for (let i = 0; i < result.length; i += 2) {
        const key = result[i];
        const value = result[i + 1];
        if (key in obj) {
          Object.defineProperty(obj, key, {
            value,
            configurable: true,
            enumerable: true,
            writable: true
          });
        } else {
          obj[key] = value;
        }
      }
      return obj;
    }
    return result;
  });
  class MixedBuffers {
    constructor() {
      this.length = 0;
      this.items = [];
    }
    push(x) {
      this.length += Buffer.byteLength(x);
      this.items.push(x);
    }
    toBuffer() {
      const result = Buffer.allocUnsafe(this.length);
      let offset = 0;
      for (const item of this.items) {
        const length = Buffer.byteLength(item);
        Buffer.isBuffer(item) ? item.copy(result, offset) : result.write(item, offset, length);
        offset += length;
      }
      return result;
    }
  }
  return Command;
}
var ClusterAllFailedError = {};
var hasRequiredClusterAllFailedError;
function requireClusterAllFailedError() {
  if (hasRequiredClusterAllFailedError) return ClusterAllFailedError;
  hasRequiredClusterAllFailedError = 1;
  Object.defineProperty(ClusterAllFailedError, "__esModule", { value: true });
  const redis_errors_1 = requireRedisErrors();
  let ClusterAllFailedError$1 = class ClusterAllFailedError extends redis_errors_1.RedisError {
    constructor(message, lastNodeError) {
      super(message);
      this.lastNodeError = lastNodeError;
      Error.captureStackTrace(this, this.constructor);
    }
    get name() {
      return this.constructor.name;
    }
  };
  ClusterAllFailedError.default = ClusterAllFailedError$1;
  ClusterAllFailedError$1.defaultMessage = "Failed to refresh slots cache.";
  return ClusterAllFailedError;
}
var ScanStream = {};
var hasRequiredScanStream;
function requireScanStream() {
  if (hasRequiredScanStream) return ScanStream;
  hasRequiredScanStream = 1;
  Object.defineProperty(ScanStream, "__esModule", { value: true });
  const stream_1 = require$$0$2;
  let ScanStream$1 = class ScanStream extends stream_1.Readable {
    constructor(opt) {
      super(opt);
      this.opt = opt;
      this._redisCursor = "0";
      this._redisDrained = false;
    }
    _read() {
      if (this._redisDrained) {
        this.push(null);
        return;
      }
      const args = [this._redisCursor];
      if (this.opt.key) {
        args.unshift(this.opt.key);
      }
      if (this.opt.match) {
        args.push("MATCH", this.opt.match);
      }
      if (this.opt.type) {
        args.push("TYPE", this.opt.type);
      }
      if (this.opt.count) {
        args.push("COUNT", String(this.opt.count));
      }
      if (this.opt.noValues) {
        args.push("NOVALUES");
      }
      this.opt.redis[this.opt.command](args, (err, res) => {
        if (err) {
          this.emit("error", err);
          return;
        }
        this._redisCursor = res[0] instanceof Buffer ? res[0].toString() : res[0];
        if (this._redisCursor === "0") {
          this._redisDrained = true;
        }
        this.push(res[1]);
      });
    }
    close() {
      this._redisDrained = true;
    }
  };
  ScanStream.default = ScanStream$1;
  return ScanStream;
}
var transaction = {};
var Pipeline = {};
var Commander = {};
var autoPipelining = {};
var hasRequiredAutoPipelining;
function requireAutoPipelining() {
  if (hasRequiredAutoPipelining) return autoPipelining;
  hasRequiredAutoPipelining = 1;
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.executeWithAutoPipelining = exports.getFirstValueInFlattenedArray = exports.shouldUseAutoPipelining = exports.notAllowedAutoPipelineCommands = exports.kCallbacks = exports.kExec = void 0;
    const lodash_1 = requireLodash();
    const calculateSlot = requireLib();
    const standard_as_callback_1 = requireBuilt$1();
    exports.kExec = Symbol("exec");
    exports.kCallbacks = Symbol("callbacks");
    exports.notAllowedAutoPipelineCommands = [
      "auth",
      "info",
      "script",
      "quit",
      "cluster",
      "pipeline",
      "multi",
      "subscribe",
      "psubscribe",
      "unsubscribe",
      "unpsubscribe",
      "select"
    ];
    function executeAutoPipeline(client2, slotKey) {
      if (client2._runningAutoPipelines.has(slotKey)) {
        return;
      }
      if (!client2._autoPipelines.has(slotKey)) {
        return;
      }
      client2._runningAutoPipelines.add(slotKey);
      const pipeline = client2._autoPipelines.get(slotKey);
      client2._autoPipelines.delete(slotKey);
      const callbacks = pipeline[exports.kCallbacks];
      pipeline[exports.kCallbacks] = null;
      pipeline.exec(function(err, results) {
        client2._runningAutoPipelines.delete(slotKey);
        if (err) {
          for (let i = 0; i < callbacks.length; i++) {
            process.nextTick(callbacks[i], err);
          }
        } else {
          for (let i = 0; i < callbacks.length; i++) {
            process.nextTick(callbacks[i], ...results[i]);
          }
        }
        if (client2._autoPipelines.has(slotKey)) {
          executeAutoPipeline(client2, slotKey);
        }
      });
    }
    function shouldUseAutoPipelining(client2, functionName, commandName) {
      return functionName && client2.options.enableAutoPipelining && !client2.isPipeline && !exports.notAllowedAutoPipelineCommands.includes(commandName) && !client2.options.autoPipeliningIgnoredCommands.includes(commandName);
    }
    exports.shouldUseAutoPipelining = shouldUseAutoPipelining;
    function getFirstValueInFlattenedArray(args) {
      for (let i = 0; i < args.length; i++) {
        const arg = args[i];
        if (typeof arg === "string") {
          return arg;
        } else if (Array.isArray(arg) || (0, lodash_1.isArguments)(arg)) {
          if (arg.length === 0) {
            continue;
          }
          return arg[0];
        }
        const flattened = [arg].flat();
        if (flattened.length > 0) {
          return flattened[0];
        }
      }
      return void 0;
    }
    exports.getFirstValueInFlattenedArray = getFirstValueInFlattenedArray;
    function executeWithAutoPipelining(client2, functionName, commandName, args, callback) {
      if (client2.isCluster && !client2.slots.length) {
        if (client2.status === "wait")
          client2.connect().catch(lodash_1.noop);
        return (0, standard_as_callback_1.default)(new Promise(function(resolve, reject) {
          client2.delayUntilReady((err) => {
            if (err) {
              reject(err);
              return;
            }
            executeWithAutoPipelining(client2, functionName, commandName, args, null).then(resolve, reject);
          });
        }), callback);
      }
      const prefix = client2.options.keyPrefix || "";
      const slotKey = client2.isCluster ? client2.slots[calculateSlot(`${prefix}${getFirstValueInFlattenedArray(args)}`)].join(",") : "main";
      if (!client2._autoPipelines.has(slotKey)) {
        const pipeline2 = client2.pipeline();
        pipeline2[exports.kExec] = false;
        pipeline2[exports.kCallbacks] = [];
        client2._autoPipelines.set(slotKey, pipeline2);
      }
      const pipeline = client2._autoPipelines.get(slotKey);
      if (!pipeline[exports.kExec]) {
        pipeline[exports.kExec] = true;
        setImmediate(executeAutoPipeline, client2, slotKey);
      }
      const autoPipelinePromise = new Promise(function(resolve, reject) {
        pipeline[exports.kCallbacks].push(function(err, value) {
          if (err) {
            reject(err);
            return;
          }
          resolve(value);
        });
        if (functionName === "call") {
          args.unshift(commandName);
        }
        pipeline[functionName](...args);
      });
      return (0, standard_as_callback_1.default)(autoPipelinePromise, callback);
    }
    exports.executeWithAutoPipelining = executeWithAutoPipelining;
  })(autoPipelining);
  return autoPipelining;
}
var Script = {};
var hasRequiredScript;
function requireScript() {
  if (hasRequiredScript) return Script;
  hasRequiredScript = 1;
  Object.defineProperty(Script, "__esModule", { value: true });
  const crypto_1 = require$$0$3;
  const Command_1 = requireCommand();
  const standard_as_callback_1 = requireBuilt$1();
  let Script$1 = class Script {
    constructor(lua, numberOfKeys = null, keyPrefix = "", readOnly = false) {
      this.lua = lua;
      this.numberOfKeys = numberOfKeys;
      this.keyPrefix = keyPrefix;
      this.readOnly = readOnly;
      this.sha = (0, crypto_1.createHash)("sha1").update(lua).digest("hex");
      const sha = this.sha;
      const socketHasScriptLoaded = /* @__PURE__ */ new WeakSet();
      this.Command = class CustomScriptCommand extends Command_1.default {
        toWritable(socket) {
          const origReject = this.reject;
          this.reject = (err) => {
            if (err.message.indexOf("NOSCRIPT") !== -1) {
              socketHasScriptLoaded.delete(socket);
            }
            origReject.call(this, err);
          };
          if (!socketHasScriptLoaded.has(socket)) {
            socketHasScriptLoaded.add(socket);
            this.name = "eval";
            this.args[0] = lua;
          } else if (this.name === "eval") {
            this.name = "evalsha";
            this.args[0] = sha;
          }
          return super.toWritable(socket);
        }
      };
    }
    execute(container, args, options, callback) {
      if (typeof this.numberOfKeys === "number") {
        args.unshift(this.numberOfKeys);
      }
      if (this.keyPrefix) {
        options.keyPrefix = this.keyPrefix;
      }
      if (this.readOnly) {
        options.readOnly = true;
      }
      const evalsha2 = new this.Command("evalsha", [this.sha, ...args], options);
      evalsha2.promise = evalsha2.promise.catch((err) => {
        if (err.message.indexOf("NOSCRIPT") === -1) {
          throw err;
        }
        const resend = new this.Command("evalsha", [this.sha, ...args], options);
        const client2 = container.isPipeline ? container.redis : container;
        return client2.sendCommand(resend);
      });
      (0, standard_as_callback_1.default)(evalsha2.promise, callback);
      return container.sendCommand(evalsha2);
    }
  };
  Script.default = Script$1;
  return Script;
}
var hasRequiredCommander;
function requireCommander() {
  if (hasRequiredCommander) return Commander;
  hasRequiredCommander = 1;
  Object.defineProperty(Commander, "__esModule", { value: true });
  const commands_1 = requireBuilt$2();
  const autoPipelining_1 = requireAutoPipelining();
  const Command_1 = requireCommand();
  const Script_1 = requireScript();
  let Commander$1 = class Commander {
    constructor() {
      this.options = {};
      this.scriptsSet = {};
      this.addedBuiltinSet = /* @__PURE__ */ new Set();
    }
    /**
     * Return supported builtin commands
     */
    getBuiltinCommands() {
      return commands.slice(0);
    }
    /**
     * Create a builtin command
     */
    createBuiltinCommand(commandName) {
      return {
        string: generateFunction(null, commandName, "utf8"),
        buffer: generateFunction(null, commandName, null)
      };
    }
    /**
     * Create add builtin command
     */
    addBuiltinCommand(commandName) {
      this.addedBuiltinSet.add(commandName);
      this[commandName] = generateFunction(commandName, commandName, "utf8");
      this[commandName + "Buffer"] = generateFunction(commandName + "Buffer", commandName, null);
    }
    /**
     * Define a custom command using lua script
     */
    defineCommand(name, definition) {
      const script2 = new Script_1.default(definition.lua, definition.numberOfKeys, this.options.keyPrefix, definition.readOnly);
      this.scriptsSet[name] = script2;
      this[name] = generateScriptingFunction(name, name, script2, "utf8");
      this[name + "Buffer"] = generateScriptingFunction(name + "Buffer", name, script2, null);
    }
    /**
     * @ignore
     */
    sendCommand(command2, stream, node2) {
      throw new Error('"sendCommand" is not implemented');
    }
  };
  const commands = commands_1.list.filter((command2) => command2 !== "monitor");
  commands.push("sentinel");
  commands.forEach(function(commandName) {
    Commander$1.prototype[commandName] = generateFunction(commandName, commandName, "utf8");
    Commander$1.prototype[commandName + "Buffer"] = generateFunction(commandName + "Buffer", commandName, null);
  });
  Commander$1.prototype.call = generateFunction("call", "utf8");
  Commander$1.prototype.callBuffer = generateFunction("callBuffer", null);
  Commander$1.prototype.send_command = Commander$1.prototype.call;
  function generateFunction(functionName, _commandName, _encoding) {
    if (typeof _encoding === "undefined") {
      _encoding = _commandName;
      _commandName = null;
    }
    return function(...args) {
      const commandName = _commandName || args.shift();
      let callback = args[args.length - 1];
      if (typeof callback === "function") {
        args.pop();
      } else {
        callback = void 0;
      }
      const options = {
        errorStack: this.options.showFriendlyErrorStack ? new Error() : void 0,
        keyPrefix: this.options.keyPrefix,
        replyEncoding: _encoding
      };
      if (!(0, autoPipelining_1.shouldUseAutoPipelining)(this, functionName, commandName)) {
        return this.sendCommand(
          // @ts-expect-error
          new Command_1.default(commandName, args, options, callback)
        );
      }
      return (0, autoPipelining_1.executeWithAutoPipelining)(
        this,
        functionName,
        commandName,
        // @ts-expect-error
        args,
        callback
      );
    };
  }
  function generateScriptingFunction(functionName, commandName, script2, encoding) {
    return function(...args) {
      const callback = typeof args[args.length - 1] === "function" ? args.pop() : void 0;
      const options = {
        replyEncoding: encoding
      };
      if (this.options.showFriendlyErrorStack) {
        options.errorStack = new Error();
      }
      if (!(0, autoPipelining_1.shouldUseAutoPipelining)(this, functionName, commandName)) {
        return script2.execute(this, args, options, callback);
      }
      return (0, autoPipelining_1.executeWithAutoPipelining)(this, functionName, commandName, args, callback);
    };
  }
  Commander.default = Commander$1;
  return Commander;
}
var hasRequiredPipeline;
function requirePipeline() {
  if (hasRequiredPipeline) return Pipeline;
  hasRequiredPipeline = 1;
  Object.defineProperty(Pipeline, "__esModule", { value: true });
  const calculateSlot = requireLib();
  const commands_1 = requireBuilt$2();
  const standard_as_callback_1 = requireBuilt$1();
  const util_1 = require$$1;
  const Command_1 = requireCommand();
  const utils_1 = requireUtils();
  const Commander_1 = requireCommander();
  function generateMultiWithNodes(redis, keys2) {
    const slot = calculateSlot(keys2[0]);
    const target = redis._groupsBySlot[slot];
    for (let i = 1; i < keys2.length; i++) {
      if (redis._groupsBySlot[calculateSlot(keys2[i])] !== target) {
        return -1;
      }
    }
    return slot;
  }
  let Pipeline$1 = class Pipeline extends Commander_1.default {
    constructor(redis) {
      super();
      this.redis = redis;
      this.isPipeline = true;
      this.replyPending = 0;
      this._queue = [];
      this._result = [];
      this._transactions = 0;
      this._shaToScript = {};
      this.isCluster = this.redis.constructor.name === "Cluster" || this.redis.isCluster;
      this.options = redis.options;
      Object.keys(redis.scriptsSet).forEach((name) => {
        const script2 = redis.scriptsSet[name];
        this._shaToScript[script2.sha] = script2;
        this[name] = redis[name];
        this[name + "Buffer"] = redis[name + "Buffer"];
      });
      redis.addedBuiltinSet.forEach((name) => {
        this[name] = redis[name];
        this[name + "Buffer"] = redis[name + "Buffer"];
      });
      this.promise = new Promise((resolve, reject) => {
        this.resolve = resolve;
        this.reject = reject;
      });
      const _this = this;
      Object.defineProperty(this, "length", {
        get: function() {
          return _this._queue.length;
        }
      });
    }
    fillResult(value, position) {
      if (this._queue[position].name === "exec" && Array.isArray(value[1])) {
        const execLength = value[1].length;
        for (let i = 0; i < execLength; i++) {
          if (value[1][i] instanceof Error) {
            continue;
          }
          const cmd = this._queue[position - (execLength - i)];
          try {
            value[1][i] = cmd.transformReply(value[1][i]);
          } catch (err) {
            value[1][i] = err;
          }
        }
      }
      this._result[position] = value;
      if (--this.replyPending) {
        return;
      }
      if (this.isCluster) {
        let retriable = true;
        let commonError;
        for (let i = 0; i < this._result.length; ++i) {
          const error = this._result[i][0];
          const command2 = this._queue[i];
          if (error) {
            if (command2.name === "exec" && error.message === "EXECABORT Transaction discarded because of previous errors.") {
              continue;
            }
            if (!commonError) {
              commonError = {
                name: error.name,
                message: error.message
              };
            } else if (commonError.name !== error.name || commonError.message !== error.message) {
              retriable = false;
              break;
            }
          } else if (!command2.inTransaction) {
            const isReadOnly = (0, commands_1.exists)(command2.name) && (0, commands_1.hasFlag)(command2.name, "readonly");
            if (!isReadOnly) {
              retriable = false;
              break;
            }
          }
        }
        if (commonError && retriable) {
          const _this = this;
          const errv = commonError.message.split(" ");
          const queue = this._queue;
          let inTransaction = false;
          this._queue = [];
          for (let i = 0; i < queue.length; ++i) {
            if (errv[0] === "ASK" && !inTransaction && queue[i].name !== "asking" && (!queue[i - 1] || queue[i - 1].name !== "asking")) {
              const asking2 = new Command_1.default("asking");
              asking2.ignore = true;
              this.sendCommand(asking2);
            }
            queue[i].initPromise();
            this.sendCommand(queue[i]);
            inTransaction = queue[i].inTransaction;
          }
          let matched = true;
          if (typeof this.leftRedirections === "undefined") {
            this.leftRedirections = {};
          }
          const exec2 = function() {
            _this.exec();
          };
          const cluster2 = this.redis;
          cluster2.handleError(commonError, this.leftRedirections, {
            moved: function(_slot, key) {
              _this.preferKey = key;
              cluster2.slots[errv[1]] = [key];
              cluster2._groupsBySlot[errv[1]] = cluster2._groupsIds[cluster2.slots[errv[1]].join(";")];
              cluster2.refreshSlotsCache();
              _this.exec();
            },
            ask: function(_slot, key) {
              _this.preferKey = key;
              _this.exec();
            },
            tryagain: exec2,
            clusterDown: exec2,
            connectionClosed: exec2,
            maxRedirections: () => {
              matched = false;
            },
            defaults: () => {
              matched = false;
            }
          });
          if (matched) {
            return;
          }
        }
      }
      let ignoredCount = 0;
      for (let i = 0; i < this._queue.length - ignoredCount; ++i) {
        if (this._queue[i + ignoredCount].ignore) {
          ignoredCount += 1;
        }
        this._result[i] = this._result[i + ignoredCount];
      }
      this.resolve(this._result.slice(0, this._result.length - ignoredCount));
    }
    sendCommand(command2) {
      if (this._transactions > 0) {
        command2.inTransaction = true;
      }
      const position = this._queue.length;
      command2.pipelineIndex = position;
      command2.promise.then((result) => {
        this.fillResult([null, result], position);
      }).catch((error) => {
        this.fillResult([error], position);
      });
      this._queue.push(command2);
      return this;
    }
    addBatch(commands) {
      let command2, commandName, args;
      for (let i = 0; i < commands.length; ++i) {
        command2 = commands[i];
        commandName = command2[0];
        args = command2.slice(1);
        this[commandName].apply(this, args);
      }
      return this;
    }
  };
  Pipeline.default = Pipeline$1;
  const multi2 = Pipeline$1.prototype.multi;
  Pipeline$1.prototype.multi = function() {
    this._transactions += 1;
    return multi2.apply(this, arguments);
  };
  const execBuffer = Pipeline$1.prototype.execBuffer;
  Pipeline$1.prototype.execBuffer = (0, util_1.deprecate)(function() {
    if (this._transactions > 0) {
      this._transactions -= 1;
    }
    return execBuffer.apply(this, arguments);
  }, "Pipeline#execBuffer: Use Pipeline#exec instead");
  Pipeline$1.prototype.exec = function(callback) {
    if (this.isCluster && !this.redis.slots.length) {
      if (this.redis.status === "wait")
        this.redis.connect().catch(utils_1.noop);
      if (callback && !this.nodeifiedPromise) {
        this.nodeifiedPromise = true;
        (0, standard_as_callback_1.default)(this.promise, callback);
      }
      this.redis.delayUntilReady((err) => {
        if (err) {
          this.reject(err);
          return;
        }
        this.exec(callback);
      });
      return this.promise;
    }
    if (this._transactions > 0) {
      this._transactions -= 1;
      return execBuffer.apply(this, arguments);
    }
    if (!this.nodeifiedPromise) {
      this.nodeifiedPromise = true;
      (0, standard_as_callback_1.default)(this.promise, callback);
    }
    if (!this._queue.length) {
      this.resolve([]);
    }
    let pipelineSlot;
    if (this.isCluster) {
      const sampleKeys = [];
      for (let i = 0; i < this._queue.length; i++) {
        const keys2 = this._queue[i].getKeys();
        if (keys2.length) {
          sampleKeys.push(keys2[0]);
        }
        if (keys2.length && calculateSlot.generateMulti(keys2) < 0) {
          this.reject(new Error("All the keys in a pipeline command should belong to the same slot"));
          return this.promise;
        }
      }
      if (sampleKeys.length) {
        pipelineSlot = generateMultiWithNodes(this.redis, sampleKeys);
        if (pipelineSlot < 0) {
          this.reject(new Error("All keys in the pipeline should belong to the same slots allocation group"));
          return this.promise;
        }
      } else {
        pipelineSlot = Math.random() * 16384 | 0;
      }
    }
    const _this = this;
    execPipeline();
    return this.promise;
    function execPipeline() {
      let writePending = _this.replyPending = _this._queue.length;
      let node2;
      if (_this.isCluster) {
        node2 = {
          slot: pipelineSlot,
          redis: _this.redis.connectionPool.nodes.all[_this.preferKey]
        };
      }
      let data = "";
      let buffers;
      const stream = {
        isPipeline: true,
        destination: _this.isCluster ? node2 : { redis: _this.redis },
        write(writable) {
          if (typeof writable !== "string") {
            if (!buffers) {
              buffers = [];
            }
            if (data) {
              buffers.push(Buffer.from(data, "utf8"));
              data = "";
            }
            buffers.push(writable);
          } else {
            data += writable;
          }
          if (!--writePending) {
            if (buffers) {
              if (data) {
                buffers.push(Buffer.from(data, "utf8"));
              }
              stream.destination.redis.stream.write(Buffer.concat(buffers));
            } else {
              stream.destination.redis.stream.write(data);
            }
            writePending = _this._queue.length;
            data = "";
            buffers = void 0;
          }
        }
      };
      for (let i = 0; i < _this._queue.length; ++i) {
        _this.redis.sendCommand(_this._queue[i], stream, node2);
      }
      return _this.promise;
    }
  };
  return Pipeline;
}
var hasRequiredTransaction;
function requireTransaction() {
  if (hasRequiredTransaction) return transaction;
  hasRequiredTransaction = 1;
  Object.defineProperty(transaction, "__esModule", { value: true });
  transaction.addTransactionSupport = void 0;
  const utils_1 = requireUtils();
  const standard_as_callback_1 = requireBuilt$1();
  const Pipeline_1 = requirePipeline();
  function addTransactionSupport(redis) {
    redis.pipeline = function(commands) {
      const pipeline = new Pipeline_1.default(this);
      if (Array.isArray(commands)) {
        pipeline.addBatch(commands);
      }
      return pipeline;
    };
    const { multi: multi2 } = redis;
    redis.multi = function(commands, options) {
      if (typeof options === "undefined" && !Array.isArray(commands)) {
        options = commands;
        commands = null;
      }
      if (options && options.pipeline === false) {
        return multi2.call(this);
      }
      const pipeline = new Pipeline_1.default(this);
      pipeline.multi();
      if (Array.isArray(commands)) {
        pipeline.addBatch(commands);
      }
      const exec3 = pipeline.exec;
      pipeline.exec = function(callback) {
        if (this.isCluster && !this.redis.slots.length) {
          if (this.redis.status === "wait")
            this.redis.connect().catch(utils_1.noop);
          return (0, standard_as_callback_1.default)(new Promise((resolve, reject) => {
            this.redis.delayUntilReady((err) => {
              if (err) {
                reject(err);
                return;
              }
              this.exec(pipeline).then(resolve, reject);
            });
          }), callback);
        }
        if (this._transactions > 0) {
          exec3.call(pipeline);
        }
        if (this.nodeifiedPromise) {
          return exec3.call(pipeline);
        }
        const promise = exec3.call(pipeline);
        return (0, standard_as_callback_1.default)(promise.then(function(result) {
          const execResult = result[result.length - 1];
          if (typeof execResult === "undefined") {
            throw new Error("Pipeline cannot be used to send any commands when the `exec()` has been called on it.");
          }
          if (execResult[0]) {
            execResult[0].previousErrors = [];
            for (let i = 0; i < result.length - 1; ++i) {
              if (result[i][0]) {
                execResult[0].previousErrors.push(result[i][0]);
              }
            }
            throw execResult[0];
          }
          return (0, utils_1.wrapMultiResult)(execResult[1]);
        }), callback);
      };
      const { execBuffer } = pipeline;
      pipeline.execBuffer = function(callback) {
        if (this._transactions > 0) {
          execBuffer.call(pipeline);
        }
        return pipeline.exec(callback);
      };
      return pipeline;
    };
    const { exec: exec2 } = redis;
    redis.exec = function(callback) {
      return (0, standard_as_callback_1.default)(exec2.call(this).then(function(results) {
        if (Array.isArray(results)) {
          results = (0, utils_1.wrapMultiResult)(results);
        }
        return results;
      }), callback);
    };
  }
  transaction.addTransactionSupport = addTransactionSupport;
  return transaction;
}
var applyMixin = {};
var hasRequiredApplyMixin;
function requireApplyMixin() {
  if (hasRequiredApplyMixin) return applyMixin;
  hasRequiredApplyMixin = 1;
  Object.defineProperty(applyMixin, "__esModule", { value: true });
  function applyMixin$1(derivedConstructor, mixinConstructor) {
    Object.getOwnPropertyNames(mixinConstructor.prototype).forEach((name) => {
      Object.defineProperty(derivedConstructor.prototype, name, Object.getOwnPropertyDescriptor(mixinConstructor.prototype, name));
    });
  }
  applyMixin.default = applyMixin$1;
  return applyMixin;
}
var ClusterOptions = {};
var hasRequiredClusterOptions;
function requireClusterOptions() {
  if (hasRequiredClusterOptions) return ClusterOptions;
  hasRequiredClusterOptions = 1;
  Object.defineProperty(ClusterOptions, "__esModule", { value: true });
  ClusterOptions.DEFAULT_CLUSTER_OPTIONS = void 0;
  const dns_1 = require$$0$4;
  ClusterOptions.DEFAULT_CLUSTER_OPTIONS = {
    clusterRetryStrategy: (times) => Math.min(100 + times * 2, 2e3),
    enableOfflineQueue: true,
    enableReadyCheck: true,
    scaleReads: "master",
    maxRedirections: 16,
    retryDelayOnMoved: 0,
    retryDelayOnFailover: 100,
    retryDelayOnClusterDown: 100,
    retryDelayOnTryAgain: 100,
    slotsRefreshTimeout: 1e3,
    useSRVRecords: false,
    resolveSrv: dns_1.resolveSrv,
    dnsLookup: dns_1.lookup,
    enableAutoPipelining: false,
    autoPipeliningIgnoredCommands: [],
    shardedSubscribers: false
  };
  return ClusterOptions;
}
var ClusterSubscriber = {};
var util = {};
var hasRequiredUtil;
function requireUtil() {
  if (hasRequiredUtil) return util;
  hasRequiredUtil = 1;
  Object.defineProperty(util, "__esModule", { value: true });
  util.getConnectionName = util.weightSrvRecords = util.groupSrvRecords = util.getUniqueHostnamesFromOptions = util.normalizeNodeOptions = util.nodeKeyToRedisOptions = util.getNodeKey = void 0;
  const utils_1 = requireUtils();
  const net_1 = require$$0$5;
  function getNodeKey(node2) {
    node2.port = node2.port || 6379;
    node2.host = node2.host || "127.0.0.1";
    return node2.host + ":" + node2.port;
  }
  util.getNodeKey = getNodeKey;
  function nodeKeyToRedisOptions(nodeKey) {
    const portIndex = nodeKey.lastIndexOf(":");
    if (portIndex === -1) {
      throw new Error(`Invalid node key ${nodeKey}`);
    }
    return {
      host: nodeKey.slice(0, portIndex),
      port: Number(nodeKey.slice(portIndex + 1))
    };
  }
  util.nodeKeyToRedisOptions = nodeKeyToRedisOptions;
  function normalizeNodeOptions(nodes) {
    return nodes.map((node2) => {
      const options = {};
      if (typeof node2 === "object") {
        Object.assign(options, node2);
      } else if (typeof node2 === "string") {
        Object.assign(options, (0, utils_1.parseURL)(node2));
      } else if (typeof node2 === "number") {
        options.port = node2;
      } else {
        throw new Error("Invalid argument " + node2);
      }
      if (typeof options.port === "string") {
        options.port = parseInt(options.port, 10);
      }
      delete options.db;
      if (!options.port) {
        options.port = 6379;
      }
      if (!options.host) {
        options.host = "127.0.0.1";
      }
      return (0, utils_1.resolveTLSProfile)(options);
    });
  }
  util.normalizeNodeOptions = normalizeNodeOptions;
  function getUniqueHostnamesFromOptions(nodes) {
    const uniqueHostsMap = {};
    nodes.forEach((node2) => {
      uniqueHostsMap[node2.host] = true;
    });
    return Object.keys(uniqueHostsMap).filter((host) => !(0, net_1.isIP)(host));
  }
  util.getUniqueHostnamesFromOptions = getUniqueHostnamesFromOptions;
  function groupSrvRecords(records) {
    const recordsByPriority = {};
    for (const record of records) {
      if (!recordsByPriority.hasOwnProperty(record.priority)) {
        recordsByPriority[record.priority] = {
          totalWeight: record.weight,
          records: [record]
        };
      } else {
        recordsByPriority[record.priority].totalWeight += record.weight;
        recordsByPriority[record.priority].records.push(record);
      }
    }
    return recordsByPriority;
  }
  util.groupSrvRecords = groupSrvRecords;
  function weightSrvRecords(recordsGroup) {
    if (recordsGroup.records.length === 1) {
      recordsGroup.totalWeight = 0;
      return recordsGroup.records.shift();
    }
    const random = Math.floor(Math.random() * (recordsGroup.totalWeight + recordsGroup.records.length));
    let total = 0;
    for (const [i, record] of recordsGroup.records.entries()) {
      total += 1 + record.weight;
      if (total > random) {
        recordsGroup.totalWeight -= record.weight;
        recordsGroup.records.splice(i, 1);
        return record;
      }
    }
  }
  util.weightSrvRecords = weightSrvRecords;
  function getConnectionName(component, nodeConnectionName) {
    const prefix = `ioredis-cluster(${component})`;
    return nodeConnectionName ? `${prefix}:${nodeConnectionName}` : prefix;
  }
  util.getConnectionName = getConnectionName;
  return util;
}
var hasRequiredClusterSubscriber;
function requireClusterSubscriber() {
  if (hasRequiredClusterSubscriber) return ClusterSubscriber;
  hasRequiredClusterSubscriber = 1;
  Object.defineProperty(ClusterSubscriber, "__esModule", { value: true });
  const util_1 = requireUtil();
  const utils_1 = requireUtils();
  const Redis_1 = requireRedis();
  const debug2 = (0, utils_1.Debug)("cluster:subscriber");
  let ClusterSubscriber$1 = class ClusterSubscriber {
    constructor(connectionPool, emitter, isSharded = false) {
      this.connectionPool = connectionPool;
      this.emitter = emitter;
      this.isSharded = isSharded;
      this.started = false;
      this.subscriber = null;
      this.slotRange = [];
      this.onSubscriberEnd = () => {
        if (!this.started) {
          debug2("subscriber has disconnected, but ClusterSubscriber is not started, so not reconnecting.");
          return;
        }
        debug2("subscriber has disconnected, selecting a new one...");
        this.selectSubscriber();
      };
      this.connectionPool.on("-node", (_, key) => {
        if (!this.started || !this.subscriber) {
          return;
        }
        if ((0, util_1.getNodeKey)(this.subscriber.options) === key) {
          debug2("subscriber has left, selecting a new one...");
          this.selectSubscriber();
        }
      });
      this.connectionPool.on("+node", () => {
        if (!this.started || this.subscriber) {
          return;
        }
        debug2("a new node is discovered and there is no subscriber, selecting a new one...");
        this.selectSubscriber();
      });
    }
    getInstance() {
      return this.subscriber;
    }
    /**
     * Associate this subscriber to a specific slot range.
     *
     * Returns the range or an empty array if the slot range couldn't be associated.
     *
     * BTW: This is more for debugging and testing purposes.
     *
     * @param range
     */
    associateSlotRange(range) {
      if (this.isSharded) {
        this.slotRange = range;
      }
      return this.slotRange;
    }
    start() {
      this.started = true;
      this.selectSubscriber();
      debug2("started");
    }
    stop() {
      this.started = false;
      if (this.subscriber) {
        this.subscriber.disconnect();
        this.subscriber = null;
      }
    }
    isStarted() {
      return this.started;
    }
    selectSubscriber() {
      const lastActiveSubscriber = this.lastActiveSubscriber;
      if (lastActiveSubscriber) {
        lastActiveSubscriber.off("end", this.onSubscriberEnd);
        lastActiveSubscriber.disconnect();
      }
      if (this.subscriber) {
        this.subscriber.off("end", this.onSubscriberEnd);
        this.subscriber.disconnect();
      }
      const sampleNode = (0, utils_1.sample)(this.connectionPool.getNodes());
      if (!sampleNode) {
        debug2("selecting subscriber failed since there is no node discovered in the cluster yet");
        this.subscriber = null;
        return;
      }
      const { options } = sampleNode;
      debug2("selected a subscriber %s:%s", options.host, options.port);
      let connectionPrefix = "subscriber";
      if (this.isSharded)
        connectionPrefix = "ssubscriber";
      this.subscriber = new Redis_1.default({
        port: options.port,
        host: options.host,
        username: options.username,
        password: options.password,
        enableReadyCheck: true,
        connectionName: (0, util_1.getConnectionName)(connectionPrefix, options.connectionName),
        lazyConnect: true,
        tls: options.tls,
        // Don't try to reconnect the subscriber connection. If the connection fails
        // we will get an end event (handled below), at which point we'll pick a new
        // node from the pool and try to connect to that as the subscriber connection.
        retryStrategy: null
      });
      this.subscriber.on("error", utils_1.noop);
      this.subscriber.once("end", this.onSubscriberEnd);
      const previousChannels = { subscribe: [], psubscribe: [], ssubscribe: [] };
      if (lastActiveSubscriber) {
        const condition = lastActiveSubscriber.condition || lastActiveSubscriber.prevCondition;
        if (condition && condition.subscriber) {
          previousChannels.subscribe = condition.subscriber.channels("subscribe");
          previousChannels.psubscribe = condition.subscriber.channels("psubscribe");
          previousChannels.ssubscribe = condition.subscriber.channels("ssubscribe");
        }
      }
      if (previousChannels.subscribe.length || previousChannels.psubscribe.length || previousChannels.ssubscribe.length) {
        let pending = 0;
        for (const type2 of ["subscribe", "psubscribe", "ssubscribe"]) {
          const channels = previousChannels[type2];
          if (channels.length) {
            pending += 1;
            debug2("%s %d channels", type2, channels.length);
            this.subscriber[type2](channels).then(() => {
              if (!--pending) {
                this.lastActiveSubscriber = this.subscriber;
              }
            }).catch(() => {
              debug2("failed to %s %d channels", type2, channels.length);
            });
          }
        }
      } else {
        this.lastActiveSubscriber = this.subscriber;
      }
      for (const event of [
        "message",
        "messageBuffer"
      ]) {
        this.subscriber.on(event, (arg1, arg2) => {
          this.emitter.emit(event, arg1, arg2);
        });
      }
      for (const event of ["pmessage", "pmessageBuffer"]) {
        this.subscriber.on(event, (arg1, arg2, arg3) => {
          this.emitter.emit(event, arg1, arg2, arg3);
        });
      }
      if (this.isSharded == true) {
        for (const event of [
          "smessage",
          "smessageBuffer"
        ]) {
          this.subscriber.on(event, (arg1, arg2) => {
            this.emitter.emit(event, arg1, arg2);
          });
        }
      }
    }
  };
  ClusterSubscriber.default = ClusterSubscriber$1;
  return ClusterSubscriber;
}
var ConnectionPool = {};
var hasRequiredConnectionPool;
function requireConnectionPool() {
  if (hasRequiredConnectionPool) return ConnectionPool;
  hasRequiredConnectionPool = 1;
  Object.defineProperty(ConnectionPool, "__esModule", { value: true });
  const events_1 = require$$0$6;
  const utils_1 = requireUtils();
  const util_1 = requireUtil();
  const Redis_1 = requireRedis();
  const debug2 = (0, utils_1.Debug)("cluster:connectionPool");
  let ConnectionPool$1 = class ConnectionPool extends events_1.EventEmitter {
    constructor(redisOptions) {
      super();
      this.redisOptions = redisOptions;
      this.nodes = {
        all: {},
        master: {},
        slave: {}
      };
      this.specifiedOptions = {};
    }
    getNodes(role2 = "all") {
      const nodes = this.nodes[role2];
      return Object.keys(nodes).map((key) => nodes[key]);
    }
    getInstanceByKey(key) {
      return this.nodes.all[key];
    }
    getSampleInstance(role2) {
      const keys2 = Object.keys(this.nodes[role2]);
      const sampleKey = (0, utils_1.sample)(keys2);
      return this.nodes[role2][sampleKey];
    }
    /**
     * Add a master node to the pool
     * @param node
     */
    addMasterNode(node2) {
      const key = (0, util_1.getNodeKey)(node2.options);
      const redis = this.createRedisFromOptions(node2, node2.options.readOnly);
      if (!node2.options.readOnly) {
        this.nodes.all[key] = redis;
        this.nodes.master[key] = redis;
        return true;
      }
      return false;
    }
    /**
     * Creates a Redis connection instance from the node options
     * @param node
     * @param readOnly
     */
    createRedisFromOptions(node2, readOnly) {
      const redis = new Redis_1.default((0, utils_1.defaults)({
        // Never try to reconnect when a node is lose,
        // instead, waiting for a `MOVED` error and
        // fetch the slots again.
        retryStrategy: null,
        // Offline queue should be enabled so that
        // we don't need to wait for the `ready` event
        // before sending commands to the node.
        enableOfflineQueue: true,
        readOnly
      }, node2, this.redisOptions, { lazyConnect: true }));
      return redis;
    }
    /**
     * Find or create a connection to the node
     */
    findOrCreate(node2, readOnly = false) {
      const key = (0, util_1.getNodeKey)(node2);
      readOnly = Boolean(readOnly);
      if (this.specifiedOptions[key]) {
        Object.assign(node2, this.specifiedOptions[key]);
      } else {
        this.specifiedOptions[key] = node2;
      }
      let redis;
      if (this.nodes.all[key]) {
        redis = this.nodes.all[key];
        if (redis.options.readOnly !== readOnly) {
          redis.options.readOnly = readOnly;
          debug2("Change role of %s to %s", key, readOnly ? "slave" : "master");
          redis[readOnly ? "readonly" : "readwrite"]().catch(utils_1.noop);
          if (readOnly) {
            delete this.nodes.master[key];
            this.nodes.slave[key] = redis;
          } else {
            delete this.nodes.slave[key];
            this.nodes.master[key] = redis;
          }
        }
      } else {
        debug2("Connecting to %s as %s", key, readOnly ? "slave" : "master");
        redis = this.createRedisFromOptions(node2, readOnly);
        this.nodes.all[key] = redis;
        this.nodes[readOnly ? "slave" : "master"][key] = redis;
        redis.once("end", () => {
          this.removeNode(key);
          this.emit("-node", redis, key);
          if (!Object.keys(this.nodes.all).length) {
            this.emit("drain");
          }
        });
        this.emit("+node", redis, key);
        redis.on("error", function(error) {
          this.emit("nodeError", error, key);
        });
      }
      return redis;
    }
    /**
     * Reset the pool with a set of nodes.
     * The old node will be removed.
     */
    reset(nodes) {
      debug2("Reset with %O", nodes);
      const newNodes = {};
      nodes.forEach((node2) => {
        const key = (0, util_1.getNodeKey)(node2);
        if (!(node2.readOnly && newNodes[key])) {
          newNodes[key] = node2;
        }
      });
      Object.keys(this.nodes.all).forEach((key) => {
        if (!newNodes[key]) {
          debug2("Disconnect %s because the node does not hold any slot", key);
          this.nodes.all[key].disconnect();
          this.removeNode(key);
        }
      });
      Object.keys(newNodes).forEach((key) => {
        const node2 = newNodes[key];
        this.findOrCreate(node2, node2.readOnly);
      });
    }
    /**
     * Remove a node from the pool.
     */
    removeNode(key) {
      const { nodes } = this;
      if (nodes.all[key]) {
        debug2("Remove %s from the pool", key);
        delete nodes.all[key];
      }
      delete nodes.master[key];
      delete nodes.slave[key];
    }
  };
  ConnectionPool.default = ConnectionPool$1;
  return ConnectionPool;
}
var DelayQueue = {};
var hasRequiredDelayQueue;
function requireDelayQueue() {
  if (hasRequiredDelayQueue) return DelayQueue;
  hasRequiredDelayQueue = 1;
  Object.defineProperty(DelayQueue, "__esModule", { value: true });
  const utils_1 = requireUtils();
  const Deque = requireDenque();
  const debug2 = (0, utils_1.Debug)("delayqueue");
  let DelayQueue$1 = class DelayQueue {
    constructor() {
      this.queues = {};
      this.timeouts = {};
    }
    /**
     * Add a new item to the queue
     *
     * @param bucket bucket name
     * @param item function that will run later
     * @param options
     */
    push(bucket, item, options) {
      const callback = options.callback || process.nextTick;
      if (!this.queues[bucket]) {
        this.queues[bucket] = new Deque();
      }
      const queue = this.queues[bucket];
      queue.push(item);
      if (!this.timeouts[bucket]) {
        this.timeouts[bucket] = setTimeout(() => {
          callback(() => {
            this.timeouts[bucket] = null;
            this.execute(bucket);
          });
        }, options.timeout);
      }
    }
    execute(bucket) {
      const queue = this.queues[bucket];
      if (!queue) {
        return;
      }
      const { length } = queue;
      if (!length) {
        return;
      }
      debug2("send %d commands in %s queue", length, bucket);
      this.queues[bucket] = null;
      while (queue.length > 0) {
        queue.shift()();
      }
    }
  };
  DelayQueue.default = DelayQueue$1;
  return DelayQueue;
}
var ClusterSubscriberGroup = {};
var hasRequiredClusterSubscriberGroup;
function requireClusterSubscriberGroup() {
  if (hasRequiredClusterSubscriberGroup) return ClusterSubscriberGroup;
  hasRequiredClusterSubscriberGroup = 1;
  Object.defineProperty(ClusterSubscriberGroup, "__esModule", { value: true });
  const utils_1 = requireUtils();
  const ClusterSubscriber_1 = requireClusterSubscriber();
  const ConnectionPool_1 = requireConnectionPool();
  const util_1 = requireUtil();
  const calculateSlot = requireLib();
  const debug2 = (0, utils_1.Debug)("cluster:subscriberGroup");
  let ClusterSubscriberGroup$1 = class ClusterSubscriberGroup {
    /**
     * Register callbacks
     *
     * @param cluster
     */
    constructor(cluster2) {
      this.cluster = cluster2;
      this.shardedSubscribers = /* @__PURE__ */ new Map();
      this.clusterSlots = [];
      this.subscriberToSlotsIndex = /* @__PURE__ */ new Map();
      this.channels = /* @__PURE__ */ new Map();
      cluster2.on("+node", (redis) => {
        this._addSubscriber(redis);
      });
      cluster2.on("-node", (redis) => {
        this._removeSubscriber(redis);
      });
      cluster2.on("refresh", () => {
        this._refreshSlots(cluster2);
      });
    }
    /**
     * Get the responsible subscriber.
     *
     * Returns null if no subscriber was found
     *
     * @param slot
     */
    getResponsibleSubscriber(slot) {
      const nodeKey = this.clusterSlots[slot][0];
      return this.shardedSubscribers.get(nodeKey);
    }
    /**
     * Adds a channel for which this subscriber group is responsible
     *
     * @param channels
     */
    addChannels(channels) {
      const slot = calculateSlot(channels[0]);
      channels.forEach((c) => {
        if (calculateSlot(c) != slot)
          return -1;
      });
      const currChannels = this.channels.get(slot);
      if (!currChannels) {
        this.channels.set(slot, channels);
      } else {
        this.channels.set(slot, currChannels.concat(channels));
      }
      return [...this.channels.values()].flatMap((v) => v).length;
    }
    /**
     * Removes channels for which the subscriber group is responsible by optionally unsubscribing
     * @param channels
     */
    removeChannels(channels) {
      const slot = calculateSlot(channels[0]);
      channels.forEach((c) => {
        if (calculateSlot(c) != slot)
          return -1;
      });
      const slotChannels = this.channels.get(slot);
      if (slotChannels) {
        const updatedChannels = slotChannels.filter((c) => !channels.includes(c));
        this.channels.set(slot, updatedChannels);
      }
      return [...this.channels.values()].flatMap((v) => v).length;
    }
    /**
     * Disconnect all subscribers
     */
    stop() {
      for (const s of this.shardedSubscribers.values()) {
        s.stop();
      }
    }
    /**
     * Start all not yet started subscribers
     */
    start() {
      for (const s of this.shardedSubscribers.values()) {
        if (!s.isStarted()) {
          s.start();
        }
      }
    }
    /**
     * Add a subscriber to the group of subscribers
     *
     * @param redis
     */
    _addSubscriber(redis) {
      const pool = new ConnectionPool_1.default(redis.options);
      if (pool.addMasterNode(redis)) {
        const sub = new ClusterSubscriber_1.default(pool, this.cluster, true);
        const nodeKey = (0, util_1.getNodeKey)(redis.options);
        this.shardedSubscribers.set(nodeKey, sub);
        sub.start();
        this._resubscribe();
        this.cluster.emit("+subscriber");
        return sub;
      }
      return null;
    }
    /**
     * Removes a subscriber from the group
     * @param redis
     */
    _removeSubscriber(redis) {
      const nodeKey = (0, util_1.getNodeKey)(redis.options);
      const sub = this.shardedSubscribers.get(nodeKey);
      if (sub) {
        sub.stop();
        this.shardedSubscribers.delete(nodeKey);
        this._resubscribe();
        this.cluster.emit("-subscriber");
      }
      return this.shardedSubscribers;
    }
    /**
     * Refreshes the subscriber-related slot ranges
     *
     * Returns false if no refresh was needed
     *
     * @param cluster
     */
    _refreshSlots(cluster2) {
      if (this._slotsAreEqual(cluster2.slots)) {
        debug2("Nothing to refresh because the new cluster map is equal to the previous one.");
      } else {
        debug2("Refreshing the slots of the subscriber group.");
        this.subscriberToSlotsIndex = /* @__PURE__ */ new Map();
        for (let slot = 0; slot < cluster2.slots.length; slot++) {
          const node2 = cluster2.slots[slot][0];
          if (!this.subscriberToSlotsIndex.has(node2)) {
            this.subscriberToSlotsIndex.set(node2, []);
          }
          this.subscriberToSlotsIndex.get(node2).push(Number(slot));
        }
        this._resubscribe();
        this.clusterSlots = JSON.parse(JSON.stringify(cluster2.slots));
        this.cluster.emit("subscribersReady");
        return true;
      }
      return false;
    }
    /**
     * Resubscribes to the previous channels
     *
     * @private
     */
    _resubscribe() {
      if (this.shardedSubscribers) {
        this.shardedSubscribers.forEach((s, nodeKey) => {
          const subscriberSlots = this.subscriberToSlotsIndex.get(nodeKey);
          if (subscriberSlots) {
            s.associateSlotRange(subscriberSlots);
            subscriberSlots.forEach((ss) => {
              const redis = s.getInstance();
              const channels = this.channels.get(ss);
              if (channels && channels.length > 0) {
                if (redis) {
                  redis.ssubscribe(channels);
                  redis.on("ready", () => {
                    redis.ssubscribe(channels);
                  });
                }
              }
            });
          }
        });
      }
    }
    /**
     * Deep equality of the cluster slots objects
     *
     * @param other
     * @private
     */
    _slotsAreEqual(other) {
      if (this.clusterSlots === void 0)
        return false;
      else
        return JSON.stringify(this.clusterSlots) === JSON.stringify(other);
    }
  };
  ClusterSubscriberGroup.default = ClusterSubscriberGroup$1;
  return ClusterSubscriberGroup;
}
var hasRequiredCluster;
function requireCluster() {
  if (hasRequiredCluster) return cluster;
  hasRequiredCluster = 1;
  Object.defineProperty(cluster, "__esModule", { value: true });
  const commands_1 = requireBuilt$2();
  const events_1 = require$$0$6;
  const redis_errors_1 = requireRedisErrors();
  const standard_as_callback_1 = requireBuilt$1();
  const Command_1 = requireCommand();
  const ClusterAllFailedError_1 = requireClusterAllFailedError();
  const Redis_1 = requireRedis();
  const ScanStream_1 = requireScanStream();
  const transaction_1 = requireTransaction();
  const utils_1 = requireUtils();
  const applyMixin_1 = requireApplyMixin();
  const Commander_1 = requireCommander();
  const ClusterOptions_1 = requireClusterOptions();
  const ClusterSubscriber_1 = requireClusterSubscriber();
  const ConnectionPool_1 = requireConnectionPool();
  const DelayQueue_1 = requireDelayQueue();
  const util_1 = requireUtil();
  const Deque = requireDenque();
  const ClusterSubscriberGroup_1 = requireClusterSubscriberGroup();
  const debug2 = (0, utils_1.Debug)("cluster");
  const REJECT_OVERWRITTEN_COMMANDS = /* @__PURE__ */ new WeakSet();
  class Cluster extends Commander_1.default {
    /**
     * Creates an instance of Cluster.
     */
    //TODO: Add an option that enables or disables sharded PubSub
    constructor(startupNodes, options = {}) {
      super();
      this.slots = [];
      this._groupsIds = {};
      this._groupsBySlot = Array(16384);
      this.isCluster = true;
      this.retryAttempts = 0;
      this.delayQueue = new DelayQueue_1.default();
      this.offlineQueue = new Deque();
      this.isRefreshing = false;
      this._refreshSlotsCacheCallbacks = [];
      this._autoPipelines = /* @__PURE__ */ new Map();
      this._runningAutoPipelines = /* @__PURE__ */ new Set();
      this._readyDelayedCallbacks = [];
      this.connectionEpoch = 0;
      events_1.EventEmitter.call(this);
      this.startupNodes = startupNodes;
      this.options = (0, utils_1.defaults)({}, options, ClusterOptions_1.DEFAULT_CLUSTER_OPTIONS, this.options);
      if (this.options.shardedSubscribers == true)
        this.shardedSubscribers = new ClusterSubscriberGroup_1.default(this);
      if (this.options.redisOptions && this.options.redisOptions.keyPrefix && !this.options.keyPrefix) {
        this.options.keyPrefix = this.options.redisOptions.keyPrefix;
      }
      if (typeof this.options.scaleReads !== "function" && ["all", "master", "slave"].indexOf(this.options.scaleReads) === -1) {
        throw new Error('Invalid option scaleReads "' + this.options.scaleReads + '". Expected "all", "master", "slave" or a custom function');
      }
      this.connectionPool = new ConnectionPool_1.default(this.options.redisOptions);
      this.connectionPool.on("-node", (redis, key) => {
        this.emit("-node", redis);
      });
      this.connectionPool.on("+node", (redis) => {
        this.emit("+node", redis);
      });
      this.connectionPool.on("drain", () => {
        this.setStatus("close");
      });
      this.connectionPool.on("nodeError", (error, key) => {
        this.emit("node error", error, key);
      });
      this.subscriber = new ClusterSubscriber_1.default(this.connectionPool, this);
      if (this.options.scripts) {
        Object.entries(this.options.scripts).forEach(([name, definition]) => {
          this.defineCommand(name, definition);
        });
      }
      if (this.options.lazyConnect) {
        this.setStatus("wait");
      } else {
        this.connect().catch((err) => {
          debug2("connecting failed: %s", err);
        });
      }
    }
    /**
     * Connect to a cluster
     */
    connect() {
      return new Promise((resolve, reject) => {
        if (this.status === "connecting" || this.status === "connect" || this.status === "ready") {
          reject(new Error("Redis is already connecting/connected"));
          return;
        }
        const epoch = ++this.connectionEpoch;
        this.setStatus("connecting");
        this.resolveStartupNodeHostnames().then((nodes) => {
          if (this.connectionEpoch !== epoch) {
            debug2("discard connecting after resolving startup nodes because epoch not match: %d != %d", epoch, this.connectionEpoch);
            reject(new redis_errors_1.RedisError("Connection is discarded because a new connection is made"));
            return;
          }
          if (this.status !== "connecting") {
            debug2("discard connecting after resolving startup nodes because the status changed to %s", this.status);
            reject(new redis_errors_1.RedisError("Connection is aborted"));
            return;
          }
          this.connectionPool.reset(nodes);
          const readyHandler = () => {
            this.setStatus("ready");
            this.retryAttempts = 0;
            this.executeOfflineCommands();
            this.resetNodesRefreshInterval();
            resolve();
          };
          let closeListener = void 0;
          const refreshListener = () => {
            this.invokeReadyDelayedCallbacks(void 0);
            this.removeListener("close", closeListener);
            this.manuallyClosing = false;
            this.setStatus("connect");
            if (this.options.enableReadyCheck) {
              this.readyCheck((err, fail) => {
                if (err || fail) {
                  debug2("Ready check failed (%s). Reconnecting...", err || fail);
                  if (this.status === "connect") {
                    this.disconnect(true);
                  }
                } else {
                  readyHandler();
                }
              });
            } else {
              readyHandler();
            }
          };
          closeListener = () => {
            const error = new Error("None of startup nodes is available");
            this.removeListener("refresh", refreshListener);
            this.invokeReadyDelayedCallbacks(error);
            reject(error);
          };
          this.once("refresh", refreshListener);
          this.once("close", closeListener);
          this.once("close", this.handleCloseEvent.bind(this));
          this.refreshSlotsCache((err) => {
            if (err && err.message === ClusterAllFailedError_1.default.defaultMessage) {
              Redis_1.default.prototype.silentEmit.call(this, "error", err);
              this.connectionPool.reset([]);
            }
          });
          this.subscriber.start();
          if (this.options.shardedSubscribers) {
            this.shardedSubscribers.start();
          }
        }).catch((err) => {
          this.setStatus("close");
          this.handleCloseEvent(err);
          this.invokeReadyDelayedCallbacks(err);
          reject(err);
        });
      });
    }
    /**
     * Disconnect from every node in the cluster.
     */
    disconnect(reconnect = false) {
      const status = this.status;
      this.setStatus("disconnecting");
      if (!reconnect) {
        this.manuallyClosing = true;
      }
      if (this.reconnectTimeout && !reconnect) {
        clearTimeout(this.reconnectTimeout);
        this.reconnectTimeout = null;
        debug2("Canceled reconnecting attempts");
      }
      this.clearNodesRefreshInterval();
      this.subscriber.stop();
      if (this.options.shardedSubscribers) {
        this.shardedSubscribers.stop();
      }
      if (status === "wait") {
        this.setStatus("close");
        this.handleCloseEvent();
      } else {
        this.connectionPool.reset([]);
      }
    }
    /**
     * Quit the cluster gracefully.
     */
    quit(callback) {
      const status = this.status;
      this.setStatus("disconnecting");
      this.manuallyClosing = true;
      if (this.reconnectTimeout) {
        clearTimeout(this.reconnectTimeout);
        this.reconnectTimeout = null;
      }
      this.clearNodesRefreshInterval();
      this.subscriber.stop();
      if (this.options.shardedSubscribers) {
        this.shardedSubscribers.stop();
      }
      if (status === "wait") {
        const ret = (0, standard_as_callback_1.default)(Promise.resolve("OK"), callback);
        setImmediate((function() {
          this.setStatus("close");
          this.handleCloseEvent();
        }).bind(this));
        return ret;
      }
      return (0, standard_as_callback_1.default)(Promise.all(this.nodes().map((node2) => node2.quit().catch((err) => {
        if (err.message === utils_1.CONNECTION_CLOSED_ERROR_MSG) {
          return "OK";
        }
        throw err;
      }))).then(() => "OK"), callback);
    }
    /**
     * Create a new instance with the same startup nodes and options as the current one.
     *
     * @example
     * ```js
     * var cluster = new Redis.Cluster([{ host: "127.0.0.1", port: "30001" }]);
     * var anotherCluster = cluster.duplicate();
     * ```
     */
    duplicate(overrideStartupNodes = [], overrideOptions = {}) {
      const startupNodes = overrideStartupNodes.length > 0 ? overrideStartupNodes : this.startupNodes.slice(0);
      const options = Object.assign({}, this.options, overrideOptions);
      return new Cluster(startupNodes, options);
    }
    /**
     * Get nodes with the specified role
     */
    nodes(role2 = "all") {
      if (role2 !== "all" && role2 !== "master" && role2 !== "slave") {
        throw new Error('Invalid role "' + role2 + '". Expected "all", "master" or "slave"');
      }
      return this.connectionPool.getNodes(role2);
    }
    /**
     * This is needed in order not to install a listener for each auto pipeline
     *
     * @ignore
     */
    delayUntilReady(callback) {
      this._readyDelayedCallbacks.push(callback);
    }
    /**
     * Get the number of commands queued in automatic pipelines.
     *
     * This is not available (and returns 0) until the cluster is connected and slots information have been received.
     */
    get autoPipelineQueueSize() {
      let queued = 0;
      for (const pipeline of this._autoPipelines.values()) {
        queued += pipeline.length;
      }
      return queued;
    }
    /**
     * Refresh the slot cache
     *
     * @ignore
     */
    refreshSlotsCache(callback) {
      if (callback) {
        this._refreshSlotsCacheCallbacks.push(callback);
      }
      if (this.isRefreshing) {
        return;
      }
      this.isRefreshing = true;
      const _this = this;
      const wrapper = (error) => {
        this.isRefreshing = false;
        for (const callback2 of this._refreshSlotsCacheCallbacks) {
          callback2(error);
        }
        this._refreshSlotsCacheCallbacks = [];
      };
      const nodes = (0, utils_1.shuffle)(this.connectionPool.getNodes());
      let lastNodeError = null;
      function tryNode(index) {
        if (index === nodes.length) {
          const error = new ClusterAllFailedError_1.default(ClusterAllFailedError_1.default.defaultMessage, lastNodeError);
          return wrapper(error);
        }
        const node2 = nodes[index];
        const key = `${node2.options.host}:${node2.options.port}`;
        debug2("getting slot cache from %s", key);
        _this.getInfoFromNode(node2, function(err) {
          switch (_this.status) {
            case "close":
            case "end":
              return wrapper(new Error("Cluster is disconnected."));
            case "disconnecting":
              return wrapper(new Error("Cluster is disconnecting."));
          }
          if (err) {
            _this.emit("node error", err, key);
            lastNodeError = err;
            tryNode(index + 1);
          } else {
            _this.emit("refresh");
            wrapper();
          }
        });
      }
      tryNode(0);
    }
    /**
     * @ignore
     */
    sendCommand(command2, stream, node2) {
      if (this.status === "wait") {
        this.connect().catch(utils_1.noop);
      }
      if (this.status === "end") {
        command2.reject(new Error(utils_1.CONNECTION_CLOSED_ERROR_MSG));
        return command2.promise;
      }
      let to = this.options.scaleReads;
      if (to !== "master") {
        const isCommandReadOnly = command2.isReadOnly || (0, commands_1.exists)(command2.name) && (0, commands_1.hasFlag)(command2.name, "readonly");
        if (!isCommandReadOnly) {
          to = "master";
        }
      }
      let targetSlot = node2 ? node2.slot : command2.getSlot();
      const ttl2 = {};
      const _this = this;
      if (!node2 && !REJECT_OVERWRITTEN_COMMANDS.has(command2)) {
        REJECT_OVERWRITTEN_COMMANDS.add(command2);
        const reject = command2.reject;
        command2.reject = function(err) {
          const partialTry = tryConnection.bind(null, true);
          _this.handleError(err, ttl2, {
            moved: function(slot, key) {
              debug2("command %s is moved to %s", command2.name, key);
              targetSlot = Number(slot);
              if (_this.slots[slot]) {
                _this.slots[slot][0] = key;
              } else {
                _this.slots[slot] = [key];
              }
              _this._groupsBySlot[slot] = _this._groupsIds[_this.slots[slot].join(";")];
              _this.connectionPool.findOrCreate(_this.natMapper(key));
              tryConnection();
              debug2("refreshing slot caches... (triggered by MOVED error)");
              _this.refreshSlotsCache();
            },
            ask: function(slot, key) {
              debug2("command %s is required to ask %s:%s", command2.name, key);
              const mapped = _this.natMapper(key);
              _this.connectionPool.findOrCreate(mapped);
              tryConnection(false, `${mapped.host}:${mapped.port}`);
            },
            tryagain: partialTry,
            clusterDown: partialTry,
            connectionClosed: partialTry,
            maxRedirections: function(redirectionError) {
              reject.call(command2, redirectionError);
            },
            defaults: function() {
              reject.call(command2, err);
            }
          });
        };
      }
      tryConnection();
      function tryConnection(random, asking2) {
        if (_this.status === "end") {
          command2.reject(new redis_errors_1.AbortError("Cluster is ended."));
          return;
        }
        let redis;
        if (_this.status === "ready" || command2.name === "cluster") {
          if (node2 && node2.redis) {
            redis = node2.redis;
          } else if (Command_1.default.checkFlag("ENTER_SUBSCRIBER_MODE", command2.name) || Command_1.default.checkFlag("EXIT_SUBSCRIBER_MODE", command2.name)) {
            if (_this.options.shardedSubscribers == true && (command2.name == "ssubscribe" || command2.name == "sunsubscribe")) {
              const sub = _this.shardedSubscribers.getResponsibleSubscriber(targetSlot);
              let status = -1;
              if (command2.name == "ssubscribe")
                status = _this.shardedSubscribers.addChannels(command2.getKeys());
              if (command2.name == "sunsubscribe")
                status = _this.shardedSubscribers.removeChannels(command2.getKeys());
              if (status !== -1) {
                redis = sub.getInstance();
              } else {
                command2.reject(new redis_errors_1.AbortError("Can't add or remove the given channels. Are they in the same slot?"));
              }
            } else {
              redis = _this.subscriber.getInstance();
            }
            if (!redis) {
              command2.reject(new redis_errors_1.AbortError("No subscriber for the cluster"));
              return;
            }
          } else {
            if (!random) {
              if (typeof targetSlot === "number" && _this.slots[targetSlot]) {
                const nodeKeys = _this.slots[targetSlot];
                if (typeof to === "function") {
                  const nodes = nodeKeys.map(function(key) {
                    return _this.connectionPool.getInstanceByKey(key);
                  });
                  redis = to(nodes, command2);
                  if (Array.isArray(redis)) {
                    redis = (0, utils_1.sample)(redis);
                  }
                  if (!redis) {
                    redis = nodes[0];
                  }
                } else {
                  let key;
                  if (to === "all") {
                    key = (0, utils_1.sample)(nodeKeys);
                  } else if (to === "slave" && nodeKeys.length > 1) {
                    key = (0, utils_1.sample)(nodeKeys, 1);
                  } else {
                    key = nodeKeys[0];
                  }
                  redis = _this.connectionPool.getInstanceByKey(key);
                }
              }
              if (asking2) {
                redis = _this.connectionPool.getInstanceByKey(asking2);
                redis.asking();
              }
            }
            if (!redis) {
              redis = (typeof to === "function" ? null : _this.connectionPool.getSampleInstance(to)) || _this.connectionPool.getSampleInstance("all");
            }
          }
          if (node2 && !node2.redis) {
            node2.redis = redis;
          }
        }
        if (redis) {
          redis.sendCommand(command2, stream);
        } else if (_this.options.enableOfflineQueue) {
          _this.offlineQueue.push({
            command: command2,
            stream,
            node: node2
          });
        } else {
          command2.reject(new Error("Cluster isn't ready and enableOfflineQueue options is false"));
        }
      }
      return command2.promise;
    }
    sscanStream(key, options) {
      return this.createScanStream("sscan", { key, options });
    }
    sscanBufferStream(key, options) {
      return this.createScanStream("sscanBuffer", { key, options });
    }
    hscanStream(key, options) {
      return this.createScanStream("hscan", { key, options });
    }
    hscanBufferStream(key, options) {
      return this.createScanStream("hscanBuffer", { key, options });
    }
    zscanStream(key, options) {
      return this.createScanStream("zscan", { key, options });
    }
    zscanBufferStream(key, options) {
      return this.createScanStream("zscanBuffer", { key, options });
    }
    /**
     * @ignore
     */
    handleError(error, ttl2, handlers) {
      if (typeof ttl2.value === "undefined") {
        ttl2.value = this.options.maxRedirections;
      } else {
        ttl2.value -= 1;
      }
      if (ttl2.value <= 0) {
        handlers.maxRedirections(new Error("Too many Cluster redirections. Last error: " + error));
        return;
      }
      const errv = error.message.split(" ");
      if (errv[0] === "MOVED") {
        const timeout = this.options.retryDelayOnMoved;
        if (timeout && typeof timeout === "number") {
          this.delayQueue.push("moved", handlers.moved.bind(null, errv[1], errv[2]), { timeout });
        } else {
          handlers.moved(errv[1], errv[2]);
        }
      } else if (errv[0] === "ASK") {
        handlers.ask(errv[1], errv[2]);
      } else if (errv[0] === "TRYAGAIN") {
        this.delayQueue.push("tryagain", handlers.tryagain, {
          timeout: this.options.retryDelayOnTryAgain
        });
      } else if (errv[0] === "CLUSTERDOWN" && this.options.retryDelayOnClusterDown > 0) {
        this.delayQueue.push("clusterdown", handlers.connectionClosed, {
          timeout: this.options.retryDelayOnClusterDown,
          callback: this.refreshSlotsCache.bind(this)
        });
      } else if (error.message === utils_1.CONNECTION_CLOSED_ERROR_MSG && this.options.retryDelayOnFailover > 0 && this.status === "ready") {
        this.delayQueue.push("failover", handlers.connectionClosed, {
          timeout: this.options.retryDelayOnFailover,
          callback: this.refreshSlotsCache.bind(this)
        });
      } else {
        handlers.defaults();
      }
    }
    resetOfflineQueue() {
      this.offlineQueue = new Deque();
    }
    clearNodesRefreshInterval() {
      if (this.slotsTimer) {
        clearTimeout(this.slotsTimer);
        this.slotsTimer = null;
      }
    }
    resetNodesRefreshInterval() {
      if (this.slotsTimer || !this.options.slotsRefreshInterval) {
        return;
      }
      const nextRound = () => {
        this.slotsTimer = setTimeout(() => {
          debug2('refreshing slot caches... (triggered by "slotsRefreshInterval" option)');
          this.refreshSlotsCache(() => {
            nextRound();
          });
        }, this.options.slotsRefreshInterval);
      };
      nextRound();
    }
    /**
     * Change cluster instance's status
     */
    setStatus(status) {
      debug2("status: %s -> %s", this.status || "[empty]", status);
      this.status = status;
      process.nextTick(() => {
        this.emit(status);
      });
    }
    /**
     * Called when closed to check whether a reconnection should be made
     */
    handleCloseEvent(reason) {
      if (reason) {
        debug2("closed because %s", reason);
      }
      let retryDelay;
      if (!this.manuallyClosing && typeof this.options.clusterRetryStrategy === "function") {
        retryDelay = this.options.clusterRetryStrategy.call(this, ++this.retryAttempts, reason);
      }
      if (typeof retryDelay === "number") {
        this.setStatus("reconnecting");
        this.reconnectTimeout = setTimeout(() => {
          this.reconnectTimeout = null;
          debug2("Cluster is disconnected. Retrying after %dms", retryDelay);
          this.connect().catch(function(err) {
            debug2("Got error %s when reconnecting. Ignoring...", err);
          });
        }, retryDelay);
      } else {
        this.setStatus("end");
        this.flushQueue(new Error("None of startup nodes is available"));
      }
    }
    /**
     * Flush offline queue with error.
     */
    flushQueue(error) {
      let item;
      while (item = this.offlineQueue.shift()) {
        item.command.reject(error);
      }
    }
    executeOfflineCommands() {
      if (this.offlineQueue.length) {
        debug2("send %d commands in offline queue", this.offlineQueue.length);
        const offlineQueue = this.offlineQueue;
        this.resetOfflineQueue();
        let item;
        while (item = offlineQueue.shift()) {
          this.sendCommand(item.command, item.stream, item.node);
        }
      }
    }
    natMapper(nodeKey) {
      const key = typeof nodeKey === "string" ? nodeKey : `${nodeKey.host}:${nodeKey.port}`;
      let mapped = null;
      if (this.options.natMap && typeof this.options.natMap === "function") {
        mapped = this.options.natMap(key);
      } else if (this.options.natMap && typeof this.options.natMap === "object") {
        mapped = this.options.natMap[key];
      }
      if (mapped) {
        debug2("NAT mapping %s -> %O", key, mapped);
        return Object.assign({}, mapped);
      }
      return typeof nodeKey === "string" ? (0, util_1.nodeKeyToRedisOptions)(nodeKey) : nodeKey;
    }
    getInfoFromNode(redis, callback) {
      if (!redis) {
        return callback(new Error("Node is disconnected"));
      }
      const duplicatedConnection = redis.duplicate({
        enableOfflineQueue: true,
        enableReadyCheck: false,
        retryStrategy: null,
        connectionName: (0, util_1.getConnectionName)("refresher", this.options.redisOptions && this.options.redisOptions.connectionName)
      });
      duplicatedConnection.on("error", utils_1.noop);
      duplicatedConnection.cluster("SLOTS", (0, utils_1.timeout)((err, result) => {
        duplicatedConnection.disconnect();
        if (err) {
          debug2("error encountered running CLUSTER.SLOTS: %s", err);
          return callback(err);
        }
        if (this.status === "disconnecting" || this.status === "close" || this.status === "end") {
          debug2("ignore CLUSTER.SLOTS results (count: %d) since cluster status is %s", result.length, this.status);
          callback();
          return;
        }
        const nodes = [];
        debug2("cluster slots result count: %d", result.length);
        for (let i = 0; i < result.length; ++i) {
          const items = result[i];
          const slotRangeStart = items[0];
          const slotRangeEnd = items[1];
          const keys2 = [];
          for (let j2 = 2; j2 < items.length; j2++) {
            if (!items[j2][0]) {
              continue;
            }
            const node2 = this.natMapper({
              host: items[j2][0],
              port: items[j2][1]
            });
            node2.readOnly = j2 !== 2;
            nodes.push(node2);
            keys2.push(node2.host + ":" + node2.port);
          }
          debug2("cluster slots result [%d]: slots %d~%d served by %s", i, slotRangeStart, slotRangeEnd, keys2);
          for (let slot = slotRangeStart; slot <= slotRangeEnd; slot++) {
            this.slots[slot] = keys2;
          }
        }
        this._groupsIds = /* @__PURE__ */ Object.create(null);
        let j = 0;
        for (let i = 0; i < 16384; i++) {
          const target = (this.slots[i] || []).join(";");
          if (!target.length) {
            this._groupsBySlot[i] = void 0;
            continue;
          }
          if (!this._groupsIds[target]) {
            this._groupsIds[target] = ++j;
          }
          this._groupsBySlot[i] = this._groupsIds[target];
        }
        this.connectionPool.reset(nodes);
        callback();
      }, this.options.slotsRefreshTimeout));
    }
    invokeReadyDelayedCallbacks(err) {
      for (const c of this._readyDelayedCallbacks) {
        process.nextTick(c, err);
      }
      this._readyDelayedCallbacks = [];
    }
    /**
     * Check whether Cluster is able to process commands
     */
    readyCheck(callback) {
      this.cluster("INFO", (err, res) => {
        if (err) {
          return callback(err);
        }
        if (typeof res !== "string") {
          return callback();
        }
        let state;
        const lines = res.split("\r\n");
        for (let i = 0; i < lines.length; ++i) {
          const parts = lines[i].split(":");
          if (parts[0] === "cluster_state") {
            state = parts[1];
            break;
          }
        }
        if (state === "fail") {
          debug2("cluster state not ok (%s)", state);
          callback(null, state);
        } else {
          callback();
        }
      });
    }
    resolveSrv(hostname) {
      return new Promise((resolve, reject) => {
        this.options.resolveSrv(hostname, (err, records) => {
          if (err) {
            return reject(err);
          }
          const self2 = this, groupedRecords = (0, util_1.groupSrvRecords)(records), sortedKeys = Object.keys(groupedRecords).sort((a, b) => parseInt(a) - parseInt(b));
          function tryFirstOne(err2) {
            if (!sortedKeys.length) {
              return reject(err2);
            }
            const key = sortedKeys[0], group = groupedRecords[key], record = (0, util_1.weightSrvRecords)(group);
            if (!group.records.length) {
              sortedKeys.shift();
            }
            self2.dnsLookup(record.name).then((host) => resolve({
              host,
              port: record.port
            }), tryFirstOne);
          }
          tryFirstOne();
        });
      });
    }
    dnsLookup(hostname) {
      return new Promise((resolve, reject) => {
        this.options.dnsLookup(hostname, (err, address) => {
          if (err) {
            debug2("failed to resolve hostname %s to IP: %s", hostname, err.message);
            reject(err);
          } else {
            debug2("resolved hostname %s to IP %s", hostname, address);
            resolve(address);
          }
        });
      });
    }
    /**
     * Normalize startup nodes, and resolving hostnames to IPs.
     *
     * This process happens every time when #connect() is called since
     * #startupNodes and DNS records may chanage.
     */
    async resolveStartupNodeHostnames() {
      if (!Array.isArray(this.startupNodes) || this.startupNodes.length === 0) {
        throw new Error("`startupNodes` should contain at least one node.");
      }
      const startupNodes = (0, util_1.normalizeNodeOptions)(this.startupNodes);
      const hostnames = (0, util_1.getUniqueHostnamesFromOptions)(startupNodes);
      if (hostnames.length === 0) {
        return startupNodes;
      }
      const configs = await Promise.all(hostnames.map((this.options.useSRVRecords ? this.resolveSrv : this.dnsLookup).bind(this)));
      const hostnameToConfig = (0, utils_1.zipMap)(hostnames, configs);
      return startupNodes.map((node2) => {
        const config2 = hostnameToConfig.get(node2.host);
        if (!config2) {
          return node2;
        }
        if (this.options.useSRVRecords) {
          return Object.assign({}, node2, config2);
        }
        return Object.assign({}, node2, { host: config2 });
      });
    }
    createScanStream(command2, { key, options = {} }) {
      return new ScanStream_1.default({
        objectMode: true,
        key,
        redis: this,
        command: command2,
        ...options
      });
    }
  }
  (0, applyMixin_1.default)(Cluster, events_1.EventEmitter);
  (0, transaction_1.addTransactionSupport)(Cluster.prototype);
  cluster.default = Cluster;
  return cluster;
}
var connectors = {};
var StandaloneConnector = {};
var AbstractConnector = {};
var hasRequiredAbstractConnector;
function requireAbstractConnector() {
  if (hasRequiredAbstractConnector) return AbstractConnector;
  hasRequiredAbstractConnector = 1;
  Object.defineProperty(AbstractConnector, "__esModule", { value: true });
  const utils_1 = requireUtils();
  const debug2 = (0, utils_1.Debug)("AbstractConnector");
  let AbstractConnector$1 = class AbstractConnector {
    constructor(disconnectTimeout) {
      this.connecting = false;
      this.disconnectTimeout = disconnectTimeout;
    }
    check(info2) {
      return true;
    }
    disconnect() {
      this.connecting = false;
      if (this.stream) {
        const stream = this.stream;
        const timeout = setTimeout(() => {
          debug2("stream %s:%s still open, destroying it", stream.remoteAddress, stream.remotePort);
          stream.destroy();
        }, this.disconnectTimeout);
        stream.on("close", () => clearTimeout(timeout));
        stream.end();
      }
    }
  };
  AbstractConnector.default = AbstractConnector$1;
  return AbstractConnector;
}
var hasRequiredStandaloneConnector;
function requireStandaloneConnector() {
  if (hasRequiredStandaloneConnector) return StandaloneConnector;
  hasRequiredStandaloneConnector = 1;
  Object.defineProperty(StandaloneConnector, "__esModule", { value: true });
  const net_1 = require$$0$5;
  const tls_1 = require$$1$3;
  const utils_1 = requireUtils();
  const AbstractConnector_1 = requireAbstractConnector();
  let StandaloneConnector$1 = class StandaloneConnector extends AbstractConnector_1.default {
    constructor(options) {
      super(options.disconnectTimeout);
      this.options = options;
    }
    connect(_) {
      const { options } = this;
      this.connecting = true;
      let connectionOptions;
      if ("path" in options && options.path) {
        connectionOptions = {
          path: options.path
        };
      } else {
        connectionOptions = {};
        if ("port" in options && options.port != null) {
          connectionOptions.port = options.port;
        }
        if ("host" in options && options.host != null) {
          connectionOptions.host = options.host;
        }
        if ("family" in options && options.family != null) {
          connectionOptions.family = options.family;
        }
      }
      if (options.tls) {
        Object.assign(connectionOptions, options.tls);
      }
      return new Promise((resolve, reject) => {
        process.nextTick(() => {
          if (!this.connecting) {
            reject(new Error(utils_1.CONNECTION_CLOSED_ERROR_MSG));
            return;
          }
          try {
            if (options.tls) {
              this.stream = (0, tls_1.connect)(connectionOptions);
            } else {
              this.stream = (0, net_1.createConnection)(connectionOptions);
            }
          } catch (err) {
            reject(err);
            return;
          }
          this.stream.once("error", (err) => {
            this.firstError = err;
          });
          resolve(this.stream);
        });
      });
    }
  };
  StandaloneConnector.default = StandaloneConnector$1;
  return StandaloneConnector;
}
var SentinelConnector = {};
var SentinelIterator = {};
var hasRequiredSentinelIterator;
function requireSentinelIterator() {
  if (hasRequiredSentinelIterator) return SentinelIterator;
  hasRequiredSentinelIterator = 1;
  Object.defineProperty(SentinelIterator, "__esModule", { value: true });
  function isSentinelEql(a, b) {
    return (a.host || "127.0.0.1") === (b.host || "127.0.0.1") && (a.port || 26379) === (b.port || 26379);
  }
  let SentinelIterator$1 = class SentinelIterator {
    constructor(sentinels) {
      this.cursor = 0;
      this.sentinels = sentinels.slice(0);
    }
    next() {
      const done = this.cursor >= this.sentinels.length;
      return { done, value: done ? void 0 : this.sentinels[this.cursor++] };
    }
    reset(moveCurrentEndpointToFirst) {
      if (moveCurrentEndpointToFirst && this.sentinels.length > 1 && this.cursor !== 1) {
        this.sentinels.unshift(...this.sentinels.splice(this.cursor - 1));
      }
      this.cursor = 0;
    }
    add(sentinel) {
      for (let i = 0; i < this.sentinels.length; i++) {
        if (isSentinelEql(sentinel, this.sentinels[i])) {
          return false;
        }
      }
      this.sentinels.push(sentinel);
      return true;
    }
    toString() {
      return `${JSON.stringify(this.sentinels)} @${this.cursor}`;
    }
  };
  SentinelIterator.default = SentinelIterator$1;
  return SentinelIterator;
}
var FailoverDetector = {};
var hasRequiredFailoverDetector;
function requireFailoverDetector() {
  if (hasRequiredFailoverDetector) return FailoverDetector;
  hasRequiredFailoverDetector = 1;
  Object.defineProperty(FailoverDetector, "__esModule", { value: true });
  FailoverDetector.FailoverDetector = void 0;
  const utils_1 = requireUtils();
  const debug2 = (0, utils_1.Debug)("FailoverDetector");
  const CHANNEL_NAME = "+switch-master";
  let FailoverDetector$1 = class FailoverDetector {
    // sentinels can't be used for regular commands after this
    constructor(connector, sentinels) {
      this.isDisconnected = false;
      this.connector = connector;
      this.sentinels = sentinels;
    }
    cleanup() {
      this.isDisconnected = true;
      for (const sentinel of this.sentinels) {
        sentinel.client.disconnect();
      }
    }
    async subscribe() {
      debug2("Starting FailoverDetector");
      const promises = [];
      for (const sentinel of this.sentinels) {
        const promise = sentinel.client.subscribe(CHANNEL_NAME).catch((err) => {
          debug2("Failed to subscribe to failover messages on sentinel %s:%s (%s)", sentinel.address.host || "127.0.0.1", sentinel.address.port || 26739, err.message);
        });
        promises.push(promise);
        sentinel.client.on("message", (channel) => {
          if (!this.isDisconnected && channel === CHANNEL_NAME) {
            this.disconnect();
          }
        });
      }
      await Promise.all(promises);
    }
    disconnect() {
      this.isDisconnected = true;
      debug2("Failover detected, disconnecting");
      this.connector.disconnect();
    }
  };
  FailoverDetector.FailoverDetector = FailoverDetector$1;
  return FailoverDetector;
}
var hasRequiredSentinelConnector;
function requireSentinelConnector() {
  if (hasRequiredSentinelConnector) return SentinelConnector;
  hasRequiredSentinelConnector = 1;
  Object.defineProperty(SentinelConnector, "__esModule", { value: true });
  SentinelConnector.SentinelIterator = void 0;
  const net_1 = require$$0$5;
  const utils_1 = requireUtils();
  const tls_1 = require$$1$3;
  const SentinelIterator_1 = requireSentinelIterator();
  SentinelConnector.SentinelIterator = SentinelIterator_1.default;
  const AbstractConnector_1 = requireAbstractConnector();
  const Redis_1 = requireRedis();
  const FailoverDetector_1 = requireFailoverDetector();
  const debug2 = (0, utils_1.Debug)("SentinelConnector");
  let SentinelConnector$1 = class SentinelConnector extends AbstractConnector_1.default {
    constructor(options) {
      super(options.disconnectTimeout);
      this.options = options;
      this.emitter = null;
      this.failoverDetector = null;
      if (!this.options.sentinels.length) {
        throw new Error("Requires at least one sentinel to connect to.");
      }
      if (!this.options.name) {
        throw new Error("Requires the name of master.");
      }
      this.sentinelIterator = new SentinelIterator_1.default(this.options.sentinels);
    }
    check(info2) {
      const roleMatches = !info2.role || this.options.role === info2.role;
      if (!roleMatches) {
        debug2("role invalid, expected %s, but got %s", this.options.role, info2.role);
        this.sentinelIterator.next();
        this.sentinelIterator.next();
        this.sentinelIterator.reset(true);
      }
      return roleMatches;
    }
    disconnect() {
      super.disconnect();
      if (this.failoverDetector) {
        this.failoverDetector.cleanup();
      }
    }
    connect(eventEmitter) {
      this.connecting = true;
      this.retryAttempts = 0;
      let lastError;
      const connectToNext = async () => {
        const endpoint = this.sentinelIterator.next();
        if (endpoint.done) {
          this.sentinelIterator.reset(false);
          const retryDelay = typeof this.options.sentinelRetryStrategy === "function" ? this.options.sentinelRetryStrategy(++this.retryAttempts) : null;
          let errorMsg = typeof retryDelay !== "number" ? "All sentinels are unreachable and retry is disabled." : `All sentinels are unreachable. Retrying from scratch after ${retryDelay}ms.`;
          if (lastError) {
            errorMsg += ` Last error: ${lastError.message}`;
          }
          debug2(errorMsg);
          const error = new Error(errorMsg);
          if (typeof retryDelay === "number") {
            eventEmitter("error", error);
            await new Promise((resolve) => setTimeout(resolve, retryDelay));
            return connectToNext();
          } else {
            throw error;
          }
        }
        let resolved = null;
        let err = null;
        try {
          resolved = await this.resolve(endpoint.value);
        } catch (error) {
          err = error;
        }
        if (!this.connecting) {
          throw new Error(utils_1.CONNECTION_CLOSED_ERROR_MSG);
        }
        const endpointAddress = endpoint.value.host + ":" + endpoint.value.port;
        if (resolved) {
          debug2("resolved: %s:%s from sentinel %s", resolved.host, resolved.port, endpointAddress);
          if (this.options.enableTLSForSentinelMode && this.options.tls) {
            Object.assign(resolved, this.options.tls);
            this.stream = (0, tls_1.connect)(resolved);
            this.stream.once("secureConnect", this.initFailoverDetector.bind(this));
          } else {
            this.stream = (0, net_1.createConnection)(resolved);
            this.stream.once("connect", this.initFailoverDetector.bind(this));
          }
          this.stream.once("error", (err2) => {
            this.firstError = err2;
          });
          return this.stream;
        } else {
          const errorMsg = err ? "failed to connect to sentinel " + endpointAddress + " because " + err.message : "connected to sentinel " + endpointAddress + " successfully, but got an invalid reply: " + resolved;
          debug2(errorMsg);
          eventEmitter("sentinelError", new Error(errorMsg));
          if (err) {
            lastError = err;
          }
          return connectToNext();
        }
      };
      return connectToNext();
    }
    async updateSentinels(client2) {
      if (!this.options.updateSentinels) {
        return;
      }
      const result = await client2.sentinel("sentinels", this.options.name);
      if (!Array.isArray(result)) {
        return;
      }
      result.map(utils_1.packObject).forEach((sentinel) => {
        const flags = sentinel.flags ? sentinel.flags.split(",") : [];
        if (flags.indexOf("disconnected") === -1 && sentinel.ip && sentinel.port) {
          const endpoint = this.sentinelNatResolve(addressResponseToAddress(sentinel));
          if (this.sentinelIterator.add(endpoint)) {
            debug2("adding sentinel %s:%s", endpoint.host, endpoint.port);
          }
        }
      });
      debug2("Updated internal sentinels: %s", this.sentinelIterator);
    }
    async resolveMaster(client2) {
      const result = await client2.sentinel("get-master-addr-by-name", this.options.name);
      await this.updateSentinels(client2);
      return this.sentinelNatResolve(Array.isArray(result) ? { host: result[0], port: Number(result[1]) } : null);
    }
    async resolveSlave(client2) {
      const result = await client2.sentinel("slaves", this.options.name);
      if (!Array.isArray(result)) {
        return null;
      }
      const availableSlaves = result.map(utils_1.packObject).filter((slave) => slave.flags && !slave.flags.match(/(disconnected|s_down|o_down)/));
      return this.sentinelNatResolve(selectPreferredSentinel(availableSlaves, this.options.preferredSlaves));
    }
    sentinelNatResolve(item) {
      if (!item || !this.options.natMap)
        return item;
      const key = `${item.host}:${item.port}`;
      let result = item;
      if (typeof this.options.natMap === "function") {
        result = this.options.natMap(key) || item;
      } else if (typeof this.options.natMap === "object") {
        result = this.options.natMap[key] || item;
      }
      return result;
    }
    connectToSentinel(endpoint, options) {
      const redis = new Redis_1.default({
        port: endpoint.port || 26379,
        host: endpoint.host,
        username: this.options.sentinelUsername || null,
        password: this.options.sentinelPassword || null,
        family: endpoint.family || // @ts-expect-error
        ("path" in this.options && this.options.path ? void 0 : (
          // @ts-expect-error
          this.options.family
        )),
        tls: this.options.sentinelTLS,
        retryStrategy: null,
        enableReadyCheck: false,
        connectTimeout: this.options.connectTimeout,
        commandTimeout: this.options.sentinelCommandTimeout,
        ...options
      });
      return redis;
    }
    async resolve(endpoint) {
      const client2 = this.connectToSentinel(endpoint);
      client2.on("error", noop);
      try {
        if (this.options.role === "slave") {
          return await this.resolveSlave(client2);
        } else {
          return await this.resolveMaster(client2);
        }
      } finally {
        client2.disconnect();
      }
    }
    async initFailoverDetector() {
      var _a;
      if (!this.options.failoverDetector) {
        return;
      }
      this.sentinelIterator.reset(true);
      const sentinels = [];
      while (sentinels.length < this.options.sentinelMaxConnections) {
        const { done, value } = this.sentinelIterator.next();
        if (done) {
          break;
        }
        const client2 = this.connectToSentinel(value, {
          lazyConnect: true,
          retryStrategy: this.options.sentinelReconnectStrategy
        });
        client2.on("reconnecting", () => {
          var _a2;
          (_a2 = this.emitter) === null || _a2 === void 0 ? void 0 : _a2.emit("sentinelReconnecting");
        });
        sentinels.push({ address: value, client: client2 });
      }
      this.sentinelIterator.reset(false);
      if (this.failoverDetector) {
        this.failoverDetector.cleanup();
      }
      this.failoverDetector = new FailoverDetector_1.FailoverDetector(this, sentinels);
      await this.failoverDetector.subscribe();
      (_a = this.emitter) === null || _a === void 0 ? void 0 : _a.emit("failoverSubscribed");
    }
  };
  SentinelConnector.default = SentinelConnector$1;
  function selectPreferredSentinel(availableSlaves, preferredSlaves) {
    if (availableSlaves.length === 0) {
      return null;
    }
    let selectedSlave;
    if (typeof preferredSlaves === "function") {
      selectedSlave = preferredSlaves(availableSlaves);
    } else if (preferredSlaves !== null && typeof preferredSlaves === "object") {
      const preferredSlavesArray = Array.isArray(preferredSlaves) ? preferredSlaves : [preferredSlaves];
      preferredSlavesArray.sort((a, b) => {
        if (!a.prio) {
          a.prio = 1;
        }
        if (!b.prio) {
          b.prio = 1;
        }
        if (a.prio < b.prio) {
          return -1;
        }
        if (a.prio > b.prio) {
          return 1;
        }
        return 0;
      });
      for (let p = 0; p < preferredSlavesArray.length; p++) {
        for (let a = 0; a < availableSlaves.length; a++) {
          const slave = availableSlaves[a];
          if (slave.ip === preferredSlavesArray[p].ip) {
            if (slave.port === preferredSlavesArray[p].port) {
              selectedSlave = slave;
              break;
            }
          }
        }
        if (selectedSlave) {
          break;
        }
      }
    }
    if (!selectedSlave) {
      selectedSlave = (0, utils_1.sample)(availableSlaves);
    }
    return addressResponseToAddress(selectedSlave);
  }
  function addressResponseToAddress(input) {
    return { host: input.ip, port: Number(input.port) };
  }
  function noop() {
  }
  return SentinelConnector;
}
var hasRequiredConnectors;
function requireConnectors() {
  if (hasRequiredConnectors) return connectors;
  hasRequiredConnectors = 1;
  Object.defineProperty(connectors, "__esModule", { value: true });
  connectors.SentinelConnector = connectors.StandaloneConnector = void 0;
  const StandaloneConnector_1 = requireStandaloneConnector();
  connectors.StandaloneConnector = StandaloneConnector_1.default;
  const SentinelConnector_1 = requireSentinelConnector();
  connectors.SentinelConnector = SentinelConnector_1.default;
  return connectors;
}
var event_handler = {};
var errors = {};
var MaxRetriesPerRequestError = {};
var hasRequiredMaxRetriesPerRequestError;
function requireMaxRetriesPerRequestError() {
  if (hasRequiredMaxRetriesPerRequestError) return MaxRetriesPerRequestError;
  hasRequiredMaxRetriesPerRequestError = 1;
  Object.defineProperty(MaxRetriesPerRequestError, "__esModule", { value: true });
  const redis_errors_1 = requireRedisErrors();
  let MaxRetriesPerRequestError$1 = class MaxRetriesPerRequestError extends redis_errors_1.AbortError {
    constructor(maxRetriesPerRequest) {
      const message = `Reached the max retries per request limit (which is ${maxRetriesPerRequest}). Refer to "maxRetriesPerRequest" option for details.`;
      super(message);
      Error.captureStackTrace(this, this.constructor);
    }
    get name() {
      return this.constructor.name;
    }
  };
  MaxRetriesPerRequestError.default = MaxRetriesPerRequestError$1;
  return MaxRetriesPerRequestError;
}
var hasRequiredErrors;
function requireErrors() {
  if (hasRequiredErrors) return errors;
  hasRequiredErrors = 1;
  Object.defineProperty(errors, "__esModule", { value: true });
  errors.MaxRetriesPerRequestError = void 0;
  const MaxRetriesPerRequestError_1 = requireMaxRetriesPerRequestError();
  errors.MaxRetriesPerRequestError = MaxRetriesPerRequestError_1.default;
  return errors;
}
var DataHandler = {};
var parser;
var hasRequiredParser;
function requireParser() {
  if (hasRequiredParser) return parser;
  hasRequiredParser = 1;
  const Buffer2 = require$$0$7.Buffer;
  const StringDecoder = require$$1$4.StringDecoder;
  const decoder = new StringDecoder();
  const errors2 = requireRedisErrors();
  const ReplyError = errors2.ReplyError;
  const ParserError = errors2.ParserError;
  var bufferPool = Buffer2.allocUnsafe(32 * 1024);
  var bufferOffset = 0;
  var interval = null;
  var counter = 0;
  var notDecreased = 0;
  function parseSimpleNumbers(parser2) {
    const length = parser2.buffer.length - 1;
    var offset = parser2.offset;
    var number = 0;
    var sign = 1;
    if (parser2.buffer[offset] === 45) {
      sign = -1;
      offset++;
    }
    while (offset < length) {
      const c1 = parser2.buffer[offset++];
      if (c1 === 13) {
        parser2.offset = offset + 1;
        return sign * number;
      }
      number = number * 10 + (c1 - 48);
    }
  }
  function parseStringNumbers(parser2) {
    const length = parser2.buffer.length - 1;
    var offset = parser2.offset;
    var number = 0;
    var res = "";
    if (parser2.buffer[offset] === 45) {
      res += "-";
      offset++;
    }
    while (offset < length) {
      var c1 = parser2.buffer[offset++];
      if (c1 === 13) {
        parser2.offset = offset + 1;
        if (number !== 0) {
          res += number;
        }
        return res;
      } else if (number > 429496728) {
        res += number * 10 + (c1 - 48);
        number = 0;
      } else if (c1 === 48 && number === 0) {
        res += 0;
      } else {
        number = number * 10 + (c1 - 48);
      }
    }
  }
  function parseSimpleString(parser2) {
    const start = parser2.offset;
    const buffer = parser2.buffer;
    const length = buffer.length - 1;
    var offset = start;
    while (offset < length) {
      if (buffer[offset++] === 13) {
        parser2.offset = offset + 1;
        if (parser2.optionReturnBuffers === true) {
          return parser2.buffer.slice(start, offset - 1);
        }
        return parser2.buffer.toString("utf8", start, offset - 1);
      }
    }
  }
  function parseLength(parser2) {
    const length = parser2.buffer.length - 1;
    var offset = parser2.offset;
    var number = 0;
    while (offset < length) {
      const c1 = parser2.buffer[offset++];
      if (c1 === 13) {
        parser2.offset = offset + 1;
        return number;
      }
      number = number * 10 + (c1 - 48);
    }
  }
  function parseInteger(parser2) {
    if (parser2.optionStringNumbers === true) {
      return parseStringNumbers(parser2);
    }
    return parseSimpleNumbers(parser2);
  }
  function parseBulkString(parser2) {
    const length = parseLength(parser2);
    if (length === void 0) {
      return;
    }
    if (length < 0) {
      return null;
    }
    const offset = parser2.offset + length;
    if (offset + 2 > parser2.buffer.length) {
      parser2.bigStrSize = offset + 2;
      parser2.totalChunkSize = parser2.buffer.length;
      parser2.bufferCache.push(parser2.buffer);
      return;
    }
    const start = parser2.offset;
    parser2.offset = offset + 2;
    if (parser2.optionReturnBuffers === true) {
      return parser2.buffer.slice(start, offset);
    }
    return parser2.buffer.toString("utf8", start, offset);
  }
  function parseError(parser2) {
    var string = parseSimpleString(parser2);
    if (string !== void 0) {
      if (parser2.optionReturnBuffers === true) {
        string = string.toString();
      }
      return new ReplyError(string);
    }
  }
  function handleError(parser2, type2) {
    const err = new ParserError(
      "Protocol error, got " + JSON.stringify(String.fromCharCode(type2)) + " as reply type byte",
      JSON.stringify(parser2.buffer),
      parser2.offset
    );
    parser2.buffer = null;
    parser2.returnFatalError(err);
  }
  function parseArray(parser2) {
    const length = parseLength(parser2);
    if (length === void 0) {
      return;
    }
    if (length < 0) {
      return null;
    }
    const responses = new Array(length);
    return parseArrayElements(parser2, responses, 0);
  }
  function pushArrayCache(parser2, array, pos) {
    parser2.arrayCache.push(array);
    parser2.arrayPos.push(pos);
  }
  function parseArrayChunks(parser2) {
    const tmp = parser2.arrayCache.pop();
    var pos = parser2.arrayPos.pop();
    if (parser2.arrayCache.length) {
      const res = parseArrayChunks(parser2);
      if (res === void 0) {
        pushArrayCache(parser2, tmp, pos);
        return;
      }
      tmp[pos++] = res;
    }
    return parseArrayElements(parser2, tmp, pos);
  }
  function parseArrayElements(parser2, responses, i) {
    const bufferLength = parser2.buffer.length;
    while (i < responses.length) {
      const offset = parser2.offset;
      if (parser2.offset >= bufferLength) {
        pushArrayCache(parser2, responses, i);
        return;
      }
      const response = parseType(parser2, parser2.buffer[parser2.offset++]);
      if (response === void 0) {
        if (!(parser2.arrayCache.length || parser2.bufferCache.length)) {
          parser2.offset = offset;
        }
        pushArrayCache(parser2, responses, i);
        return;
      }
      responses[i] = response;
      i++;
    }
    return responses;
  }
  function parseType(parser2, type2) {
    switch (type2) {
      case 36:
        return parseBulkString(parser2);
      case 43:
        return parseSimpleString(parser2);
      case 42:
        return parseArray(parser2);
      case 58:
        return parseInteger(parser2);
      case 45:
        return parseError(parser2);
      default:
        return handleError(parser2, type2);
    }
  }
  function decreaseBufferPool() {
    if (bufferPool.length > 50 * 1024) {
      if (counter === 1 || notDecreased > counter * 2) {
        const minSliceLen = Math.floor(bufferPool.length / 10);
        const sliceLength = minSliceLen < bufferOffset ? bufferOffset : minSliceLen;
        bufferOffset = 0;
        bufferPool = bufferPool.slice(sliceLength, bufferPool.length);
      } else {
        notDecreased++;
        counter--;
      }
    } else {
      clearInterval(interval);
      counter = 0;
      notDecreased = 0;
      interval = null;
    }
  }
  function resizeBuffer(length) {
    if (bufferPool.length < length + bufferOffset) {
      const multiplier = length > 1024 * 1024 * 75 ? 2 : 3;
      if (bufferOffset > 1024 * 1024 * 111) {
        bufferOffset = 1024 * 1024 * 50;
      }
      bufferPool = Buffer2.allocUnsafe(length * multiplier + bufferOffset);
      bufferOffset = 0;
      counter++;
      if (interval === null) {
        interval = setInterval(decreaseBufferPool, 50);
      }
    }
  }
  function concatBulkString(parser2) {
    const list = parser2.bufferCache;
    const oldOffset = parser2.offset;
    var chunks = list.length;
    var offset = parser2.bigStrSize - parser2.totalChunkSize;
    parser2.offset = offset;
    if (offset <= 2) {
      if (chunks === 2) {
        return list[0].toString("utf8", oldOffset, list[0].length + offset - 2);
      }
      chunks--;
      offset = list[list.length - 2].length + offset;
    }
    var res = decoder.write(list[0].slice(oldOffset));
    for (var i = 1; i < chunks - 1; i++) {
      res += decoder.write(list[i]);
    }
    res += decoder.end(list[i].slice(0, offset - 2));
    return res;
  }
  function concatBulkBuffer(parser2) {
    const list = parser2.bufferCache;
    const oldOffset = parser2.offset;
    const length = parser2.bigStrSize - oldOffset - 2;
    var chunks = list.length;
    var offset = parser2.bigStrSize - parser2.totalChunkSize;
    parser2.offset = offset;
    if (offset <= 2) {
      if (chunks === 2) {
        return list[0].slice(oldOffset, list[0].length + offset - 2);
      }
      chunks--;
      offset = list[list.length - 2].length + offset;
    }
    resizeBuffer(length);
    const start = bufferOffset;
    list[0].copy(bufferPool, start, oldOffset, list[0].length);
    bufferOffset += list[0].length - oldOffset;
    for (var i = 1; i < chunks - 1; i++) {
      list[i].copy(bufferPool, bufferOffset);
      bufferOffset += list[i].length;
    }
    list[i].copy(bufferPool, bufferOffset, 0, offset - 2);
    bufferOffset += offset - 2;
    return bufferPool.slice(start, bufferOffset);
  }
  class JavascriptRedisParser {
    /**
     * Javascript Redis Parser constructor
     * @param {{returnError: Function, returnReply: Function, returnFatalError?: Function, returnBuffers: boolean, stringNumbers: boolean }} options
     * @constructor
     */
    constructor(options) {
      if (!options) {
        throw new TypeError("Options are mandatory.");
      }
      if (typeof options.returnError !== "function" || typeof options.returnReply !== "function") {
        throw new TypeError("The returnReply and returnError options have to be functions.");
      }
      this.setReturnBuffers(!!options.returnBuffers);
      this.setStringNumbers(!!options.stringNumbers);
      this.returnError = options.returnError;
      this.returnFatalError = options.returnFatalError || options.returnError;
      this.returnReply = options.returnReply;
      this.reset();
    }
    /**
     * Reset the parser values to the initial state
     *
     * @returns {undefined}
     */
    reset() {
      this.offset = 0;
      this.buffer = null;
      this.bigStrSize = 0;
      this.totalChunkSize = 0;
      this.bufferCache = [];
      this.arrayCache = [];
      this.arrayPos = [];
    }
    /**
     * Set the returnBuffers option
     *
     * @param {boolean} returnBuffers
     * @returns {undefined}
     */
    setReturnBuffers(returnBuffers) {
      if (typeof returnBuffers !== "boolean") {
        throw new TypeError("The returnBuffers argument has to be a boolean");
      }
      this.optionReturnBuffers = returnBuffers;
    }
    /**
     * Set the stringNumbers option
     *
     * @param {boolean} stringNumbers
     * @returns {undefined}
     */
    setStringNumbers(stringNumbers) {
      if (typeof stringNumbers !== "boolean") {
        throw new TypeError("The stringNumbers argument has to be a boolean");
      }
      this.optionStringNumbers = stringNumbers;
    }
    /**
     * Parse the redis buffer
     * @param {Buffer} buffer
     * @returns {undefined}
     */
    execute(buffer) {
      if (this.buffer === null) {
        this.buffer = buffer;
        this.offset = 0;
      } else if (this.bigStrSize === 0) {
        const oldLength = this.buffer.length;
        const remainingLength = oldLength - this.offset;
        const newBuffer = Buffer2.allocUnsafe(remainingLength + buffer.length);
        this.buffer.copy(newBuffer, 0, this.offset, oldLength);
        buffer.copy(newBuffer, remainingLength, 0, buffer.length);
        this.buffer = newBuffer;
        this.offset = 0;
        if (this.arrayCache.length) {
          const arr = parseArrayChunks(this);
          if (arr === void 0) {
            return;
          }
          this.returnReply(arr);
        }
      } else if (this.totalChunkSize + buffer.length >= this.bigStrSize) {
        this.bufferCache.push(buffer);
        var tmp = this.optionReturnBuffers ? concatBulkBuffer(this) : concatBulkString(this);
        this.bigStrSize = 0;
        this.bufferCache = [];
        this.buffer = buffer;
        if (this.arrayCache.length) {
          this.arrayCache[0][this.arrayPos[0]++] = tmp;
          tmp = parseArrayChunks(this);
          if (tmp === void 0) {
            return;
          }
        }
        this.returnReply(tmp);
      } else {
        this.bufferCache.push(buffer);
        this.totalChunkSize += buffer.length;
        return;
      }
      while (this.offset < this.buffer.length) {
        const offset = this.offset;
        const type2 = this.buffer[this.offset++];
        const response = parseType(this, type2);
        if (response === void 0) {
          if (!(this.arrayCache.length || this.bufferCache.length)) {
            this.offset = offset;
          }
          return;
        }
        if (type2 === 45) {
          this.returnError(response);
        } else {
          this.returnReply(response);
        }
      }
      this.buffer = null;
    }
  }
  parser = JavascriptRedisParser;
  return parser;
}
var redisParser;
var hasRequiredRedisParser;
function requireRedisParser() {
  if (hasRequiredRedisParser) return redisParser;
  hasRequiredRedisParser = 1;
  redisParser = requireParser();
  return redisParser;
}
var SubscriptionSet = {};
var hasRequiredSubscriptionSet;
function requireSubscriptionSet() {
  if (hasRequiredSubscriptionSet) return SubscriptionSet;
  hasRequiredSubscriptionSet = 1;
  Object.defineProperty(SubscriptionSet, "__esModule", { value: true });
  let SubscriptionSet$1 = class SubscriptionSet {
    constructor() {
      this.set = {
        subscribe: {},
        psubscribe: {},
        ssubscribe: {}
      };
    }
    add(set2, channel) {
      this.set[mapSet(set2)][channel] = true;
    }
    del(set2, channel) {
      delete this.set[mapSet(set2)][channel];
    }
    channels(set2) {
      return Object.keys(this.set[mapSet(set2)]);
    }
    isEmpty() {
      return this.channels("subscribe").length === 0 && this.channels("psubscribe").length === 0 && this.channels("ssubscribe").length === 0;
    }
  };
  SubscriptionSet.default = SubscriptionSet$1;
  function mapSet(set2) {
    if (set2 === "unsubscribe") {
      return "subscribe";
    }
    if (set2 === "punsubscribe") {
      return "psubscribe";
    }
    if (set2 === "sunsubscribe") {
      return "ssubscribe";
    }
    return set2;
  }
  return SubscriptionSet;
}
var hasRequiredDataHandler;
function requireDataHandler() {
  if (hasRequiredDataHandler) return DataHandler;
  hasRequiredDataHandler = 1;
  Object.defineProperty(DataHandler, "__esModule", { value: true });
  const Command_1 = requireCommand();
  const utils_1 = requireUtils();
  const RedisParser = requireRedisParser();
  const SubscriptionSet_1 = requireSubscriptionSet();
  const debug2 = (0, utils_1.Debug)("dataHandler");
  let DataHandler$1 = class DataHandler {
    constructor(redis, parserOptions) {
      this.redis = redis;
      const parser2 = new RedisParser({
        stringNumbers: parserOptions.stringNumbers,
        returnBuffers: true,
        returnError: (err) => {
          this.returnError(err);
        },
        returnFatalError: (err) => {
          this.returnFatalError(err);
        },
        returnReply: (reply) => {
          this.returnReply(reply);
        }
      });
      redis.stream.prependListener("data", (data) => {
        parser2.execute(data);
      });
      redis.stream.resume();
    }
    returnFatalError(err) {
      err.message += ". Please report this.";
      this.redis.recoverFromFatalError(err, err, { offlineQueue: false });
    }
    returnError(err) {
      const item = this.shiftCommand(err);
      if (!item) {
        return;
      }
      err.command = {
        name: item.command.name,
        args: item.command.args
      };
      this.redis.handleReconnection(err, item);
    }
    returnReply(reply) {
      if (this.handleMonitorReply(reply)) {
        return;
      }
      if (this.handleSubscriberReply(reply)) {
        return;
      }
      const item = this.shiftCommand(reply);
      if (!item) {
        return;
      }
      if (Command_1.default.checkFlag("ENTER_SUBSCRIBER_MODE", item.command.name)) {
        this.redis.condition.subscriber = new SubscriptionSet_1.default();
        this.redis.condition.subscriber.add(item.command.name, reply[1].toString());
        if (!fillSubCommand(item.command, reply[2])) {
          this.redis.commandQueue.unshift(item);
        }
      } else if (Command_1.default.checkFlag("EXIT_SUBSCRIBER_MODE", item.command.name)) {
        if (!fillUnsubCommand(item.command, reply[2])) {
          this.redis.commandQueue.unshift(item);
        }
      } else {
        item.command.resolve(reply);
      }
    }
    handleSubscriberReply(reply) {
      if (!this.redis.condition.subscriber) {
        return false;
      }
      const replyType = Array.isArray(reply) ? reply[0].toString() : null;
      debug2('receive reply "%s" in subscriber mode', replyType);
      switch (replyType) {
        case "message":
          if (this.redis.listeners("message").length > 0) {
            this.redis.emit("message", reply[1].toString(), reply[2] ? reply[2].toString() : "");
          }
          this.redis.emit("messageBuffer", reply[1], reply[2]);
          break;
        case "pmessage": {
          const pattern = reply[1].toString();
          if (this.redis.listeners("pmessage").length > 0) {
            this.redis.emit("pmessage", pattern, reply[2].toString(), reply[3].toString());
          }
          this.redis.emit("pmessageBuffer", pattern, reply[2], reply[3]);
          break;
        }
        case "smessage": {
          if (this.redis.listeners("smessage").length > 0) {
            this.redis.emit("smessage", reply[1].toString(), reply[2] ? reply[2].toString() : "");
          }
          this.redis.emit("smessageBuffer", reply[1], reply[2]);
          break;
        }
        case "ssubscribe":
        case "subscribe":
        case "psubscribe": {
          const channel = reply[1].toString();
          this.redis.condition.subscriber.add(replyType, channel);
          const item = this.shiftCommand(reply);
          if (!item) {
            return;
          }
          if (!fillSubCommand(item.command, reply[2])) {
            this.redis.commandQueue.unshift(item);
          }
          break;
        }
        case "sunsubscribe":
        case "unsubscribe":
        case "punsubscribe": {
          const channel = reply[1] ? reply[1].toString() : null;
          if (channel) {
            this.redis.condition.subscriber.del(replyType, channel);
          }
          const count = reply[2];
          if (Number(count) === 0) {
            this.redis.condition.subscriber = false;
          }
          const item = this.shiftCommand(reply);
          if (!item) {
            return;
          }
          if (!fillUnsubCommand(item.command, count)) {
            this.redis.commandQueue.unshift(item);
          }
          break;
        }
        default: {
          const item = this.shiftCommand(reply);
          if (!item) {
            return;
          }
          item.command.resolve(reply);
        }
      }
      return true;
    }
    handleMonitorReply(reply) {
      if (this.redis.status !== "monitoring") {
        return false;
      }
      const replyStr = reply.toString();
      if (replyStr === "OK") {
        return false;
      }
      const len = replyStr.indexOf(" ");
      const timestamp = replyStr.slice(0, len);
      const argIndex = replyStr.indexOf('"');
      const args = replyStr.slice(argIndex + 1, -1).split('" "').map((elem) => elem.replace(/\\"/g, '"'));
      const dbAndSource = replyStr.slice(len + 2, argIndex - 2).split(" ");
      this.redis.emit("monitor", timestamp, args, dbAndSource[1], dbAndSource[0]);
      return true;
    }
    shiftCommand(reply) {
      const item = this.redis.commandQueue.shift();
      if (!item) {
        const message = "Command queue state error. If you can reproduce this, please report it.";
        const error = new Error(message + (reply instanceof Error ? ` Last error: ${reply.message}` : ` Last reply: ${reply.toString()}`));
        this.redis.emit("error", error);
        return null;
      }
      return item;
    }
  };
  DataHandler.default = DataHandler$1;
  const remainingRepliesMap = /* @__PURE__ */ new WeakMap();
  function fillSubCommand(command2, count) {
    let remainingReplies = remainingRepliesMap.has(command2) ? remainingRepliesMap.get(command2) : command2.args.length;
    remainingReplies -= 1;
    if (remainingReplies <= 0) {
      command2.resolve(count);
      remainingRepliesMap.delete(command2);
      return true;
    }
    remainingRepliesMap.set(command2, remainingReplies);
    return false;
  }
  function fillUnsubCommand(command2, count) {
    let remainingReplies = remainingRepliesMap.has(command2) ? remainingRepliesMap.get(command2) : command2.args.length;
    if (remainingReplies === 0) {
      if (Number(count) === 0) {
        remainingRepliesMap.delete(command2);
        command2.resolve(count);
        return true;
      }
      return false;
    }
    remainingReplies -= 1;
    if (remainingReplies <= 0) {
      command2.resolve(count);
      return true;
    }
    remainingRepliesMap.set(command2, remainingReplies);
    return false;
  }
  return DataHandler;
}
var hasRequiredEvent_handler;
function requireEvent_handler() {
  if (hasRequiredEvent_handler) return event_handler;
  hasRequiredEvent_handler = 1;
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.readyHandler = exports.errorHandler = exports.closeHandler = exports.connectHandler = void 0;
    const redis_errors_1 = requireRedisErrors();
    const Command_1 = requireCommand();
    const errors_1 = requireErrors();
    const utils_1 = requireUtils();
    const DataHandler_1 = requireDataHandler();
    const debug2 = (0, utils_1.Debug)("connection");
    function connectHandler(self2) {
      return function() {
        self2.setStatus("connect");
        self2.resetCommandQueue();
        let flushed = false;
        const { connectionEpoch } = self2;
        if (self2.condition.auth) {
          self2.auth(self2.condition.auth, function(err) {
            if (connectionEpoch !== self2.connectionEpoch) {
              return;
            }
            if (err) {
              if (err.message.indexOf("no password is set") !== -1) {
                console.warn("[WARN] Redis server does not require a password, but a password was supplied.");
              } else if (err.message.indexOf("without any password configured for the default user") !== -1) {
                console.warn("[WARN] This Redis server's `default` user does not require a password, but a password was supplied");
              } else if (err.message.indexOf("wrong number of arguments for 'auth' command") !== -1) {
                console.warn(`[ERROR] The server returned "wrong number of arguments for 'auth' command". You are probably passing both username and password to Redis version 5 or below. You should only pass the 'password' option for Redis version 5 and under.`);
              } else {
                flushed = true;
                self2.recoverFromFatalError(err, err);
              }
            }
          });
        }
        if (self2.condition.select) {
          self2.select(self2.condition.select).catch((err) => {
            self2.silentEmit("error", err);
          });
        }
        if (!self2.options.enableReadyCheck) {
          exports.readyHandler(self2)();
        }
        new DataHandler_1.default(self2, {
          stringNumbers: self2.options.stringNumbers
        });
        if (self2.options.enableReadyCheck) {
          self2._readyCheck(function(err, info2) {
            if (connectionEpoch !== self2.connectionEpoch) {
              return;
            }
            if (err) {
              if (!flushed) {
                self2.recoverFromFatalError(new Error("Ready check failed: " + err.message), err);
              }
            } else {
              if (self2.connector.check(info2)) {
                exports.readyHandler(self2)();
              } else {
                self2.disconnect(true);
              }
            }
          });
        }
      };
    }
    exports.connectHandler = connectHandler;
    function abortError(command2) {
      const err = new redis_errors_1.AbortError("Command aborted due to connection close");
      err.command = {
        name: command2.name,
        args: command2.args
      };
      return err;
    }
    function abortIncompletePipelines(commandQueue) {
      var _a;
      let expectedIndex = 0;
      for (let i = 0; i < commandQueue.length; ) {
        const command2 = (_a = commandQueue.peekAt(i)) === null || _a === void 0 ? void 0 : _a.command;
        const pipelineIndex = command2.pipelineIndex;
        if (pipelineIndex === void 0 || pipelineIndex === 0) {
          expectedIndex = 0;
        }
        if (pipelineIndex !== void 0 && pipelineIndex !== expectedIndex++) {
          commandQueue.remove(i, 1);
          command2.reject(abortError(command2));
          continue;
        }
        i++;
      }
    }
    function abortTransactionFragments(commandQueue) {
      var _a;
      for (let i = 0; i < commandQueue.length; ) {
        const command2 = (_a = commandQueue.peekAt(i)) === null || _a === void 0 ? void 0 : _a.command;
        if (command2.name === "multi") {
          break;
        }
        if (command2.name === "exec") {
          commandQueue.remove(i, 1);
          command2.reject(abortError(command2));
          break;
        }
        if (command2.inTransaction) {
          commandQueue.remove(i, 1);
          command2.reject(abortError(command2));
        } else {
          i++;
        }
      }
    }
    function closeHandler(self2) {
      return function() {
        const prevStatus = self2.status;
        self2.setStatus("close");
        if (self2.commandQueue.length) {
          abortIncompletePipelines(self2.commandQueue);
        }
        if (self2.offlineQueue.length) {
          abortTransactionFragments(self2.offlineQueue);
        }
        if (prevStatus === "ready") {
          if (!self2.prevCondition) {
            self2.prevCondition = self2.condition;
          }
          if (self2.commandQueue.length) {
            self2.prevCommandQueue = self2.commandQueue;
          }
        }
        if (self2.manuallyClosing) {
          self2.manuallyClosing = false;
          debug2("skip reconnecting since the connection is manually closed.");
          return close();
        }
        if (typeof self2.options.retryStrategy !== "function") {
          debug2("skip reconnecting because `retryStrategy` is not a function");
          return close();
        }
        const retryDelay = self2.options.retryStrategy(++self2.retryAttempts);
        if (typeof retryDelay !== "number") {
          debug2("skip reconnecting because `retryStrategy` doesn't return a number");
          return close();
        }
        debug2("reconnect in %sms", retryDelay);
        self2.setStatus("reconnecting", retryDelay);
        self2.reconnectTimeout = setTimeout(function() {
          self2.reconnectTimeout = null;
          self2.connect().catch(utils_1.noop);
        }, retryDelay);
        const { maxRetriesPerRequest } = self2.options;
        if (typeof maxRetriesPerRequest === "number") {
          if (maxRetriesPerRequest < 0) {
            debug2("maxRetriesPerRequest is negative, ignoring...");
          } else {
            const remainder = self2.retryAttempts % (maxRetriesPerRequest + 1);
            if (remainder === 0) {
              debug2("reach maxRetriesPerRequest limitation, flushing command queue...");
              self2.flushQueue(new errors_1.MaxRetriesPerRequestError(maxRetriesPerRequest));
            }
          }
        }
      };
      function close() {
        self2.setStatus("end");
        self2.flushQueue(new Error(utils_1.CONNECTION_CLOSED_ERROR_MSG));
      }
    }
    exports.closeHandler = closeHandler;
    function errorHandler(self2) {
      return function(error) {
        debug2("error: %s", error);
        self2.silentEmit("error", error);
      };
    }
    exports.errorHandler = errorHandler;
    function readyHandler(self2) {
      return function() {
        self2.setStatus("ready");
        self2.retryAttempts = 0;
        if (self2.options.monitor) {
          self2.call("monitor").then(() => self2.setStatus("monitoring"), (error) => self2.emit("error", error));
          const { sendCommand } = self2;
          self2.sendCommand = function(command2) {
            if (Command_1.default.checkFlag("VALID_IN_MONITOR_MODE", command2.name)) {
              return sendCommand.call(self2, command2);
            }
            command2.reject(new Error("Connection is in monitoring mode, can't process commands."));
            return command2.promise;
          };
          self2.once("close", function() {
            delete self2.sendCommand;
          });
          return;
        }
        const finalSelect = self2.prevCondition ? self2.prevCondition.select : self2.condition.select;
        if (self2.options.connectionName) {
          debug2("set the connection name [%s]", self2.options.connectionName);
          self2.client("setname", self2.options.connectionName).catch(utils_1.noop);
        }
        if (self2.options.readOnly) {
          debug2("set the connection to readonly mode");
          self2.readonly().catch(utils_1.noop);
        }
        if (self2.prevCondition) {
          const condition = self2.prevCondition;
          self2.prevCondition = null;
          if (condition.subscriber && self2.options.autoResubscribe) {
            if (self2.condition.select !== finalSelect) {
              debug2("connect to db [%d]", finalSelect);
              self2.select(finalSelect);
            }
            const subscribeChannels = condition.subscriber.channels("subscribe");
            if (subscribeChannels.length) {
              debug2("subscribe %d channels", subscribeChannels.length);
              self2.subscribe(subscribeChannels);
            }
            const psubscribeChannels = condition.subscriber.channels("psubscribe");
            if (psubscribeChannels.length) {
              debug2("psubscribe %d channels", psubscribeChannels.length);
              self2.psubscribe(psubscribeChannels);
            }
            const ssubscribeChannels = condition.subscriber.channels("ssubscribe");
            if (ssubscribeChannels.length) {
              debug2("ssubscribe %d channels", ssubscribeChannels.length);
              self2.ssubscribe(ssubscribeChannels);
            }
          }
        }
        if (self2.prevCommandQueue) {
          if (self2.options.autoResendUnfulfilledCommands) {
            debug2("resend %d unfulfilled commands", self2.prevCommandQueue.length);
            while (self2.prevCommandQueue.length > 0) {
              const item = self2.prevCommandQueue.shift();
              if (item.select !== self2.condition.select && item.command.name !== "select") {
                self2.select(item.select);
              }
              self2.sendCommand(item.command, item.stream);
            }
          } else {
            self2.prevCommandQueue = null;
          }
        }
        if (self2.offlineQueue.length) {
          debug2("send %d commands in offline queue", self2.offlineQueue.length);
          const offlineQueue = self2.offlineQueue;
          self2.resetOfflineQueue();
          while (offlineQueue.length > 0) {
            const item = offlineQueue.shift();
            if (item.select !== self2.condition.select && item.command.name !== "select") {
              self2.select(item.select);
            }
            self2.sendCommand(item.command, item.stream);
          }
        }
        if (self2.condition.select !== finalSelect) {
          debug2("connect to db [%d]", finalSelect);
          self2.select(finalSelect);
        }
      };
    }
    exports.readyHandler = readyHandler;
  })(event_handler);
  return event_handler;
}
var RedisOptions = {};
var hasRequiredRedisOptions;
function requireRedisOptions() {
  if (hasRequiredRedisOptions) return RedisOptions;
  hasRequiredRedisOptions = 1;
  Object.defineProperty(RedisOptions, "__esModule", { value: true });
  RedisOptions.DEFAULT_REDIS_OPTIONS = void 0;
  RedisOptions.DEFAULT_REDIS_OPTIONS = {
    // Connection
    port: 6379,
    host: "localhost",
    family: 4,
    connectTimeout: 1e4,
    disconnectTimeout: 2e3,
    retryStrategy: function(times) {
      return Math.min(times * 50, 2e3);
    },
    keepAlive: 0,
    noDelay: true,
    connectionName: null,
    // Sentinel
    sentinels: null,
    name: null,
    role: "master",
    sentinelRetryStrategy: function(times) {
      return Math.min(times * 10, 1e3);
    },
    sentinelReconnectStrategy: function() {
      return 6e4;
    },
    natMap: null,
    enableTLSForSentinelMode: false,
    updateSentinels: true,
    failoverDetector: false,
    // Status
    username: null,
    password: null,
    db: 0,
    // Others
    enableOfflineQueue: true,
    enableReadyCheck: true,
    autoResubscribe: true,
    autoResendUnfulfilledCommands: true,
    lazyConnect: false,
    keyPrefix: "",
    reconnectOnError: null,
    readOnly: false,
    stringNumbers: false,
    maxRetriesPerRequest: 20,
    maxLoadingRetryTime: 1e4,
    enableAutoPipelining: false,
    autoPipeliningIgnoredCommands: [],
    sentinelMaxConnections: 10
  };
  return RedisOptions;
}
var hasRequiredRedis;
function requireRedis() {
  if (hasRequiredRedis) return Redis;
  hasRequiredRedis = 1;
  Object.defineProperty(Redis, "__esModule", { value: true });
  const commands_1 = requireBuilt$2();
  const events_1 = require$$0$6;
  const standard_as_callback_1 = requireBuilt$1();
  const cluster_1 = requireCluster();
  const Command_1 = requireCommand();
  const connectors_1 = requireConnectors();
  const SentinelConnector_1 = requireSentinelConnector();
  const eventHandler = requireEvent_handler();
  const RedisOptions_1 = requireRedisOptions();
  const ScanStream_1 = requireScanStream();
  const transaction_1 = requireTransaction();
  const utils_1 = requireUtils();
  const applyMixin_1 = requireApplyMixin();
  const Commander_1 = requireCommander();
  const lodash_1 = requireLodash();
  const Deque = requireDenque();
  const debug2 = (0, utils_1.Debug)("redis");
  let Redis$1 = class Redis2 extends Commander_1.default {
    constructor(arg1, arg2, arg3) {
      super();
      this.status = "wait";
      this.isCluster = false;
      this.reconnectTimeout = null;
      this.connectionEpoch = 0;
      this.retryAttempts = 0;
      this.manuallyClosing = false;
      this._autoPipelines = /* @__PURE__ */ new Map();
      this._runningAutoPipelines = /* @__PURE__ */ new Set();
      this.parseOptions(arg1, arg2, arg3);
      events_1.EventEmitter.call(this);
      this.resetCommandQueue();
      this.resetOfflineQueue();
      if (this.options.Connector) {
        this.connector = new this.options.Connector(this.options);
      } else if (this.options.sentinels) {
        const sentinelConnector = new SentinelConnector_1.default(this.options);
        sentinelConnector.emitter = this;
        this.connector = sentinelConnector;
      } else {
        this.connector = new connectors_1.StandaloneConnector(this.options);
      }
      if (this.options.scripts) {
        Object.entries(this.options.scripts).forEach(([name, definition]) => {
          this.defineCommand(name, definition);
        });
      }
      if (this.options.lazyConnect) {
        this.setStatus("wait");
      } else {
        this.connect().catch(lodash_1.noop);
      }
    }
    /**
     * Create a Redis instance.
     * This is the same as `new Redis()` but is included for compatibility with node-redis.
     */
    static createClient(...args) {
      return new Redis2(...args);
    }
    get autoPipelineQueueSize() {
      let queued = 0;
      for (const pipeline of this._autoPipelines.values()) {
        queued += pipeline.length;
      }
      return queued;
    }
    /**
     * Create a connection to Redis.
     * This method will be invoked automatically when creating a new Redis instance
     * unless `lazyConnect: true` is passed.
     *
     * When calling this method manually, a Promise is returned, which will
     * be resolved when the connection status is ready. The promise can reject
     * if the connection fails, times out, or if Redis is already connecting/connected.
     */
    connect(callback) {
      const promise = new Promise((resolve, reject) => {
        if (this.status === "connecting" || this.status === "connect" || this.status === "ready") {
          reject(new Error("Redis is already connecting/connected"));
          return;
        }
        this.connectionEpoch += 1;
        this.setStatus("connecting");
        const { options } = this;
        this.condition = {
          select: options.db,
          auth: options.username ? [options.username, options.password] : options.password,
          subscriber: false
        };
        const _this = this;
        (0, standard_as_callback_1.default)(this.connector.connect(function(type2, err) {
          _this.silentEmit(type2, err);
        }), function(err, stream) {
          if (err) {
            _this.flushQueue(err);
            _this.silentEmit("error", err);
            reject(err);
            _this.setStatus("end");
            return;
          }
          let CONNECT_EVENT = options.tls ? "secureConnect" : "connect";
          if ("sentinels" in options && options.sentinels && !options.enableTLSForSentinelMode) {
            CONNECT_EVENT = "connect";
          }
          _this.stream = stream;
          if (options.noDelay) {
            stream.setNoDelay(true);
          }
          if (typeof options.keepAlive === "number") {
            if (stream.connecting) {
              stream.once(CONNECT_EVENT, () => {
                stream.setKeepAlive(true, options.keepAlive);
              });
            } else {
              stream.setKeepAlive(true, options.keepAlive);
            }
          }
          if (stream.connecting) {
            stream.once(CONNECT_EVENT, eventHandler.connectHandler(_this));
            if (options.connectTimeout) {
              let connectTimeoutCleared = false;
              stream.setTimeout(options.connectTimeout, function() {
                if (connectTimeoutCleared) {
                  return;
                }
                stream.setTimeout(0);
                stream.destroy();
                const err2 = new Error("connect ETIMEDOUT");
                err2.errorno = "ETIMEDOUT";
                err2.code = "ETIMEDOUT";
                err2.syscall = "connect";
                eventHandler.errorHandler(_this)(err2);
              });
              stream.once(CONNECT_EVENT, function() {
                connectTimeoutCleared = true;
                stream.setTimeout(0);
              });
            }
          } else if (stream.destroyed) {
            const firstError = _this.connector.firstError;
            if (firstError) {
              process.nextTick(() => {
                eventHandler.errorHandler(_this)(firstError);
              });
            }
            process.nextTick(eventHandler.closeHandler(_this));
          } else {
            process.nextTick(eventHandler.connectHandler(_this));
          }
          if (!stream.destroyed) {
            stream.once("error", eventHandler.errorHandler(_this));
            stream.once("close", eventHandler.closeHandler(_this));
          }
          const connectionReadyHandler = function() {
            _this.removeListener("close", connectionCloseHandler);
            resolve();
          };
          var connectionCloseHandler = function() {
            _this.removeListener("ready", connectionReadyHandler);
            reject(new Error(utils_1.CONNECTION_CLOSED_ERROR_MSG));
          };
          _this.once("ready", connectionReadyHandler);
          _this.once("close", connectionCloseHandler);
        });
      });
      return (0, standard_as_callback_1.default)(promise, callback);
    }
    /**
     * Disconnect from Redis.
     *
     * This method closes the connection immediately,
     * and may lose some pending replies that haven't written to client.
     * If you want to wait for the pending replies, use Redis#quit instead.
     */
    disconnect(reconnect = false) {
      if (!reconnect) {
        this.manuallyClosing = true;
      }
      if (this.reconnectTimeout && !reconnect) {
        clearTimeout(this.reconnectTimeout);
        this.reconnectTimeout = null;
      }
      if (this.status === "wait") {
        eventHandler.closeHandler(this)();
      } else {
        this.connector.disconnect();
      }
    }
    /**
     * Disconnect from Redis.
     *
     * @deprecated
     */
    end() {
      this.disconnect();
    }
    /**
     * Create a new instance with the same options as the current one.
     *
     * @example
     * ```js
     * var redis = new Redis(6380);
     * var anotherRedis = redis.duplicate();
     * ```
     */
    duplicate(override) {
      return new Redis2({ ...this.options, ...override });
    }
    /**
     * Mode of the connection.
     *
     * One of `"normal"`, `"subscriber"`, or `"monitor"`. When the connection is
     * not in `"normal"` mode, certain commands are not allowed.
     */
    get mode() {
      var _a;
      return this.options.monitor ? "monitor" : ((_a = this.condition) === null || _a === void 0 ? void 0 : _a.subscriber) ? "subscriber" : "normal";
    }
    /**
     * Listen for all requests received by the server in real time.
     *
     * This command will create a new connection to Redis and send a
     * MONITOR command via the new connection in order to avoid disturbing
     * the current connection.
     *
     * @param callback The callback function. If omit, a promise will be returned.
     * @example
     * ```js
     * var redis = new Redis();
     * redis.monitor(function (err, monitor) {
     *   // Entering monitoring mode.
     *   monitor.on('monitor', function (time, args, source, database) {
     *     console.log(time + ": " + util.inspect(args));
     *   });
     * });
     *
     * // supports promise as well as other commands
     * redis.monitor().then(function (monitor) {
     *   monitor.on('monitor', function (time, args, source, database) {
     *     console.log(time + ": " + util.inspect(args));
     *   });
     * });
     * ```
     */
    monitor(callback) {
      const monitorInstance = this.duplicate({
        monitor: true,
        lazyConnect: false
      });
      return (0, standard_as_callback_1.default)(new Promise(function(resolve, reject) {
        monitorInstance.once("error", reject);
        monitorInstance.once("monitoring", function() {
          resolve(monitorInstance);
        });
      }), callback);
    }
    /**
     * Send a command to Redis
     *
     * This method is used internally and in most cases you should not
     * use it directly. If you need to send a command that is not supported
     * by the library, you can use the `call` method:
     *
     * ```js
     * const redis = new Redis();
     *
     * redis.call('set', 'foo', 'bar');
     * // or
     * redis.call(['set', 'foo', 'bar']);
     * ```
     *
     * @ignore
     */
    sendCommand(command2, stream) {
      var _a, _b;
      if (this.status === "wait") {
        this.connect().catch(lodash_1.noop);
      }
      if (this.status === "end") {
        command2.reject(new Error(utils_1.CONNECTION_CLOSED_ERROR_MSG));
        return command2.promise;
      }
      if (((_a = this.condition) === null || _a === void 0 ? void 0 : _a.subscriber) && !Command_1.default.checkFlag("VALID_IN_SUBSCRIBER_MODE", command2.name)) {
        command2.reject(new Error("Connection in subscriber mode, only subscriber commands may be used"));
        return command2.promise;
      }
      if (typeof this.options.commandTimeout === "number") {
        command2.setTimeout(this.options.commandTimeout);
      }
      let writable = this.status === "ready" || !stream && this.status === "connect" && (0, commands_1.exists)(command2.name) && (0, commands_1.hasFlag)(command2.name, "loading");
      if (!this.stream) {
        writable = false;
      } else if (!this.stream.writable) {
        writable = false;
      } else if (this.stream._writableState && this.stream._writableState.ended) {
        writable = false;
      }
      if (!writable) {
        if (!this.options.enableOfflineQueue) {
          command2.reject(new Error("Stream isn't writeable and enableOfflineQueue options is false"));
          return command2.promise;
        }
        if (command2.name === "quit" && this.offlineQueue.length === 0) {
          this.disconnect();
          command2.resolve(Buffer.from("OK"));
          return command2.promise;
        }
        if (debug2.enabled) {
          debug2("queue command[%s]: %d -> %s(%o)", this._getDescription(), this.condition.select, command2.name, command2.args);
        }
        this.offlineQueue.push({
          command: command2,
          stream,
          select: this.condition.select
        });
      } else {
        if (debug2.enabled) {
          debug2("write command[%s]: %d -> %s(%o)", this._getDescription(), (_b = this.condition) === null || _b === void 0 ? void 0 : _b.select, command2.name, command2.args);
        }
        if (stream) {
          if ("isPipeline" in stream && stream.isPipeline) {
            stream.write(command2.toWritable(stream.destination.redis.stream));
          } else {
            stream.write(command2.toWritable(stream));
          }
        } else {
          this.stream.write(command2.toWritable(this.stream));
        }
        this.commandQueue.push({
          command: command2,
          stream,
          select: this.condition.select
        });
        if (Command_1.default.checkFlag("WILL_DISCONNECT", command2.name)) {
          this.manuallyClosing = true;
        }
        if (this.options.socketTimeout !== void 0 && this.socketTimeoutTimer === void 0) {
          this.setSocketTimeout();
        }
      }
      if (command2.name === "select" && (0, utils_1.isInt)(command2.args[0])) {
        const db = parseInt(command2.args[0], 10);
        if (this.condition.select !== db) {
          this.condition.select = db;
          this.emit("select", db);
          debug2("switch to db [%d]", this.condition.select);
        }
      }
      return command2.promise;
    }
    setSocketTimeout() {
      this.socketTimeoutTimer = setTimeout(() => {
        this.stream.destroy(new Error(`Socket timeout. Expecting data, but didn't receive any in ${this.options.socketTimeout}ms.`));
        this.socketTimeoutTimer = void 0;
      }, this.options.socketTimeout);
      this.stream.once("data", () => {
        clearTimeout(this.socketTimeoutTimer);
        this.socketTimeoutTimer = void 0;
        if (this.commandQueue.length === 0)
          return;
        this.setSocketTimeout();
      });
    }
    scanStream(options) {
      return this.createScanStream("scan", { options });
    }
    scanBufferStream(options) {
      return this.createScanStream("scanBuffer", { options });
    }
    sscanStream(key, options) {
      return this.createScanStream("sscan", { key, options });
    }
    sscanBufferStream(key, options) {
      return this.createScanStream("sscanBuffer", { key, options });
    }
    hscanStream(key, options) {
      return this.createScanStream("hscan", { key, options });
    }
    hscanBufferStream(key, options) {
      return this.createScanStream("hscanBuffer", { key, options });
    }
    zscanStream(key, options) {
      return this.createScanStream("zscan", { key, options });
    }
    zscanBufferStream(key, options) {
      return this.createScanStream("zscanBuffer", { key, options });
    }
    /**
     * Emit only when there's at least one listener.
     *
     * @ignore
     */
    silentEmit(eventName, arg) {
      let error;
      if (eventName === "error") {
        error = arg;
        if (this.status === "end") {
          return;
        }
        if (this.manuallyClosing) {
          if (error instanceof Error && (error.message === utils_1.CONNECTION_CLOSED_ERROR_MSG || // @ts-expect-error
          error.syscall === "connect" || // @ts-expect-error
          error.syscall === "read")) {
            return;
          }
        }
      }
      if (this.listeners(eventName).length > 0) {
        return this.emit.apply(this, arguments);
      }
      if (error && error instanceof Error) {
        console.error("[ioredis] Unhandled error event:", error.stack);
      }
      return false;
    }
    /**
     * @ignore
     */
    recoverFromFatalError(_commandError, err, options) {
      this.flushQueue(err, options);
      this.silentEmit("error", err);
      this.disconnect(true);
    }
    /**
     * @ignore
     */
    handleReconnection(err, item) {
      var _a;
      let needReconnect = false;
      if (this.options.reconnectOnError) {
        needReconnect = this.options.reconnectOnError(err);
      }
      switch (needReconnect) {
        case 1:
        case true:
          if (this.status !== "reconnecting") {
            this.disconnect(true);
          }
          item.command.reject(err);
          break;
        case 2:
          if (this.status !== "reconnecting") {
            this.disconnect(true);
          }
          if (((_a = this.condition) === null || _a === void 0 ? void 0 : _a.select) !== item.select && item.command.name !== "select") {
            this.select(item.select);
          }
          this.sendCommand(item.command);
          break;
        default:
          item.command.reject(err);
      }
    }
    /**
     * Get description of the connection. Used for debugging.
     */
    _getDescription() {
      let description;
      if ("path" in this.options && this.options.path) {
        description = this.options.path;
      } else if (this.stream && this.stream.remoteAddress && this.stream.remotePort) {
        description = this.stream.remoteAddress + ":" + this.stream.remotePort;
      } else if ("host" in this.options && this.options.host) {
        description = this.options.host + ":" + this.options.port;
      } else {
        description = "";
      }
      if (this.options.connectionName) {
        description += ` (${this.options.connectionName})`;
      }
      return description;
    }
    resetCommandQueue() {
      this.commandQueue = new Deque();
    }
    resetOfflineQueue() {
      this.offlineQueue = new Deque();
    }
    parseOptions(...args) {
      const options = {};
      let isTls = false;
      for (let i = 0; i < args.length; ++i) {
        const arg = args[i];
        if (arg === null || typeof arg === "undefined") {
          continue;
        }
        if (typeof arg === "object") {
          (0, lodash_1.defaults)(options, arg);
        } else if (typeof arg === "string") {
          (0, lodash_1.defaults)(options, (0, utils_1.parseURL)(arg));
          if (arg.startsWith("rediss://")) {
            isTls = true;
          }
        } else if (typeof arg === "number") {
          options.port = arg;
        } else {
          throw new Error("Invalid argument " + arg);
        }
      }
      if (isTls) {
        (0, lodash_1.defaults)(options, { tls: true });
      }
      (0, lodash_1.defaults)(options, Redis2.defaultOptions);
      if (typeof options.port === "string") {
        options.port = parseInt(options.port, 10);
      }
      if (typeof options.db === "string") {
        options.db = parseInt(options.db, 10);
      }
      this.options = (0, utils_1.resolveTLSProfile)(options);
    }
    /**
     * Change instance's status
     */
    setStatus(status, arg) {
      if (debug2.enabled) {
        debug2("status[%s]: %s -> %s", this._getDescription(), this.status || "[empty]", status);
      }
      this.status = status;
      process.nextTick(this.emit.bind(this, status, arg));
    }
    createScanStream(command2, { key, options = {} }) {
      return new ScanStream_1.default({
        objectMode: true,
        key,
        redis: this,
        command: command2,
        ...options
      });
    }
    /**
     * Flush offline queue and command queue with error.
     *
     * @param error The error object to send to the commands
     * @param options options
     */
    flushQueue(error, options) {
      options = (0, lodash_1.defaults)({}, options, {
        offlineQueue: true,
        commandQueue: true
      });
      let item;
      if (options.offlineQueue) {
        while (item = this.offlineQueue.shift()) {
          item.command.reject(error);
        }
      }
      if (options.commandQueue) {
        if (this.commandQueue.length > 0) {
          if (this.stream) {
            this.stream.removeAllListeners("data");
          }
          while (item = this.commandQueue.shift()) {
            item.command.reject(error);
          }
        }
      }
    }
    /**
     * Check whether Redis has finished loading the persistent data and is able to
     * process commands.
     */
    _readyCheck(callback) {
      const _this = this;
      this.info(function(err, res) {
        if (err) {
          if (err.message && err.message.includes("NOPERM")) {
            console.warn(`Skipping the ready check because INFO command fails: "${err.message}". You can disable ready check with "enableReadyCheck". More: https://github.com/luin/ioredis/wiki/Disable-ready-check.`);
            return callback(null, {});
          }
          return callback(err);
        }
        if (typeof res !== "string") {
          return callback(null, res);
        }
        const info2 = {};
        const lines = res.split("\r\n");
        for (let i = 0; i < lines.length; ++i) {
          const [fieldName, ...fieldValueParts] = lines[i].split(":");
          const fieldValue = fieldValueParts.join(":");
          if (fieldValue) {
            info2[fieldName] = fieldValue;
          }
        }
        if (!info2.loading || info2.loading === "0") {
          callback(null, info2);
        } else {
          const loadingEtaMs = (info2.loading_eta_seconds || 1) * 1e3;
          const retryTime = _this.options.maxLoadingRetryTime && _this.options.maxLoadingRetryTime < loadingEtaMs ? _this.options.maxLoadingRetryTime : loadingEtaMs;
          debug2("Redis server still loading, trying again in " + retryTime + "ms");
          setTimeout(function() {
            _this._readyCheck(callback);
          }, retryTime);
        }
      }).catch(lodash_1.noop);
    }
  };
  Redis$1.Cluster = cluster_1.default;
  Redis$1.Command = Command_1.default;
  Redis$1.defaultOptions = RedisOptions_1.DEFAULT_REDIS_OPTIONS;
  (0, applyMixin_1.default)(Redis$1, events_1.EventEmitter);
  (0, transaction_1.addTransactionSupport)(Redis$1.prototype);
  Redis.default = Redis$1;
  return Redis;
}
var hasRequiredBuilt;
function requireBuilt() {
  if (hasRequiredBuilt) return built$2.exports;
  hasRequiredBuilt = 1;
  (function(module2, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.print = exports.ReplyError = exports.SentinelIterator = exports.SentinelConnector = exports.AbstractConnector = exports.Pipeline = exports.ScanStream = exports.Command = exports.Cluster = exports.Redis = exports.default = void 0;
    exports = module2.exports = requireRedis().default;
    var Redis_1 = requireRedis();
    Object.defineProperty(exports, "default", { enumerable: true, get: function() {
      return Redis_1.default;
    } });
    var Redis_2 = requireRedis();
    Object.defineProperty(exports, "Redis", { enumerable: true, get: function() {
      return Redis_2.default;
    } });
    var cluster_1 = requireCluster();
    Object.defineProperty(exports, "Cluster", { enumerable: true, get: function() {
      return cluster_1.default;
    } });
    var Command_1 = requireCommand();
    Object.defineProperty(exports, "Command", { enumerable: true, get: function() {
      return Command_1.default;
    } });
    var ScanStream_1 = requireScanStream();
    Object.defineProperty(exports, "ScanStream", { enumerable: true, get: function() {
      return ScanStream_1.default;
    } });
    var Pipeline_1 = requirePipeline();
    Object.defineProperty(exports, "Pipeline", { enumerable: true, get: function() {
      return Pipeline_1.default;
    } });
    var AbstractConnector_1 = requireAbstractConnector();
    Object.defineProperty(exports, "AbstractConnector", { enumerable: true, get: function() {
      return AbstractConnector_1.default;
    } });
    var SentinelConnector_1 = requireSentinelConnector();
    Object.defineProperty(exports, "SentinelConnector", { enumerable: true, get: function() {
      return SentinelConnector_1.default;
    } });
    Object.defineProperty(exports, "SentinelIterator", { enumerable: true, get: function() {
      return SentinelConnector_1.SentinelIterator;
    } });
    exports.ReplyError = requireRedisErrors().ReplyError;
    Object.defineProperty(exports, "Promise", {
      get() {
        console.warn("ioredis v5 does not support plugging third-party Promise library anymore. Native Promise will be used.");
        return Promise;
      },
      set(_lib) {
        console.warn("ioredis v5 does not support plugging third-party Promise library anymore. Native Promise will be used.");
      }
    });
    function print(err, reply) {
      if (err) {
        console.log("Error: " + err);
      } else {
        console.log("Reply: " + reply);
      }
    }
    exports.print = print;
  })(built$2, built$2.exports);
  return built$2.exports;
}
var builtExports = requireBuilt();
export {
  requireBuilt as a,
  requireSrc as b,
  commonjsGlobal as c,
  getDefaultExportFromCjs as d,
  builtExports as e,
  getAugmentedNamespace as g,
  requireDenque as r
};
