import pt from "node:path";
import { fileURLToPath as dt } from "node:url";
import { createRequire as gt } from "node:module";
import { PoolManager as mt } from "@magustek/node-opapi-rs";
import { machine_id as ve } from "@magustek/node-opapi-rs";
import "reflect-metadata";
import { i as Q, m as v, g as yt, a as j, b as h, s as L } from "./node_modules/lodash-es-bw-k0F_5.js";
import { driverMap as Mt } from "@magustek/computing-database";
import { DataSource as bt, EntitySchema as wt } from "@magustek/computing-database/typeorm";
import O from "dayjs";
import { randomUUID as Et } from "node:crypto";
import Ot from "node:events";
import Z, { resolve as T, parse as vt } from "node:path";
import { existsSync as Rt, readFileSync as Pt } from "node:fs";
import { readFile as xt } from "node:fs/promises";
import { SyntheticModule as X, createContext as St, SourceTextModule as Nt } from "node:vm";
const Y = () => dt(import.meta.url), ft = () => pt.dirname(Y()), ie = ft(), ne = Y();
const le = gt(import.meta.url);
class Dt {
  static registerNode;
}
class V extends Dt {
  id;
  model;
  flow;
  node;
  batchId;
  getBatchId() {
    return this.getGlobalData("batchId", "");
  }
  constructor(t, e, s) {
    super(), this.id = t, this.model = e, this.flow = s, this.batchId = this.flow?.getGlobalData("batchId", ""), this.node = e.getNodeById(this.id);
  }
  get visited() {
    return this.node.isVisited();
  }
  get executed() {
    return this.node.isExecuted();
  }
  get parentId() {
    return this.node.parentId;
  }
  getSubModel() {
    return this.model.getSubModel(this.node);
  }
  setSubModel(t) {
    this.model.setSubModel(this.node, t);
  }
  async runSubModel(t) {
    return this.flow.runModel(t, this.node);
  }
  clearModelContext(t) {
    t.reset(), t.getNodes().map((e) => ({ node: e, outputs: e.getOutputs() })).flatMap(({ node: e, outputs: s }) => s.map((a) => ({ node: e, output: a }))).map(({ node: e, output: s }) => `${e.id}.${s.key}`).forEach((e) => {
      this.getContext().delete(e);
    });
  }
  /**
   * 设置节点是否已执行
   */
  setExecuted(t = !0) {
    this.node.setExecuted(t);
  }
  /**
   * alias to this.flow.getContext()
   */
  getContext() {
    return this.flow.getContext();
  }
  /**
   * 保存到流程上下文中
   */
  saveToContext(t) {
    this.flow.extendContext(t);
  }
  getInputs(t = !1) {
    const e = this.node.getInputs();
    return t ? e : e.filter((s) => !Q(s.rawValue));
  }
  getOutputs() {
    return this.node.getOutputs();
  }
  getInputByKey(t) {
    return this.getInputs(!0).find((e) => e.key === t);
  }
  getProperties() {
    return this.node.geProperties();
  }
  getPropertyByKey(t) {
    return this.getProperties().find((e) => e.key === t);
  }
  getOutputByKey(t) {
    return this.getOutputs().find((e) => e.key === t);
  }
  getGlobalData(t, e) {
    return this.flow.getGlobalData(t, e);
  }
  setGlobalData(t, e) {
    this.flow.setGlobalDataKV(t, e);
  }
  getBizData(t, e) {
    return this.flow.getBizData(t, e);
  }
  getGlobalDatas() {
    return this.flow.getGlobalDatas();
  }
  /**
   * 通过指定的输出端口，跳过后续节点的执行
   * @param outputKey 指定某个输出端口
   * @param depp 是否深度跳过
   */
  skipNextByOutput(t, e = !0) {
    this.model.skipNextByOutput(this.id, t, e);
  }
  /**
   * 跳过所有后续节点
   */
  skipNext(t = !0) {
    this.model.skipNext(this.id, t);
  }
  /**
   * 获取前置节点
   */
  getSourceNodes() {
    return this.model.getSourceNodes(this.node);
  }
  /**
   * 获取后置节点
   */
  getTargetNodes() {
    return this.model.getTargetNodes(this.node);
  }
}
class It extends V {
  async onBeforeExec() {
    return Promise.resolve();
  }
  async onAfterExec() {
    return Promise.resolve();
  }
  exec() {
  }
}
const tt = Symbol("__@Operator"), et = Symbol("__@Input"), st = Symbol("__@Output"), at = Symbol("__@Property"), rt = Symbol("__@DefaultOutput"), F = Symbol("__@OnAfterExec"), G = Symbol("__@OnBeforeExec"), K = Symbol("__@DataTransform"), _t = {
  execResultAsDefaultOutput: { key: "output" },
  allowAddInput: !1,
  allowAddOutput: !1
};
function At(o) {
  return function(t) {
    const e = v({}, _t, o);
    return Reflect.defineMetadata(tt, e, t), q(t);
  };
}
const q = (o) => class extends o {
  constructor(t, e, s) {
    super(t, e, s);
  }
  async onBeforeExec() {
    const t = this.getContext();
    for (const a of this.getInputs(!0))
      if (a.isUnset()) {
        const r = a.getFormatedValue(t);
        a.setValue(r), this[a.key] = r;
      } else
        this[a.key] = a.getValue();
    for (const a of this.getProperties()) {
      const r = a.getFormatedValue();
      a.setValue(r), this[a.key] = r;
    }
    const e = Reflect.getMetadata(K, o) || [];
    for (const { key: a, transformer: r } of e) {
      const i = await Promise.resolve(r?.call(null, this[a], this));
      this[a] = i;
    }
    const s = Reflect.getMetadata(G, o);
    if (s?.length)
      for (const { key: a } of s)
        await Promise.resolve(super[a]());
  }
  _result = Symbol("unexec");
  async exec() {
    return this._result = await Promise.resolve(super.exec()), this._result;
  }
  async onAfterExec() {
    const t = this.getContext();
    for (const s of this.getOutputs())
      s.isUnset() && s.setValue(this._result), t.set([this.id, s.key], s.getValue());
    this.setExecuted(!0);
    const e = Reflect.getMetadata(F, o);
    if (e?.length)
      for (const { key: s } of e)
        await Promise.resolve(super[s]());
  }
}, C = (o, t = "opt") => (e) => function(s, a) {
  const r = Reflect.getMetadata(o, s.constructor);
  if (!r)
    Reflect.defineMetadata(o, [{ key: a, [t]: e }], s.constructor);
  else {
    const i = r.findIndex((n) => n.key === a);
    if (i >= 0) {
      const n = r.toSpliced(i, 1, { key: a, [t]: e });
      Reflect.defineMetadata(o, n, s.constructor);
    } else
      Reflect.defineMetadata(o, [...r, { key: a, [t]: e }], s.constructor);
  }
}, ot = (o) => () => function(t, e, s) {
  const a = Reflect.getMetadata(o, t.constructor);
  if (!a)
    Reflect.defineMetadata(o, [{ key: e, descriptor: s }], t.constructor);
  else {
    const r = a.findIndex((i) => i.key === e);
    if (r >= 0) {
      const i = a.toSpliced(r, 1, { key: e, descriptor: s });
      Reflect.defineMetadata(o, i, t.constructor);
    } else
      Reflect.defineMetadata(o, [...a, { key: e, descriptor: s }], t.constructor);
  }
};
function D(o) {
  return C(et)(o);
}
function Tt(o) {
  return C(at)(o);
}
const kt = C(st), B = ot(G), Vt = ot(F), z = C(
  K,
  "transformer"
);
function Ct(o) {
  return function(t) {
    Reflect.defineMetadata(rt, o, t);
  };
}
const Bt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DataTransform: z,
  DefaultOutput: Ct,
  Input: D,
  OnAfterExec: Vt,
  OnBeforeExec: B,
  Operator: At,
  Output: kt,
  Property: Tt,
  createOperatorClass: q,
  dataTransformMetaKey: K,
  defaultOutputMetaKey: rt,
  inputMetaKey: et,
  onAfterExecMetaKey: F,
  onBeforeExecMetaKey: G,
  operatorMetaKey: tt,
  outputMetaKey: st,
  propertyMetaKey: at
}, Symbol.toStringTag, { value: "Module" }));
class it {
  pool;
  max = +process.env.VITE_APP_OPENPLANT_POOL_SIZE || 100;
  options;
  constructor(t) {
    this.options = t;
    const { host: e, port: s, username: a, password: r } = this.options;
    this.pool = new mt(e, +s, a, r, 300, this.max);
  }
  setRt(t) {
    this.options.rt = t;
  }
  isRt() {
    return this.options.rt;
  }
  /**
   * 执行 sql
   */
  async query(t) {
    const e = await this.pool.query_async(t), { error: s, rows: a, cols: r } = e || {};
    return s ? [] : a.map((i) => {
      const n = {};
      for (let l = 0; l < r.length; l++) {
        const { name: u } = r[l], c = i[l];
        n[u] = u === "TM" ? O(+c * 1e3).format("YYYY-MM-DD HH:mm:ss") : c;
      }
      return n;
    });
  }
  /**
   * 查询实时值(触发时间的实时值)，如果当前时间比触发时间晚 1 秒以上则应该查历史值
   */
  async queryRealtime(t, e) {
    if (!t.length) return {};
    const s = t.map((l) => `'${l}'`).join(","), a = O();
    let r = `SELECT GN,AV,DS,TM FROM REALTIME WHERE GN IN (${s})`;
    a.diff(O(e || void 0), "s") > 1 && (console.log("查询历史值作为实时值", Date(), s, e), r = `SELECT GN,AV,DS,TM FROM ARCHIVE WHERE GN IN (${s}) AND TM = '${e}'`);
    const i = await this.query(r);
    return Object.fromEntries(
      Object.entries(yt(i, (l) => l.GN)).map(([l, u]) => [l, u[0]])
    );
  }
  /**
   * 写实时值，如果当前时间比触发时间晚 1 秒以上则写历史值
   * @param rows Array<[GN, AV]>
   * @param triggerTime string
   */
  async saveRealtime(t, e) {
    if (!t || !t.length) return;
    if (O().diff(O(e || void 0), "s") > 1) {
      const a = t.map(([r, i]) => [r, i, e]);
      return console.log("saveRealtime，实际保存历史值", Date(), a), await this.saveArchive(a);
    } else
      return await this.pool.update_async("REALTIME", t, ["GN", "AV"]).catch();
  }
  /**
   * 写历史值
   * @param rows Array<[GN, AV, TM]>
   */
  async saveArchive(t) {
    const e = ["GN", "AV", "TM"];
    return await this.pool.insert_async("ARCHIVE", t, e).catch();
  }
  async close() {
    await this.pool.close_async();
  }
}
class nt {
  // private driverMap: Record<string, unknown> = { doris: require_('mysql'), mysql: require_('mysql2') }
  // 实时连接池 batchId -> opConnKey -> OPConnectionPool
  batchOpPool = /* @__PURE__ */ new Map();
  // 关系连接池 batchId -> rlConnKey -> DataSource
  batchRlPool = /* @__PURE__ */ new Map();
  // 表结构映射 rlConnKey -> tableName -> EntitySchema
  tableEntityMap = /* @__PURE__ */ new Map();
  getOpKey(t) {
    const { host: e, port: s } = t;
    if (!(!e || !s))
      return `${e}:${s}`;
  }
  getRlKey(t) {
    const { host: e, port: s, database: a } = t;
    if (!(!e || !s || !a))
      return `${e}:${s}:${a}`;
  }
  connect(t, e) {
    const { type: s } = e || {};
    if (s === "openplant") {
      const a = this.getOpKey(e);
      if (!a) return;
      this.batchOpPool.has(t) || this.batchOpPool.set(t, /* @__PURE__ */ new Map());
      const r = this.batchOpPool.get(t);
      r.has(a) ? e.rt && r.get(a).setRt(!0) : r.set(a, new it(e));
    } else {
      const a = this.getRlKey(e);
      if (!a) return;
      this.batchRlPool.has(t) || this.batchRlPool.set(t, /* @__PURE__ */ new Map()), this.tableEntityMap.has(a) || this.tableEntityMap.set(a, /* @__PURE__ */ new Map());
      const r = this.batchRlPool.get(t);
      if (!r.has(a)) {
        const { type: i } = e, n = { ...e, driver: Mt[i], poolSize: 10 };
        r.set(a, new bt(n));
      }
    }
  }
  getOpConn(t, e) {
    return this.batchOpPool.get(t)?.get(this.getOpKey(e));
  }
  initializeRlMap = /* @__PURE__ */ new Map();
  async initializeRl(t) {
    const e = this.initializeRlMap.get(t);
    if (e) return e.promise;
    const { resolve: s, promise: a } = Promise.withResolvers();
    this.initializeRlMap.set(t, { promise: a });
    const r = this.batchRlPool.get(t);
    if (!r) return s();
    const i = r.values().filter((c) => !c.isInitialized), n = Array.from(i);
    if (!n.length) return s();
    const l = n.map((c) => this.initTableEntites(t, c.options));
    await Promise.all(l);
    const u = n.map((c) => new Promise((d) => {
      (async () => {
        c.isInitialized && await c.destroy();
        const g = this.getRlKey(c.options), E = this.tableEntityMap.get(g);
        c.setOptions({ entities: [...E.values()] }), await c.initialize(), d(void 0);
      })();
    }));
    await Promise.all(u), s(), this.initializeRlMap.delete(t);
  }
  getAllOpConn(t) {
    return Array.from(this.batchOpPool.get(t)?.values() || []);
  }
  getAllOpRtConn(t) {
    return this.getAllOpConn(t).filter((e) => e.isRt());
  }
  getRlConn(t, e) {
    return this.batchRlPool.get(t)?.get(this.getRlKey(e));
  }
  async getAllRlConn(t) {
    return await Promise.all(
      Array.from(this.batchRlPool.get(t)?.values() || []).map(
        (e) => Promise.resolve(e.isInitialized ? e : e.initialize())
      )
    );
  }
  async close(t) {
    await Promise.all(this.getAllOpConn(t).map((s) => s.close())), await Promise.all((await this.getAllRlConn(t)).map((s) => s.destroy())), this.batchOpPool.delete(t), (this.batchRlPool.get(t)?.keys() || []).forEach((s) => {
      this.tableEntityMap.get(s).clear(), this.tableEntityMap.delete(s);
    }), this.batchRlPool.delete(t);
  }
  async initTableEntites(t, e) {
    const s = this.getRlKey(e), a = this.batchRlPool.get(t)?.get(s);
    a.isInitialized || await a.initialize();
    const { database: r } = e, i = `SELECT TABLE_NAME AS tableName FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '${r}'`, l = (await a.query(i).catch(() => [])).map(({ tableName: u }) => this.createTableEntity(t, { ...e, tableName: u }));
    await Promise.all(l);
  }
  async createTableEntity(t, e) {
    const s = this.getRlKey(e), { tableName: a, database: r } = e;
    if (!a) return;
    const i = this.tableEntityMap.get(s), n = i.get(a), l = this.batchRlPool.get(t)?.get(s);
    if (!n) {
      l.isInitialized || await l.initialize();
      const u = `SHOW COLUMNS FROM \`${a}\``, c = await l.query(u).catch(() => []);
      if (!c.length || !c.find((f) => f.Key === "PRI" || f.Key === "true")) return;
      const g = {};
      for (const f of c) {
        const ht = f.Type.includes("int") ? Number : f.Type.includes("bit") ? Boolean : String;
        g[f.Field] = {
          name: f.Field,
          nullable: f.Null !== "NO",
          type: ht,
          primary: f.Key === "PRI" || f.Key === "true"
        };
      }
      const E = new wt({ name: a, tableName: a, database: r, columns: g });
      i.set(a, E);
    }
    return i.get(a);
  }
  getTableEntity(t, e) {
    return this.tableEntityMap.get(this.getRlKey(t)).get(e);
  }
}
const p = new nt();
var jt = Object.defineProperty, Lt = Object.getOwnPropertyDescriptor, I = (o, t, e, s) => {
  for (var a = s > 1 ? void 0 : s ? Lt(t, e) : t, r = o.length - 1, i; r >= 0; r--)
    (i = o[r]) && (a = (s ? i(t, e, a) : i(a)) || a);
  return s && a && jt(t, e, a), a;
};
class $ extends V {
  dataSource;
  connection;
  async onBeforeExec() {
    this.dataSource = {
      type: process.env.VITE_APP_DATASOURCE_TYPE,
      ...this.getGlobalData("datasource")
    }, p.connect(this.batchId, this.dataSource), await p.initializeRl(this.batchId), this.connection = p.getRlConn(this.batchId, this.dataSource);
  }
  getTableEntity(t) {
    return p.getTableEntity(this.dataSource, t || this.tableName);
  }
  getRepository(t) {
    return this.connection.getRepository(this.getTableEntity(t));
  }
  createQueryBuilder(t, e) {
    return this.connection.createQueryBuilder(this.getTableEntity(e), t);
  }
  /**
   * 执行原始 sql 语句
   */
  async query(t) {
    return await this.connection?.query(t);
  }
  static registerNode(t, e, s) {
    const a = t.getInputs(), r = a.find((l) => l.key === "dataSource")?.getFormatedValue(), i = a.find((l) => l.key === "database")?.getFormatedValue(), n = a.find((l) => l.key === "tableName")?.getFormatedValue();
    s.registerDataSource({ ...r, database: i, tableName: n });
  }
}
I([
  B()
], $.prototype, "onBeforeExec", 1);
class _ extends $ {
  dataSource = null;
  database;
  tableName;
  async onBeforeExec() {
    this.dataSource ? this.dataSource = { ...this.dataSource, database: this.database } : this.dataSource = {
      type: process.env.VITE_APP_DATASOURCE_TYPE,
      ...this.getGlobalData("datasource")
    }, p.connect(this.batchId, this.dataSource), await p.initializeRl(this.batchId), this.connection = p.getRlConn(this.batchId, this.dataSource);
  }
}
I([
  D({ order: -30, dataType: "object", name: "数据源", type: "datasource" }),
  z((o) => typeof o == "string" ? JSON.parse(o) : o)
], _.prototype, "dataSource", 2);
I([
  D({ order: -20, dataType: "string", name: "库名", description: "选择默认数据源时，库名留空" })
], _.prototype, "database", 2);
I([
  D({ order: -10, dataType: "string", name: "表名" })
], _.prototype, "tableName", 2);
I([
  B()
], _.prototype, "onBeforeExec", 1);
var Ft = Object.defineProperty, Gt = Object.getOwnPropertyDescriptor, lt = (o, t, e, s) => {
  for (var a = s > 1 ? void 0 : s ? Gt(t, e) : t, r = o.length - 1, i; r >= 0; r--)
    (i = o[r]) && (a = (s ? i(t, e, a) : i(a)) || a);
  return s && a && Ft(t, e, a), a;
};
const M = /* @__PURE__ */ new Map(), b = /* @__PURE__ */ new Map(), m = /* @__PURE__ */ new Map();
class Kt extends V {
  static queryRealtimeMap = /* @__PURE__ */ new Map();
  static saveRealtimeMap = /* @__PURE__ */ new Map();
  /**
   * 执行 sql
   */
  static async query(t, e) {
    return t ? t.query(e) : [];
  }
  /**
   * 写历史值
   */
  static async saveArchive(t, e) {
    return t.saveArchive(e);
  }
  /**
   * 查询实时值
   */
  static async queryRealtime(t, e) {
    const s = `${t}.${e}`, a = this.queryRealtimeMap.get(s);
    if (a) return await a.promise;
    const { promise: r, resolve: i } = Promise.withResolvers();
    this.queryRealtimeMap.set(s, { promise: r, resolve: i }), M.has(t) || M.set(t, /* @__PURE__ */ new WeakMap());
    const n = p.getAllOpRtConn(t), l = m.get(t) || [];
    if (!l.length || !n.length) return;
    (await Promise.all(n.map((c) => c.queryRealtime(l, e)))).forEach((c, d) => {
      M.get(t).set(n[d], new Map(Object.entries(c)));
    }), i(!0), this.queryRealtimeMap.delete(s);
  }
  /**
   * 一次写入所有实时值
   */
  static async saveRealtime(t, e) {
    const s = `${t}.${e}`, a = this.saveRealtimeMap.get(s);
    if (a) return await a.promise;
    const { promise: r, resolve: i } = Promise.withResolvers();
    this.saveRealtimeMap.set(s, { promise: r, resolve: i });
    const n = p.getAllOpRtConn(t), l = b.get(t), u = n.map((c) => {
      const d = l?.get(c) || [];
      return l?.delete(c), c.saveRealtime(d, e);
    });
    await Promise.all(u), this.saveRealtimeMap.delete(s), i(!0), this.clearTempRealtime(t);
  }
  static addGns(t, e) {
    m.has(t) || m.set(t, []);
    const s = m.get(t);
    m.set(t, Array.from(/* @__PURE__ */ new Set([...s, ...e || []])));
  }
  static clearTempRealtime(t) {
    M.delete(t), b.delete(t);
  }
  static clear(t) {
    this.clearTempRealtime(t), m.delete(t);
  }
  /**
   * 注册数据源
   */
  static registerNode(t, e, s) {
    const a = t.getInput("dataSource")?.getFormatedValue();
    s.registerDataSource({ type: "openplant", ...a });
  }
}
const U = class k extends Kt {
  connection;
  dataSource;
  onBeforeExec() {
    this.dataSource?.type || (this.dataSource = { type: "openplant", ...this.getGlobalData("openplant") }), p.connect(this.batchId, this.dataSource), this.connection = p.getOpConn(this.batchId, this.dataSource);
  }
  /**
   * 获取所有点名
   * 继承于 `OpenPlant` 的算子, 所有的输入参数的 key 当作点名使用
   */
  getGnList() {
    return this.getInputs(!0).filter((t) => t.key !== "dataSource").map((t) => {
      const e = t.getValue();
      return e === t.unset ? t.key : e || t.key;
    });
  }
  async query(t) {
    return k.query(this.connection, t);
  }
  /**
   * 写历史值
   * debug 模式下不会真的写入
   */
  async saveArchive(t) {
    if (this.flow.isDebug) {
      process.env.NODE_ENV === "development" && await k.saveArchive(this.connection, t);
      return;
    }
    return await k.saveArchive(this.connection, t);
  }
  /**
   * 查询实时值
   */
  async queryRealtime(t, e) {
    return await this.connection?.queryRealtime(t, e);
  }
  /**
   * 写实时值，写入临时变量，等待所有模型执行结束后统一写
   * debug 模式下不会真的写入
   */
  async saveRealtime(t) {
    if (this.flow.isDebug) {
      process.env.NODE_ENV === "development" && await this.connection.saveRealtime([t], "");
      return;
    }
    b.has(this.batchId) || b.set(this.batchId, /* @__PURE__ */ new WeakMap());
    const e = b.get(this.batchId), s = e?.get(this.connection) || [];
    e.set(this.connection, [...s, t]);
  }
  /**
   * 获取实时数据，没有的则查询一次
   */
  async getRealTimeData() {
    const t = this.getGnList(), e = M.get(this.batchId)?.get(this.connection) || /* @__PURE__ */ new Map(), s = t.filter((r) => !e.has(r));
    if (s.length) {
      console.log("missGns", s);
      const r = await this.queryRealtime(s, this.getGlobalData("triggerTime"));
      Object.entries(r).forEach(([i, n]) => e.set(i, n));
    }
    return Object.fromEntries(t.map((r) => [r, e.get(r)]));
  }
};
lt([
  D({ order: -10, dataType: "object", name: "数据源", type: "datasource" }),
  z((o) => typeof o == "string" ? JSON.parse(o) : o)
], U.prototype, "dataSource", 2);
lt([
  B()
], U.prototype, "onBeforeExec", 1);
let R = U;
const qt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  BaseOperator: V,
  ConnectionManager: nt,
  Database: _,
  InternalDatabase: $,
  OPConnectionPool: it,
  OpenPlant: R,
  connectionManager: p,
  gnListMap: m,
  realtimeDataMap: M,
  tempSaveRealtimeMap: b
}, Symbol.toStringTag, { value: "Module" }));
class zt {
  constructor(t, e) {
    this.metadata = t, this.model = e, this.id = t.id, this.sourceNodeId = this.metadata.source.cell, this.sourcePortId = this.metadata.source.port, this.targetNodeId = this.metadata.target.cell, this.targetPortId = this.metadata.target.port;
  }
  id;
  sourceNodeId;
  sourcePortId;
  targetNodeId;
  targetPortId;
  isNode() {
    return !1;
  }
  isEdge() {
    return !0;
  }
  getMetadata() {
    return this.metadata;
  }
}
var y = /* @__PURE__ */ ((o) => (o.string = "string", o.number = "number", o.boolean = "boolean", o.array = "array", o.object = "object", o.function = "function", o.any = "any", o))(y || {});
const W = (o, t) => {
  if (!t) return o;
  switch (t) {
    case y.string:
      return Q(o) ? "" : String(o);
    case y.number: {
      const e = parseFloat(o);
      return Number.isNaN(e) ? 0 : e;
    }
    case y.boolean:
      return !!o;
    case y.array:
      try {
        if (Array.isArray(o)) return o;
        const e = JSON.parse(String(o));
        if (Array.isArray(e)) return e;
        if (typeof e == "string") {
          const s = JSON.parse(e);
          if (Array.isArray(s)) return s;
          throw new Error();
        } else throw new Error();
      } catch {
        return [];
      }
    case y.object:
      try {
        if (j(o)) return o;
        const e = JSON.parse(String(o));
        if (j(e)) return e;
        if (typeof e == "string") {
          const s = JSON.parse(e);
          if (j(s)) return s;
          throw new Error();
        } else throw new Error();
      } catch {
        return {};
      }
  }
}, N = (o) => {
  if (typeof o == "function") return "anonymous function";
  if (JSON.stringify(o, null, 0)?.length < 1e3) return o;
  if (Array.isArray(o)) return o.slice(0, 5).map((t) => N(t));
  if (typeof o == "object" && o !== null) {
    const t = {}, e = Object.getOwnPropertyNames(o).slice(0, 100);
    for (const s of e)
      t[s] = N(o[s]);
    return t;
  }
  return o;
}, $t = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DataTypeEnum: y,
  sparseData: N,
  toConstantValue: W
}, Symbol.toStringTag, { value: "Module" })), Ut = (o) => {
  const t = { ...qt, ...Bt, ...$t, Model: A, Flow: w };
  return new X(
    Object.keys(t),
    function() {
      for (const [e, s] of Object.entries(t))
        this.setExport(e, s);
    },
    { context: o }
  );
}, Wt = async (o, t) => {
  const e = await import(
    /* @vite-ignore */
    o
  );
  return new X(
    Object.keys(e),
    function() {
      for (const [s, a] of Object.entries(e))
        this.setExport(s, a);
    },
    { context: t }
  );
}, Jt = (o) => async (t) => t === "@magustek/computing-engine" ? Ut(o) : await Wt(t, o), Ht = () => St({
  console,
  // console: {
  //   log: () => {},
  //   time: () => {},
  //   timeEnd: () => {},
  // },
  crypto,
  fetch,
  setTimeout,
  setInterval,
  setImmediate,
  Array,
  Blob,
  Buffer,
  Date,
  Headers,
  File,
  FormData,
  Function,
  JSON,
  Math,
  Object,
  Proxy,
  Reflect,
  Request,
  String,
  URLSearchParams
}), Yt = (o) => {
  const t = new A(JSON.parse(o));
  return class extends q(It) {
    static registerNode(e, s, a) {
      a.registerModelNode(t);
    }
    mapModelInputs() {
      const e = this.getInputs(!0);
      t.getRoots().map((a) => ({ root: a, inputs: a.getInputs() })).flatMap(({ root: a, inputs: r }) => r.map((i) => ({ root: a, input: i }))).forEach(({ root: a, input: r }) => {
        const i = e.find((n) => n.key === `${a.id.substring(0, 8)}.${r.key}`);
        if (i) {
          const n = i.isUnset() ? r.getFormatedValue() : i.getValue();
          r.setValue(n);
        }
      });
    }
    mapModelOutputs() {
      const e = t.getLeafs(), s = this.getOutputs();
      e.map((r) => ({ leaf: r, outputs: r.getOutputs() })).flatMap(({ leaf: r, outputs: i }) => i.map((n) => ({ leaf: r, output: n }))).forEach(({ leaf: r, output: i }) => {
        const n = s.find((l) => l.key === `${r.id.substring(0, 8)}.${i.key}`);
        n && n.setValue(i.getValue());
      });
    }
    async exec() {
      return this.mapModelInputs(), await this.runSubModel(t), this.mapModelOutputs(), this.clearModelContext(t), null;
    }
  };
}, H = Ht();
class Qt {
  /**
   * 文件内容缓存
   */
  // private fileCache = new Map<string, string | Buffer>()
  /**
   * 文件模块导出缓存
   */
  moduleExportCache = /* @__PURE__ */ new Map();
  async evaluateCode(t) {
    const e = new Nt(t, { context: H });
    return await e.link(Jt(H)), await e.evaluate(), e;
  }
  /**
   * 加载 esm 文件模块
   */
  async loadESM(t) {
    if (!Rt(t)) throw new Error(`File ${t} not found`);
    const e = await xt(t, { encoding: "utf-8" });
    return (await this.evaluateCode(e)).namespace;
  }
  /**
   * 加载算子文件
   */
  async loadFile(t, e = !1) {
    const s = T(t);
    if (this.isFileLoaded(s) && !e) return;
    const { ext: a } = vt(s);
    if (a === ".js") {
      const r = await this.loadESM(s);
      this.moduleExportCache.set(s, r);
    }
    if (a === ".json") {
      const r = JSON.parse(Pt(s, { encoding: "utf-8" })), i = Object.fromEntries(Object.entries(r).map(([n, l]) => [n, Yt(l)]));
      this.moduleExportCache.set(s, i);
    }
  }
  isFileLoaded(t) {
    return this.moduleExportCache.has(T(t));
  }
  getExport(t) {
    return this.moduleExportCache.get(T(t));
  }
  getLoadedFiles() {
    return Array.from(this.moduleExportCache.keys());
  }
  removeFiles(t) {
    t.forEach((e) => this.moduleExportCache.delete(T(e)));
  }
}
const P = new Qt();
class Zt {
  /**
   * 执行指定文件内的算子
   * @param file 文件路径
   * @param exportName 算子名称
   * @returns 计算结果
   */
  async evaluate(t, e, s, { flow: a, model: r }) {
    const { promise: i, resolve: n, reject: l } = Promise.withResolvers(), u = Z.resolve(e);
    try {
      P.isFileLoaded(u) || await P.loadFile(u);
      const c = P.getExport(u);
      if (!(s in c)) throw new Error(`算子文件<${u}>内找不到该算子<${s}>`);
      const d = c[s], g = new d(t, r, a);
      await g.onBeforeExec();
      const E = await g.exec();
      return await g.onAfterExec(), n(E), i;
    } catch (c) {
      return c instanceof Error && l(c.message), l(c), i;
    } finally {
    }
  }
}
class ct {
  portMeta;
  constructor(t) {
    this.portMeta = t;
  }
  get id() {
    return h(this.portMeta, "id");
  }
  get key() {
    return h(this.portMeta, "data.key");
  }
  get name() {
    return h(this.portMeta, "data.name");
  }
  /**
   * 端口原始值
   */
  get rawValue() {
    return h(this.portMeta, "data.value");
  }
  /**
   * 端口默认值
   */
  get defaultValue() {
    return h(this.portMeta, "data.defaultValue");
  }
  /**
   * 原始值类型
   */
  get valueType() {
    return h(this.portMeta, "data.valueType");
  }
  /**
   * 端口自定义类型
   */
  get portType() {
    return h(this.portMeta, "data.metadata.type");
  }
}
class x extends ct {
  static unset = Symbol("unset");
  value = x.unset;
  get unset() {
    return x.unset;
  }
  /**
   * 获取格式化后的真实值
   * 如果 `valueType` 为 `context` 从上下文中读取
   * 否则根据 `valueType` 将原始值转换为对应的数据类型的数据
   */
  getFormatedValue(t) {
    return this.valueType !== "context" ? W(this.rawValue ?? this.defaultValue, this.valueType) : t?.get(this.rawValue);
  }
  isUnset() {
    return this.value === x.unset;
  }
  /**
   * 获取输入端口的值
   */
  getValue() {
    return this.value;
  }
  setValue(t) {
    this.value = t;
  }
}
class S extends ct {
  static unset = Symbol("unset");
  value = S.unset;
  skiped = !1;
  get unset() {
    return S.unset;
  }
  getValue() {
    return this.value;
  }
  setValue(t) {
    this.value = t;
  }
  isUnset() {
    return this.value === S.unset;
  }
  setSkiped(t = !1) {
    this.skiped = t;
  }
  isSkiped() {
    return this.skiped;
  }
}
class J {
  static unset = Symbol("unset");
  value = J.unset;
  meta;
  key;
  name;
  /**
   * 属性原始值
   */
  rawValue;
  /**
   * 默认值
   */
  defaultValue;
  /**
   * 原始值类型
   */
  valueType;
  constructor(t) {
    this.meta = t, this.key = h(this.meta, "key"), this.name = h(this.meta, "name"), this.rawValue = h(this.meta, "value"), this.defaultValue = h(this.meta, "defaultValue"), this.valueType = h(this.meta, "valueType");
  }
  // public get key() {
  //   return get(this.meta, 'key')
  // }
  // public get name() {
  //   return get(this.meta, 'name')
  // }
  // public get rawValue() {
  //   return get(this.meta, 'value')
  // }
  // public get defaultValue() {
  //   return get(this.meta, 'defaultValue')
  // }
  // public get valueType() {
  //   return get(this.meta, 'valueType') as Exclude<PropMeta['valueType'], 'context'>
  // }
  getFormatedValue() {
    return W(this.rawValue ?? this.defaultValue, this.valueType);
  }
  getValue() {
    return this.value;
  }
  setValue(t) {
    this.value = t;
  }
}
class Xt {
  constructor(t, e) {
    this.metadata = t, this.model = e, this.setMetadata(t);
  }
  id;
  parentId;
  filePath = "";
  export = "";
  children = [];
  ports;
  nodeInputs = [];
  nodeProps = [];
  nodeOutputs = [];
  setMetadata(t) {
    this.metadata = t, this.id = t.id, this.parentId = t.parent, this.children = t.children || [], this.filePath = t.data.filePath || t.data.path || "", this.export = t.data.export, this.ports = h(t, ["ports", "items"]), this.nodeInputs = this.getNativePortsByGroup("in").map((s) => new x(s)), this.nodeOutputs = this.getNativePortsByGroup("out").map((s) => new S(s));
    const e = t.data.properties || [];
    this.nodeProps = e.map((s) => new J(s));
  }
  getNativePortsByGroup(t) {
    return this.ports.filter((e) => e.group === t);
  }
  getInput(t) {
    return this.nodeInputs.find((e) => e.key === t);
  }
  getOutput(t) {
    return this.nodeOutputs.find((e) => e.key === t);
  }
  getInputs() {
    return this.nodeInputs;
  }
  getOutputs() {
    return this.nodeOutputs;
  }
  geProperties() {
    return this.nodeProps;
  }
  getParentId() {
    return this.parentId;
  }
  isNode() {
    return !0;
  }
  isEdge() {
    return !1;
  }
  getMetadata() {
    return this.metadata;
  }
  getChildren() {
    const t = this.children.map((r) => this.model.getNodeById(r) || this.model.getEdgeById(r)), e = t.filter((r) => r.isEdge()), s = t.filter((r) => r.isNode()), a = [];
    return s.forEach((r) => {
      const i = [...this.model.getNodeInEdges(r), ...this.model.getNodeOutEdges(r)];
      a.push(...i.filter((n) => e.every((l) => l.id !== n.id)));
    }), [...t.map((r) => r.getMetadata()), ...a.map((r) => r.getMetadata())];
  }
  isExecuted() {
    return !!h(this.metadata, ["data", "__executed"]);
  }
  isVisited() {
    return !!h(this.metadata, ["data", "__visited"]);
  }
  setExecuted(t) {
    L(this.metadata, ["data", "__executed"], t);
  }
  setVisted(t) {
    L(this.metadata, ["data", "__visited"], t);
  }
  getOpClass() {
    const t = P.getExport(this.filePath);
    if (!t) return;
    const e = this.export;
    return e in t ? t[e] : void 0;
  }
  async registerNode(t, e) {
    const s = this.getOpClass();
    return Promise.resolve(s?.registerNode?.(this, t, e));
  }
}
class A {
  // group 节点子模型
  constructor({ cells: t }, e = !1) {
    this.sub = e;
    for (let s = 0; s < t.length; s++) {
      const a = t[s];
      if (a.shape === "edge")
        this.edgeMap.set(a.id, new zt(a, this));
      else {
        const r = new Xt(a, this);
        this.nodeMap.set(r.id, r), this.inDegree.set(r, 0), this.skipDegree.set(r, 0), this.targetListMap.set(r, []), this.sourceListMap.set(r, []), this.nodeInEdgesMap.set(r, []), this.nodeOutEdgesMap.set(r, []);
      }
    }
    this.edgeMap.forEach((s) => {
      const a = this.nodeMap.get(s.sourceNodeId), r = this.nodeMap.get(s.targetNodeId);
      !a || !r || (this.nodeInEdgesMap.get(r).push(s), this.nodeOutEdgesMap.get(a).push(s), this.targetListMap.get(a).push(r), this.sourceListMap.get(r).push(a), this.inDegree.set(r, this.inDegree.get(r) + 1));
    }), this.nodes = Array.from(this.nodeMap.values()), this.initSubModel();
  }
  nodes = [];
  nodeMap = /* @__PURE__ */ new Map();
  edgeMap = /* @__PURE__ */ new Map();
  inDegree = /* @__PURE__ */ new WeakMap();
  // 节点入度(前置节点个数)
  skipDegree = /* @__PURE__ */ new WeakMap();
  // 节点跳过次数
  targetListMap = /* @__PURE__ */ new WeakMap();
  // 后置节点邻接表
  sourceListMap = /* @__PURE__ */ new WeakMap();
  // 前驱节点邻接表
  nodeInEdgesMap = /* @__PURE__ */ new Map();
  // 节点输入边
  nodeOutEdgesMap = /* @__PURE__ */ new Map();
  // 节点输出边
  subModelMap = /* @__PURE__ */ new WeakMap();
  initSubModel() {
    this.nodes.forEach((t) => {
      const e = t.getChildren();
      if (e.length) {
        const s = new A({ cells: e }, !0);
        this.subModelMap.set(t, s);
      }
    });
  }
  reset() {
    for (const t of this.getNodes())
      this.inDegree.set(t, this.nodeInEdgesMap.get(t).length), this.skipDegree.set(t, 0), t.setExecuted(!1), t.setVisted(!1), t.getInputs().forEach((e) => e.setValue(e.unset)), t.getOutputs().forEach((e) => {
        e.setValue(e.unset), e.setSkiped(!1);
      });
  }
  getSubModel(t) {
    return typeof t == "string" && (t = this.nodeMap.get(t)), this.subModelMap.get(t);
  }
  setSubModel(t, e) {
    typeof t == "string" && (t = this.nodeMap.get(t)), t && this.subModelMap.set(t, e);
  }
  getNodes() {
    return this.nodes;
  }
  /**
   * 获取根节点
   */
  getRoots() {
    return Array.from(this.nodeMap.values()).filter(
      (t) => this.inDegree.get(t) === 0 && (this.sub ? !0 : !t.parentId)
    );
  }
  /**
   * 获取叶子节点
   */
  getLeafs() {
    return Array.from(this.nodeMap.values()).filter(
      (t) => this.targetListMap.get(t).length === 0 && (this.sub ? !0 : !t.parentId)
    );
  }
  getNodeById(t) {
    return this.nodeMap.get(t);
  }
  getEdgeById(t) {
    return this.edgeMap.get(t);
  }
  getNodeInEdges(t) {
    return this.nodeInEdgesMap.get(t);
  }
  getNodeOutEdges(t) {
    return this.nodeOutEdgesMap.get(t);
  }
  /**
   * 重置 node 节点信息
   */
  resetNode(t, e) {
    t.setMetadata(e);
  }
  /**
   * 获取一个节点前置节点
   */
  getSourceNodes(t) {
    return this.sourceListMap.get(t);
  }
  /**
   * 获取一个节点的后置节点
   */
  getTargetNodes(t) {
    return this.targetListMap.get(t);
  }
  /**
   * 层级遍历图
   */
  async bfs(t) {
    const { promise: e, resolve: s, reject: a } = Promise.withResolvers(), r = this.getRoots();
    for (; r.length > 0; ) {
      const i = r.length;
      await t(r).then(() => {
        for (let n = 0; n < i; n++) {
          const l = r.shift();
          l.setVisted(!0);
          const u = this.targetListMap.get(l).filter((c) => !c.isVisited());
          for (const c of u)
            this.inDegree.set(c, this.inDegree.get(c) - 1), this.inDegree.get(c) === 0 && r.push(c);
        }
      }).catch((n) => {
        r.length = 0, a(n);
      });
    }
    return s(), e;
  }
  skipNode(t, e = !0) {
    const s = (r) => {
      r.setVisted(!0);
      const i = this.getTargetNodes(r);
      i.forEach((n) => this.inDegree.set(n, this.inDegree.get(n) - 1)), e && i.forEach((n) => this.skipNode(n, e));
    }, a = this.getSourceNodes(t);
    a.length === 1 ? s(t) : (this.skipDegree.set(t, this.skipDegree.get(t) + 1), this.skipDegree.get(t) === a.length && s(t));
  }
  /**
   * 跳过某个节点输出端口
   */
  skipNextByOutput(t, e, s = !0) {
    if (typeof t == "string" && (t = this.getNodeById(t)), !t) return;
    const a = t.getOutput(e), i = this.nodeOutEdgesMap.get(t).filter((n) => n.sourcePortId === a.id).map((n) => this.nodeMap.get(n.targetNodeId));
    a.setSkiped(!0);
    for (const n of i)
      this.skipNode(n, s);
  }
  /**
   * 跳过指定节点的后续节点
   */
  skipNext(t, e = !0) {
    if (typeof t == "string" && (t = this.getNodeById(t)), !!t) {
      t.getOutputs().forEach((s) => s.setSkiped(!0));
      for (const s of this.getTargetNodes(t))
        this.skipNode(s, e);
    }
  }
  getOutputs() {
    return Object.fromEntries(
      this.getLeafs().map((t) => {
        const e = t.getOutputs().map((s) => [s.key, s.getValue()]);
        return [t.id, Object.fromEntries(e)];
      })
    );
  }
  getFirstOutput() {
    const t = this.getLeafs();
    if (t.length === 0) return;
    const s = t[0].getOutputs();
    return s.length > 0 ? s[0].getValue() : void 0;
  }
}
class te {
  map = /* @__PURE__ */ new Map();
  formatKey(t) {
    return Array.isArray(t) ? t.join(".") : t;
  }
  set(t, e) {
    this.map.set(this.formatKey(t), e);
  }
  get(t) {
    return this.map.get(this.formatKey(t));
  }
  merge(t) {
    for (const [e, s] of t.map.entries())
      this.map.set(e, s);
  }
  delete(t) {
    this.map.delete(this.formatKey(t));
  }
  clear() {
    this.map.clear();
  }
}
const ee = new Zt();
class se extends Ot {
  static batchFlowMap = /* @__PURE__ */ new Map();
  static async start(t) {
    const { resolve: e, reject: s, promise: a } = Promise.withResolvers();
    try {
      const r = this.batchFlowMap.get(t) || [], i = r.flatMap((n) => n.model.getNodes().map((l) => Z.resolve(l.filePath)));
      await Promise.all(Array.from(new Set(i)).map((n) => P.loadFile(n, !0))), await Promise.all(r.map((n) => Promise.all([n.initDefaultDateSource(), n.registerModelNode()]))), await p.initializeRl(t);
    } catch (r) {
      console.log("Error starting flow:", r), s(!1);
    }
    return e(!0), a;
  }
  static async close(t) {
    await p.close(t), R.clear(t), this.batchFlowMap.get(t)?.forEach((e) => {
      e.removeAllListeners(), e.getContext().clear();
    }), this.batchFlowMap.delete(t);
  }
}
class w extends se {
  constructor(t, e = Et()) {
    super(), this.id = e, typeof t == "string" && (t = JSON.parse(t));
    const { globalData: s, bizData: a, cells: r } = t;
    this.globalData = v({}, s), this.bizData = v({}, a), this.model = new A({ cells: r }), this.batchId = this.getGlobalData("batchId", ""), w.batchFlowMap.has(this.batchId) || w.batchFlowMap.set(this.batchId, []), w.batchFlowMap.get(this.batchId).push(this);
  }
  model;
  context = new te();
  // readonly id!: string
  isDebug = !1;
  // 全局参数
  globalData = {};
  // 业务数据
  bizData = {};
  batchId = "";
  initDefaultDateSource() {
    try {
      const t = {
        type: process.env.VITE_APP_DATASOURCE_TYPE,
        ...this.getGlobalData("datasource", {})
      }, e = {
        type: "openplant",
        ...this.getGlobalData("openplant", {}),
        rt: !0
      };
      p.connect(this.batchId, t), p.connect(this.batchId, e);
    } catch (t) {
      console.log("Error initializing default connections:", t);
    }
  }
  async registerModelNode(t) {
    t = t || this.model;
    const e = t.getNodes();
    return await Promise.all(e.map((s) => s.registerNode?.(this.model, this)));
  }
  registerDataSource(t) {
    p.connect(this.batchId, t);
  }
  registerRtGn(t) {
    t?.length && R.addGns(this.batchId, t);
  }
  getGlobalDatas() {
    return this.globalData;
  }
  getGlobalData(t, e) {
    return h(this.globalData, t, e);
  }
  setGlobalData(t) {
    return v(this.globalData, t);
  }
  setGlobalDataKV(t, e) {
    L(this.globalData, t, e);
  }
  getBizData(t, e) {
    return h(this.bizData, t, e);
  }
  setBizData(t) {
    return v(this.bizData, t);
  }
  getContext() {
    return this.context;
  }
  extendContext(t) {
    this.context.merge(t);
  }
  emitFlowEvent(t, e) {
    this.emit("log", {
      // id: this.id,
      level: "info",
      label: t,
      timestamp: Date.now(),
      message: e,
      metadata: {}
    });
  }
  emitNodeLog(t, e, s = void 0) {
    this.emit("log", {
      // id: id,
      level: "info",
      label: e,
      message: s,
      timestamp: Date.now(),
      metadata: {
        id: t.id,
        // path: path || filePath,
        // exportName,
        inputs: e === "NODE:START" || e === "NODE:ERROR" ? t.getInputs().map((a) => {
          const r = a.isUnset() ? a.getFormatedValue(this.getContext()) : a.getValue();
          return {
            key: a.key,
            name: a.name,
            value: N(r)
          };
        }) : void 0,
        outputs: e === "NODE:END" ? t.getOutputs().map((a) => {
          const r = a.getValue();
          return {
            key: a.key,
            name: a.name,
            value: N(r),
            skiped: a.isSkiped()
          };
        }) : void 0
      }
    });
  }
  async execNode(t, e) {
    const { promise: s, reject: a, resolve: r } = Promise.withResolvers(), { export: i, filePath: n } = t;
    return this.emitNodeLog(t, "NODE:START"), ee.evaluate(t.id, n, i, { flow: this, model: e }).then((l) => {
      this.emitNodeLog(t, "NODE:END"), r(l);
    }).catch((l) => {
      console.log("NODE:ERROR ----====>>>>>>>", Date(), l), this.emitNodeLog(t, "NODE:ERROR", l.message || l), a(l.message || l);
    }), s;
  }
  async run() {
    const { promise: t, resolve: e } = Promise.withResolvers();
    this.emitFlowEvent("FLOW:START");
    const s = this.getGlobalData("triggerTime");
    return R.queryRealtime(this.batchId, s).then(() => {
      this.runModel(this.model, null).then(async () => {
        await R.saveRealtime(this.batchId, s), this.emitFlowEvent("FLOW:END"), e(!0);
      }).catch((a) => {
        this.emitFlowEvent("FLOW:ERROR", a.message), e(!1);
      }).finally(() => {
        this.context.clear(), this.model.reset();
      });
    }).catch((a) => {
      this.emitFlowEvent("FLOW:ERROR", a.message), e(!1);
    }), t;
  }
  /**
   * 手动运行一个模型
   */
  async runModel(t, e) {
    return t.bfs((s) => Promise.all(s.map((a) => this.execNode(a, t))));
  }
  getOutputs(t) {
    return t = t || this.model, t.getOutputs();
  }
}
class ut extends w {
  isDebug = !0;
  breakPoints = /* @__PURE__ */ new Set();
  nodeResolve;
  nodeReject;
  shouldBreak = !1;
  addBreakPoint(t) {
    this.breakPoints.add(t);
  }
  removeBreakPoint(t) {
    this.breakPoints.delete(t);
  }
  isBreakPointNode(t) {
    return this.breakPoints.has(t);
  }
  setInput(t, e) {
    const s = JSON.parse(e);
    this.model.getNodeById(t)?.setMetadata(s);
  }
  async traverseModel(t) {
    return new Promise((e, s) => {
      t.bfs(async (a) => {
        const { promise: r, reject: i, resolve: n } = Promise.withResolvers();
        for (const l of a) {
          if (this.shouldBreak) break;
          const { promise: u, resolve: c, reject: d } = Promise.withResolvers();
          this.nodeResolve = c, this.nodeReject = d, u.catch((g) => {
            i(g), this.shouldBreak = !0;
          }), this.isBreakPointNode(l.id) ? await u.then(() => this.execNode(l, t).catch(d)).catch(i) : await this.execNode(l, t).catch(d);
        }
        return n(void 0), r;
      }).then(e).catch(s);
    });
  }
  async stop() {
    return await Promise.resolve(this.nodeReject?.("stop")).then(async () => ut.close(this.id)).catch();
  }
  async next() {
    return await Promise.resolve(this.nodeResolve?.());
  }
  async runModel(t, e) {
    e && this.emit("log", {
      level: "info",
      label: "GROUP:RESET",
      timestamp: Date.now(),
      metadata: { id: e.id }
    }), await this.traverseModel(t);
  }
}
export {
  V as BaseOperator,
  nt as ConnectionManager,
  te as Context,
  z as DataTransform,
  y as DataTypeEnum,
  _ as Database,
  ut as DebugFlow,
  Ct as DefaultOutput,
  Qt as FileLoader,
  w as Flow,
  D as Input,
  $ as InternalDatabase,
  A as Model,
  Xt as Node,
  it as OPConnectionPool,
  Vt as OnAfterExec,
  B as OnBeforeExec,
  R as OpenPlant,
  At as Operator,
  kt as Output,
  Tt as Property,
  Zt as Runner,
  p as connectionManager,
  q as createOperatorClass,
  K as dataTransformMetaKey,
  rt as defaultOutputMetaKey,
  P as fileLoader,
  m as gnListMap,
  et as inputMetaKey,
  ve as machineId,
  F as onAfterExecMetaKey,
  G as onBeforeExecMetaKey,
  tt as operatorMetaKey,
  st as outputMetaKey,
  at as propertyMetaKey,
  M as realtimeDataMap,
  N as sparseData,
  b as tempSaveRealtimeMap,
  W as toConstantValue
};
