#!/bin/sh

# 日志文件
LOG_FILE=${1:-"./node_output.log"}
# 进程 pid 文件
PID_FILE="./node.pid"

if [ -f "$PID_FILE" ] && kill -0 "$(cat "$PID_FILE")" 2>/dev/null; then
    echo "服务已在运行 (PID: $(cat "$PID_FILE"))"
    exit 1
fi

# 后台启动 node 服务
nohup ./node_runtime/node --experimental-vm-modules ./server/index.js >> "$LOG_FILE" 2>&1 &

# 将进程ID写入文件
echo $! > "$PID_FILE"

echo "Node.js 服务已在后台运行"
echo "日志文件: $LOG_FILE"
echo "进程 ID (PID): $(cat "$PID_FILE")"