#!/bin/sh

# 日志文件
LOG_FILE=${1:-"./node_output.log"}
# 进程 pid 文件
PID_FILE="./node.pid"

# 尝试通过 PID 文件结束进程
if [ -f "$PID_FILE" ]; then
    PID=$(cat "$PID_FILE")
    if kill -0 "$PID" 2>/dev/null; then
        kill "$PID"
        echo "已终止进程 (PID: $PID)"
    else
        echo "进程不存在或已结束 (PID: $PID)"
    fi
    rm -f "$PID_FILE"
else
    # 如果没有 PID 文件，则通过进程名查找并结束
    PID=$(pgrep -f "./node_runtime/node --experimental-vm-modules index.js")
    if [ -n "$PID" ]; then
        kill "$PID"
        echo "已终止进程 (PID: $PID)"
    else
        echo "未找到运行的 Node.js 进程"
    fi
fi

# 清空日志文件（可选）
# cat /dev/null > "$LOG_FILE"